return  Class(function(self, inst)
self.inst = inst

local NEONCOLOUR_MODE = {
    {   -- [1]導引下一個
        {.8, .8, .8, 1}, 3, nil, nil, .5
    },
    {   -- [3]已選取的標示
        {0, 0, 0, 0.1}, 0, nil, nil, .5
    },
}
local NEONTEXT_MODE = {
    {   -- [1]指標移入時顯示所有人
        {.5, 1, 0}, 30, 3, .5,
    },
    {   -- [2]導引下一個
        {1, 0, .5}, 52, 2, .5
    },
    {   -- [3]已選取的標示
        {.8, .5, .2}, 36, 2, .5
    },
}

----- 初始化 -----
inst.net_oid = net_ushortint(inst.GUID, "oid", "oid_dirty")
inst.net_lock = net_ushortint(inst.GUID, "lock", "lock_dirty")
inst.net_hid = net_ushortint(inst.GUID, "hid", "hid_dirty")
inst.net_neontext = net_tinybyte(inst.GUID, "neontext", "neontext_dirty")
if TheNet:GetIsClient() then
    inst:ListenForEvent("oid_dirty", function(inst)
        inst.oid = inst.net_oid:value()
        if inst.oid == 0 then
            inst.oid = nil
        end
    end)
    inst:ListenForEvent("lock_dirty", function(inst)
        inst.lock = inst.net_lock:value()
        if inst.lock == 0 then
            inst.lock = nil
        end
        if inst.lock ~= nil then
            self:AddLock(inst.lock)
        else
            self:RemoveLock()
        end
    end)
    inst:ListenForEvent("hid_dirty", function(inst)
        inst.hid = inst.net_hid:value()
        if inst.hid == 0 then
            inst.hid = nil
        end
    end)
    inst:ListenForEvent("neontext_dirty", function(inst)
        self:SetNeonText(inst.net_neontext:value())
    end)
end

----- 固定提示效果 -----
local animloop = {}
table.insert(animloop, function(cb)
    inst:StartThread(function()
        while MH.inst:HasTag("animlock") do
            Sleep(0.2)
        end
        cb()
    end)
end)
table.insert(animloop, function(cb)
    inst:StartThread(function()
        while inst:HasTag("guidemyhome") do
            Sleep(0.2)
        end
        cb()
    end)
end)

----- 改變顏色 -----
function self:SetNeonColour(mode, cb)
    if inst.lock_neoncolour ~= true then
        local anim = inst.AnimState
        local mc1 = NEONCOLOUR_MODE[mode][1] or {1, 1, 1, 1}
        local light1 = NEONCOLOUR_MODE[mode][2] or 1
        local mc2 = NEONCOLOUR_MODE[mode][3] or {1, 1, 1, 1}
        local light2 = NEONCOLOUR_MODE[mode][4] or 0
        local sec = NEONCOLOUR_MODE[mode][5] or .5

        anim:SetMultColour(mc1[1],mc1[2],mc1[3],mc1[4])
        anim:SetLightOverride(light1)
        inst.lock_neoncolour = true

        if type(cb) == "number" then
            cb = animloop[cb]
        end
        local restore = function()
            anim:SetMultColour(mc2[1],mc2[2],mc2[3],mc2[4])
            anim:SetLightOverride(light2)
            inst.lock_neoncolour = nil
        end
        inst:DoTaskInTime(sec, function()
            if cb ~= nil then cb(restore) else restore() end
        end)
    end
    return nil
end

----- 顯示文字 -----
function self:SetNeonText(text, mode, cb)
    if inst.lock_neontext ~= true and text ~= 0 then
        if TheWorld.ismastersim then
            -- 伺服器端發送的說話顯示須轉換
            if type(text) == "number" then
                inst.net_neontext:set(text)
            end
        end
        if type(text) == "number" then
            if text == 2 then
                text, mode, cb = MyHome_LANG["A13"], 2, 2
            end
        end

        local label
        local rgb = NEONTEXT_MODE[mode][1] or {1, 1, 1}
        local size = NEONTEXT_MODE[mode][2] or 24
        local offset = NEONTEXT_MODE[mode][3] or 2
        local sec = NEONTEXT_MODE[mode][4] or .5
        local text = text or ""
        if inst.Label then
            label = inst.Label
        else
            label = inst.entity:AddLabel()
        end
        label:SetFont(DEFAULTFONT)
        label:SetFontSize(size)
        label:SetWorldOffset(0, offset, 0)
        label:SetColour(rgb[1],rgb[2],rgb[3])
        label:SetText(text)
        label:Enable(true)
        inst.lock_neontext = true

        if type(cb) == "number" then
            cb = animloop[cb]
        end
        local restore = function()
            inst.Label:Enable(false)
            inst.lock_neontext = false
            inst.net_neontext:set(0)
        end
        inst:DoTaskInTime(sec, function()
            if cb ~= nil then cb(restore) else restore() end
        end)
    end
    return nil
end

----- 發送焦點 -----
function self:SendFocus(doer)
    MH:HandleMyHome(inst, doer)
end

----- 綁定動作 -----
function self:AddAction(doer, actions, right)
    local mid = MH.players[doer.userid]
    local ismy = mid == inst.oid and true
    if not ismy and inst.oid ~= nil then
        self:SetNeonText(MH:GetPlayerNameByMid(inst.oid), 1)
    end
    if MH.inst:HasTag("animlock") and MH.inst:HasTag(doer.userid) and inst:HasTag("guidemyhome") then
        if TheWorld.ismastersim then
            self:SendFocus(doer)
        else
            local x, y, z = inst.Transform:GetWorldPosition()
            SendModRPCToServer(MOD_RPC["wall"]["OnFocus"], x, y, z)
        end
    end
    if right and inst.oid ~= nil then
        local fn
        if ismy then
            if inst.hid ~= nil then
                fn = ACTIONS.MYHOME_UNLOCK
            elseif inst.lock ~= nil then
                fn = ACTIONS.MYHOME_SELFLOCK
            else
                fn = ACTIONS.MYHOME_SELF
            end
        elseif MyHome_ALLOW_ADMIN == true and doer.Network:IsServerAdmin() and inst.hid ~= nil then
            fn = ACTIONS.MYHOME_UNLOCK
        elseif MH:GetFriendsByMid(inst.oid, mid) == true then
            if inst.lock ~= nil then
                fn = ACTIONS.MYHOME_FRIENDSLOCK
            else
                fn = ACTIONS.MYHOME_FRIENDS
            end
        else
            if inst.lock ~= nil then
                fn = ACTIONS.MYHOME_NOSELFLOCK
            else
                fn = ACTIONS.MYHOME_NOSELF
            end
        end
        table.insert(actions, fn)
    end
end

----- 綁定右鍵觸發訊息 -----
function self:ClickRight(doer, level)
    if MH.inst:HasTag("lock") then
        if MH.inst:HasTag(doer.userid) ~= true then
            MH:Talker(doer, MyHome_LANG["B1"])
        end
        return true
    end
    local say = ""
    if level == 0 then
        say = MyHome_LANG["B2"](MH:GetPlayerNameByMid(inst.oid), MH:GetSidByPlayer(doer))
    elseif level == 10 then
        say = MyHome_LANG["B3"](MH:GetPlayerNameByMid(inst.oid), MH:GetSidByPlayer(doer))
    elseif level == 1 then
        say = MyHome_LANG["B4"](MH:GetPlayerNameByMid(inst.oid))
    elseif level == 11 then
        say = MyHome_LANG["B5"](MH:GetPlayerNameByMid(inst.oid))
    elseif level == 2 then
        say = MyHome_LANG["B6"]
        if TheWorld.ismastersim then
            inst:DoTaskInTime(1, function()
                MH:ReceiverMyHome(inst, doer)
            end)
        end
    elseif level == 12 then
        say = MyHome_LANG["B7"]
    elseif level == 13 then
        say = MyHome_LANG["B8"]
        if TheWorld.ismastersim then
            inst:DoTaskInTime(1, function()
                MH:CancelMyHome(inst, doer)
            end)
        end
    end

    MH:Talker(doer, say)
    return true
end

----- 添加鎖定 -----
local _workable = nil
local _health = nil
local _combat_onhitfn = nil
local _flammability = nil
local _flashpoint = nil
local _OnLoad = nil
function self:AddLock(lockid)
    inst.lock = tonumber(lockid)
    if TheWorld.ismastersim then
        inst.net_lock:set(lockid or 0)
        inst:AddTag("lockmyhome")
        inst:AddTag("myhome_"..inst.lock)
    end

    if inst.components.workable ~= nil then
        _workable = inst.components.workable
        inst.components.workable = nil
    end
    if inst.components.health ~= nil then
        _health = inst.components.health
        inst.components.health = nil
    end
    if inst.components.combat ~= nil then
        _combat_onhitfn = inst.components.combat.onhitfn
        inst.components.combat.onhitfn = nil
    end
    if inst.components.burnable ~= nil then
        if TheWorld.ismastersim then
            inst:RemoveTag("canlight")
            inst:AddTag("nolight")
            inst:AddTag("fireimmune")
        end
        _flammability = inst.components.burnable.flammability
        inst.components.burnable.flammability = 0
        _flashpoint = inst.components.propagator.flashpoint
        inst.components.propagator.flashpoint = 0
    end
    if inst.OnLoad ~= nil then
        _OnLoad = inst.OnLoad
        inst.OnLoad = nil
    end
end

----- 取消鎖定 -----
function self:RemoveLock()
    if TheWorld.ismastersim then
        inst:RemoveTag("lockmyhome")
        inst:RemoveTag("myhome_"..inst.lock)
        inst.net_lock:set(0)
    end

    inst.lock = nil
    if _workable ~= nil then
        inst.components.workable = _workable
        _workable = nil
    end
    if _health ~= nil then
        inst.components.health = _health
        _health = nil
    end
    if _combat_onhitfn ~= nil then
        inst.components.combat.onhitfn = _combat_onhitfn
        _combat_onhitfn = nil
    end
    if inst.components.burnable ~= nil then
        if TheWorld.ismastersim then
            inst:AddTag("canlight")
            inst:RemoveTag("nolight")
            inst:RemoveTag("fireimmune")
        end
        inst.components.burnable.flammability = _flammability
        inst.components.propagator.flashpoint = _flashpoint
    end
    if _OnLoad ~= nil then
        inst.OnLoad = _OnLoad
        _OnLoad = nil
    end
end

----- 權限保存與加載 -----
local SAVEPARAMS = {
    "oid",  -- 建造者的MID
    "lock", -- 是否鎖定
    "hid",  -- 是否起點
}

function self:SetOid(newoid)
    if MH.players[newoid] ~= nil then
        newoid = MH.players[newoid]
    end
    if TheWorld.ismastersim then
        inst.net_oid:set(newoid or 0)
        inst.oid = newoid
    end
end

function self:SetHid(newhid)
    if TheWorld.ismastersim then
        inst.net_hid:set(newhid or 0)
        inst.hid = newhid
    end
end

self.inst.OldOnSave = self.inst.OnSave
self.inst.OnSave = function(inst, data)
    if inst.OldOnSave ~= nil then
        inst.OldOnSave(inst,data)
    end
    for _, v in ipairs(SAVEPARAMS) do
        if inst[v] ~= nil then
            data[v] = inst[v]
        end
    end
end

self.inst.OldOnLoad = self.inst.OnLoad
self.inst.OnLoad = function(inst,data)
    if inst.OldOnLoad ~= nil then
        inst.OldOnLoad(inst,data)
    end
    if data ~= nil then
        if data.oid ~= nil then
            self:SetOid(data.oid)
        end
        if data.lock ~= nil then
            self:AddLock(data.lock)
        end
        if data.hid ~= nil then
            self:SetHid(data.hid)
        end
    end
end
end)
