local assets =
{ 
    Asset("ANIM", "anim/duck_swap.zip"),
    Asset("ANIM", "anim/duck.zip"), 

    Asset("ATLAS", "images/inventoryimages/duck.xml"),
    Asset("IMAGE", "images/inventoryimages/duck.tex"),
}

local prefabs = 
{
}


 local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_hat", "duck_swap", "swap_hat")
	
    owner.AnimState:Show("HAT")
        
        if owner:HasTag("player") then

        end

        if inst.components.fueled ~= nil then
            inst.components.fueled:StartConsuming()
        end
end

	
local function OnUnequip(inst, owner) 

    owner.AnimState:Hide("HAT")
	
	
    if owner:HasTag("player") then

		
    end
	if inst.components.fueled ~= nil then
       inst.components.fueled:StopConsuming()
    end
end
	
	   local function hive_onunequip(inst, owner)
        onunequip(inst, owner)

        if owner ~= nil and owner.components.sanity ~= nil then
            owner.components.sanity.neg_aura_absorb = 0
        end
    end

    local function hive_onequip(inst, owner)
        onequip(inst, owner)

        if owner ~= nil and owner.components.sanity ~= nil then
            owner.components.sanity.neg_aura_absorb = TUNING.ARMOR_HIVEHAT_SANITY_ABSORPTION
        end
    end
	
local function fn()

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("duck")
    inst.AnimState:SetBuild("duck")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("hat")

    if not TheWorld.ismastersim then
	    return inst
    end

		
    
    inst:AddComponent("inspectable")
   
	inst:AddComponent("tradable")
	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "duck"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/duck.xml"

	if CurrentRelease.GreaterOrEqualTo("R08_ROT_TURNOFTIDES") then
	MakeInventoryFloatable(inst, "med", 0.1, 0.65)
	end

	MakeHauntableLaunch(inst)

    return inst
end


return  Prefab("common/inventory/duck", fn, assets, prefabs)
