PrefabFiles = {	
	"boatlip_common",
	"shipyard_rope",
	"boat_support",
	"waveyjones_new"
}
if GetModConfigData("shipyard") then
	local extra = {
	"extra_fx",	
	"boat_plant",
	"shipyard_flag",
	"shipyard_arrow",
	"shipyard_builder"
	}
	for _, prefab in pairs(extra) do
		table.insert(PrefabFiles, prefab)
	end
end
table.insert(PrefabFiles, "boats_def") --add after to maintain recipe order

---- Improve Steering Animation ----
local function SteerInDir(self, dir_x, dir_z)
	-- if you are on a boat and the target heading is close enough to the current heading, don't do a steer. 
	local dontsteer = false
	local rx, rz = 0, 0
	if self.boat ~= nil then
		self.boat.components.boatphysics:SetTargetRudderDirection(dir_x, dir_z)

		local tx,tz = self.boat.components.boatphysics:GetTargetRudderDirection()

		rx,rz = self.boat.components.boatphysics:GetRudderDirection()
		local TOLLERANCE = 0.1

		if math.abs(tx - rx)<TOLLERANCE and math.abs(tz - rz)<TOLLERANCE then
			dontsteer = true
		end
	end
	if not dontsteer then
		self.should_play_left_turn_anim = (rz * dir_x - rx * dir_z) > 0
		self.inst:PushEvent("set_heading")
	end
end

local function replace_player(inst)
	if inst.components.steeringwheeluser ~= nil then
		inst.components.steeringwheeluser.SteerInDir = SteerInDir
	end
end

AddPlayerPostInit(replace_player)

---- Tune cookie cutter for new shape ---
local function replace_cookie(inst)
	if GLOBAL.TheWorld.ismastersim then
    	inst:SetBrain(require("brains/cookiecutterbrain_new"))
	end
end

AddPrefabPostInit("cookiecutter", replace_cookie)

---- Improve collision ----
local function replace_physics(inst)
	GLOBAL.MakeInventoryPhysics(inst)
    inst.Physics:CollidesWith(GLOBAL.COLLISION.ITEMS)
end
AddPrefabPostInit("boatfragment03", replace_physics)
AddPrefabPostInit("boatfragment04", replace_physics)
AddPrefabPostInit("boatfragment05", replace_physics)
AddPrefabPostInit("bullkelp_plant", replace_physics)

---- Map Util for new shapes ----
GLOBAL.require "components/map"

local WALKABLE_PLATFORM_TAGS = {"walkableplatform"}
function GLOBAL.Map:GetPlatformAtPoint(pos_x, pos_y, pos_z, extra_radius)
	if pos_z == nil then
		pos_z = pos_y
		pos_y = 0
	end
    local entities = GLOBAL.TheSim:FindEntities(pos_x, pos_y, pos_z, TUNING.MAX_WALKABLE_PLATFORM_RADIUS, WALKABLE_PLATFORM_TAGS)
    for i, v in ipairs(entities) do
		if v.components.walkableplatform then
			if v.is_point_on_boat_with_bias ~= nil then
				if v:is_point_on_boat_with_bias(pos_x, pos_y, pos_z, extra_radius or 0) then
					return v
				end
			else
				if math.sqrt(v:GetDistanceSqToPoint(pos_x, 0, pos_z)) <= v.components.hull:GetRadius() + (extra_radius or 0) then
					return v
				end
			end
		end
    end
    return nil
end

function GLOBAL.Map:CanDeployAtPointInWater(pt, inst, mouseover, data)
    local tile = self:GetTileAtPoint(pt.x, pt.y, pt.z)
    if tile == GLOBAL.GROUND.IMPASSABLE or tile == GLOBAL.GROUND.INVALID then
        return false
    end
    -- check if there's a boat in the way
    local min_distance_from_boat = (data and data.boat) or 0
    local radius = (data and data.radius) or 0
    local entities = GLOBAL.TheSim:FindEntities(pt.x, 0, pt.z, GLOBAL.TUNING.MAX_WALKABLE_PLATFORM_RADIUS + radius + min_distance_from_boat, WALKABLE_PLATFORM_TAGS)
    for i, v in ipairs(entities) do
		if v.components.walkableplatform then
			if v.is_point_on_boat_with_bias == nil then
				return false
			elseif v:is_point_on_boat_with_bias(pt.x, pt.y, pt.z, radius + min_distance_from_boat) then
				return false
			end
		end
    end
    local min_distance_from_land = (data and data.land) or 0
    return (mouseover == nil or mouseover:HasTag("player"))
        and self:IsDeployPointClear(pt, nil, min_distance_from_boat + radius)
        and self:IsSurroundedByWater(pt.x, pt.y, pt.z, min_distance_from_land + radius)
end

function GLOBAL.Map:IsPassableAtPointWithPlatformRadiusBias(x, y, z, allow_water, exclude_boats, platform_radius_bias, ignore_land_overhang)
	local valid_tile = self:IsAboveGroundAtPoint(x, y, z, allow_water) or ((not ignore_land_overhang) and self:IsVisualGroundAtPoint(x,y,z) or false)
    if not allow_water and not valid_tile then
        if not exclude_boats then
            local entities = GLOBAL.TheSim:FindEntities(x, 0, z, TUNING.MAX_WALKABLE_PLATFORM_RADIUS + platform_radius_bias, WALKABLE_PLATFORM_TAGS)
            for i, v in ipairs(entities) do
                local walkable_platform = v.components.walkableplatform
                if walkable_platform ~= nil then
					if v.is_point_on_boat_with_bias then
						if  v:is_point_on_boat_with_bias(x, y, z, platform_radius_bias) then
							return true
						end
					else
			            local platform_x, platform_y, platform_z = v.Transform:GetWorldPosition()
			            local distance_sq = GLOBAL.VecUtil_LengthSq(x - platform_x, z - platform_z)
						if distance_sq <= walkable_platform.radius * walkable_platform.radius then
		                	return true
						end
					end
                end
            end
        end
		return false
    end
	return valid_tile
end

-- Transmit placer rotation to can_deploy_fn--
local function newdeploy(act)
	local act_pos = act:GetActionPoint()
    if act.invobject ~= nil and act.invobject.components.deployable ~= nil  then
		act.invobject.deploy_rotation = act.rotation  --the newline, to pass angle from client to master
		if act.invobject.components.deployable:CanDeploy(act_pos, nil, act.doer) then
		    local container = act.doer.components.inventory or act.doer.components.container
		    local obj = container ~= nil and container:RemoveItem(act.invobject) or nil
		    if obj ~= nil then
		        if obj.components.deployable:Deploy(act_pos, act.doer, act.rotation) then
		            return true
		        else
		            container:GiveItem(obj)
				end
            end
        end
    end
end

GLOBAL.ACTIONS["DEPLOY"].fn = newdeploy

----boarding smoothing----
local function locomotor_OnUpdate(self, dt)
    	if self.hopping then 
        self:UpdateHopping(dt) 
        return
    end

    if not self.inst:IsValid() then
        Print(VERBOSITY.DEBUG, "OnUpdate INVALID", self.inst.prefab)
        self:ResetPath()
        self:StopUpdatingInternal()
        return
    end

    if self.enablegroundspeedmultiplier then
        local x, y, z = self.inst.Transform:GetWorldPosition()
        local tx, ty = TheWorld.Map:GetTileCoordsAtPoint(x, 0, z)
        if tx ~= self.lastpos.x or ty ~= self.lastpos.y then
            self:UpdateGroundSpeedMultiplier()
            self.lastpos = { x = tx, y = ty }
        end
    end

    --Print(VERBOSITY.DEBUG, "OnUpdate", self.inst.prefab)
    if self.dest then
        --Print(VERBOSITY.DEBUG, "    w dest")
        if not self.dest:IsValid() or (self.bufferedaction and not self.bufferedaction:IsValid()) then
            self:Clear()
            return
        end

        if self.inst.components.health and self.inst.components.health:IsDead() then
            self:Clear()
            return
        end

        local destpos_x, destpos_y, destpos_z = self.dest:GetPoint()
        local mypos_x, mypos_y, mypos_z = self.inst.Transform:GetWorldPosition()

        local reached_dest, invalid
        if self.bufferedaction ~= nil and
            self.bufferedaction.action == ACTIONS.ATTACK and
            self.inst.replica.combat ~= nil then

            local dsq = distsq(destpos_x, destpos_z, mypos_x, mypos_z)
            local run_dist = self:GetRunSpeed() * dt * .5
            reached_dest = dsq <= math.max(run_dist * run_dist, self.arrive_dist * self.arrive_dist)
            if not reached_dest then
                reached_dest, invalid = self.inst.replica.combat:CanAttack(self.bufferedaction.target)
            end
        elseif self.bufferedaction ~= nil 
            and self.bufferedaction.action.customarrivecheck ~= nil then
            reached_dest, invalid = self.bufferedaction.action.customarrivecheck(self.inst, self.dest)
        else
            local dsq = distsq(destpos_x, destpos_z, mypos_x, mypos_z)
            local run_dist = self:GetRunSpeed() * dt * .5
            reached_dest = dsq <= math.max(run_dist * run_dist, self.arrive_dist * self.arrive_dist)
        end

        if invalid then
            self:Stop()
            self:Clear()
        elseif reached_dest then
            --Print(VERBOSITY.DEBUG, "REACH DEST")
            self.inst:PushEvent("onreachdestination", { target = self.dest.inst, pos = Point(destpos_x, destpos_y, destpos_z) })
            if self.atdestfn ~= nil then
                self.atdestfn(self.inst)
            end

            if self.bufferedaction ~= nil and self.bufferedaction ~= self.inst.bufferedaction then
                if self.bufferedaction.target ~= nil and self.bufferedaction.target.Transform ~= nil and not self.bufferedaction.action.skip_locomotor_facing then
                    self.inst:FacePoint(self.bufferedaction.target.Transform:GetWorldPosition())
                elseif self.bufferedaction.invobject ~= nil and not self.bufferedaction.action.skip_locomotor_facing then
                    local act_pos = self.bufferedaction:GetActionPoint() 
                    if act_pos ~= nil then
                        self.inst:FacePoint(act_pos:Get())
                    end
                end
                if self.ismastersim then
                    self.inst:PushBufferedAction(self.bufferedaction)
                else
                    self.inst:PreviewBufferedAction(self.bufferedaction)
                end
            end
            self:Stop()
            self:Clear()
        else
            --Print(VERBOSITY.DEBUG, "LOCOMOTING")
            if self:WaitingForPathSearch() then
                local pathstatus = TheWorld.Pathfinder:GetSearchStatus(self.path.handle)
                --Print(VERBOSITY.DEBUG, "HAS PATH SEARCH", pathstatus)
                if pathstatus ~= STATUS_CALCULATING then
                    --Print(VERBOSITY.DEBUG, "PATH CALCULATION complete", pathstatus)
                    if pathstatus == STATUS_FOUNDPATH then
                        --Print(VERBOSITY.DEBUG, "PATH FOUND")
                        local foundpath = TheWorld.Pathfinder:GetSearchResult(self.path.handle)
                        if foundpath then
                            --Print(VERBOSITY.DEBUG, string.format("PATH %d steps ", #foundpath.steps))

                            if #foundpath.steps > 2 then
                                self.path.steps = foundpath.steps
                                self.path.currentstep = 2

                                -- for k,v in ipairs(foundpath.steps) do
                                --     Print(VERBOSITY.DEBUG, string.format("%d, %s", k, tostring(Point(v.x, v.y, v.z))))
                                -- end

                            else
                                --Print(VERBOSITY.DEBUG, "DISCARDING straight line path")
                                self.path.steps = nil
                                self.path.currentstep = nil
                            end
                        else
                            Print(VERBOSITY.DEBUG, "EMPTY PATH")
                        end
                    else
                        if pathstatus == nil then
                            Print(VERBOSITY.DEBUG, string.format("LOST PATH SEARCH %u. Maybe it timed out?", self.path.handle))
                        else
                            Print(VERBOSITY.DEBUG, "NO PATH")
                        end
                    end

                    TheWorld.Pathfinder:KillSearch(self.path.handle)
                    self.path.handle = nil
                end
            end

            if not self.inst.sg or self.inst.sg:HasStateTag("canrotate") then
                --Print(VERBOSITY.DEBUG, "CANROTATE")
                local facepos_x, facepos_y, facepos_z = destpos_x, destpos_y, destpos_z

                if self.path and self.path.steps and self.path.currentstep < #self.path.steps then
                    --Print(VERBOSITY.DEBUG, "FOLLOW PATH")
                    local step = self.path.steps[self.path.currentstep]
                    local steppos_x, steppos_y, steppos_z = step.x, step.y, step.z

                    --Print(VERBOSITY.DEBUG, string.format("CURRENT STEP %d/%d - %s", self.path.currentstep, #self.path.steps, tostring(steppos)))

                    local step_distsq = distsq(mypos_x, mypos_z, steppos_x, steppos_z)
                    if step_distsq <= (self.arrive_step_dist)*(self.arrive_step_dist) then
                        self.path.currentstep = self.path.currentstep + 1

                        if self.path.currentstep < #self.path.steps then
                            step = self.path.steps[self.path.currentstep]
                            steppos_x, steppos_y, steppos_z = step.x, step.y, step.z

                            --Print(VERBOSITY.DEBUG, string.format("NEXT STEP %d/%d - %s", self.path.currentstep, #self.path.steps, tostring(steppos)))
                        else
                            --Print(VERBOSITY.DEBUG, string.format("LAST STEP %s", tostring(destpos)))
                            steppos_x, steppos_y, steppos_z = destpos_x, destpos_y, destpos_z
                        end
                    end
                    facepos_x, facepos_y, facepos_z = steppos_x, steppos_y, steppos_z
                end

                local x,y,z = self.inst.Physics:GetMotorVel()
                if x < 0 then
                    --Print(VERBOSITY.DEBUG, "SET ROT", facepos)
                    local angle = self.inst:GetAngleToPoint(facepos_x, facepos_y, facepos_z)
                    self.inst.Transform:SetRotation(180 + angle)
                else
                    --Print(VERBOSITY.DEBUG, "FACE PT", facepos)
                    self.inst:FacePoint(facepos_x, facepos_y, facepos_z)
                end
            end

            self.wantstomoveforward = self.wantstomoveforward or not self:WaitingForPathSearch()
        end
    end

    local should_locomote = false
    if (self.ismastersim and not self.inst:IsInLimbo()) or not (self.ismastersim or self.inst:HasTag("INLIMBO")) then
        local is_moving = self.inst.sg ~= nil and self.inst.sg:HasStateTag("moving")
        local is_running = self.inst.sg ~= nil and self.inst.sg:HasStateTag("running")
        --'not' is being used below as a cast-to-boolean operator
        should_locomote =
            (not is_moving ~= not self.wantstomoveforward) or
            (is_moving and (not is_running ~= not self.wantstorun))
    end

    if should_locomote then
        self.inst:PushEvent("locomote")
    elseif not self.wantstomoveforward and not self:WaitingForPathSearch() then
        self:ResetPath()
        self:StopUpdatingInternal()
    end

    local cur_speed = self.inst.Physics:GetMotorSpeed()
    if cur_speed > 0 then

        if self.allow_platform_hopping and (self.bufferedaction == nil or not self.bufferedaction.action.disable_platform_hopping) then            

            local mypos_x, mypos_y, mypos_z = self.inst.Transform:GetWorldPosition()

            local destpos_x, destpos_y, destpos_z
            destpos_y = 0

            local rotation = self.inst.Transform:GetRotation() * DEGREES
            local forward_x, forward_z = math.cos(rotation), -math.sin(rotation)

            local dest_dot_forward = 0
			local dist = nil

            local map = TheWorld.Map
            local my_platform = map:GetPlatformAtPoint(mypos_x, mypos_z)

            if self.dest and self.dest:IsValid() then
                destpos_x, destpos_y, destpos_z = self.dest:GetPoint()
                local dest_dir_x, dest_dir_z = VecUtil_Normalize(destpos_x - mypos_x, destpos_z - mypos_z)
                dest_dot_forward = VecUtil_Dot(dest_dir_x, dest_dir_z, forward_x, forward_z)
                dist = VecUtil_Length(destpos_x - mypos_x, destpos_z - mypos_z)
                if dist <= 1.5 then
                    local other_platform = map:GetPlatformAtPoint(destpos_x, destpos_z)
                    if my_platform == other_platform then
                        dest_dot_forward = 1
                    end
                end

            end 

			local hop_distance = self:GetHopDistance(self:GetSpeedMultiplier())

            local forward_angle_span = 0.1
            if dest_dot_forward <= 1 - forward_angle_span or (dist and dist > hop_distance) then
                destpos_x, destpos_z = forward_x * hop_distance + mypos_x, forward_z * hop_distance + mypos_z
            end

			local is_ocean_at_dest = map:IsOceanAtPoint(destpos_x, 0, destpos_z, true)

            local can_hop = false
            local hop_x, hop_z, target_platform, blocked
            local too_early_top_hop = self.time_before_next_hop_is_allowed > 0
            if (is_ocean_at_dest or my_platform ~= nil) and not too_early_top_hop then
                can_hop, hop_x, hop_z, target_platform, blocked = self:ScanForPlatform(my_platform, destpos_x, destpos_z, hop_distance)
            end

            if not blocked then
                if can_hop then
                    self.last_platform_visited = my_platform 
                    self:StartHopping(hop_x, hop_z, target_platform)
                elseif self.inst.components.amphibiouscreature ~= nil and map:GetPlatformAtPoint(destpos_x, destpos_z) == nil and not self.inst.sg:HasStateTag("jumping") then
                    local dist = self.inst:GetPhysicsRadius(0) + 2.5
                    local _x, _z = forward_x * dist + mypos_x, forward_z * dist + mypos_z
                    if my_platform ~= nil then
                        local temp_x, temp_z, temp_platform = nil, nil, nil
                        can_hop, temp_x, temp_z, temp_platform, blocked = self:ScanForPlatform(nil, _x, _z, hop_distance)
                    end

                    if not can_hop and self.inst.components.amphibiouscreature:ShouldTransition(_x, _z) then
                        -- If my_platform ~= nil, we already ran the "is blocked" test as part of ScanForPlatform.
                        -- Otherwise, run one now.
                        if (my_platform ~= nil and not blocked) or 
                                not self:TestForBlocked(mypos_x, mypos_z, forward_x, forward_z, self.inst:GetPhysicsRadius(0), dist * 1.41421) then -- ~sqrt(2); _x,_z are a dist right triangle so sqrt(dist^2 + dist^2)
                            self.inst:PushEvent("onhop", {x = _x, z = _z})
                        end
                    end
                end
            end

            if (not can_hop and my_platform == nil and target_platform == nil and not self.inst.sg:HasStateTag("jumping")) and self.inst.components.drownable ~= nil and self.inst.components.drownable:ShouldDrown() then
                self.inst:PushEvent("onsink")
            end

        else
            local speed_mult = self:GetSpeedMultiplier()
            local desired_speed = self.isrunning and self:RunSpeed() or self.walkspeed
            if self.dest and self.dest:IsValid() then
                local destpos_x, destpos_y, destpos_z = self.dest:GetPoint()
                local mypos_x, mypos_y, mypos_z = self.inst.Transform:GetWorldPosition()
                local dsq = distsq(destpos_x, destpos_z, mypos_x, mypos_z)
                if dsq <= .25 then
                    speed_mult = math.max(.33, math.sqrt(dsq))
                end
            end

            self.inst.Physics:SetMotorVel(desired_speed * speed_mult, 0, 0)
        end
    end

    self.time_before_next_hop_is_allowed = math.max(self.time_before_next_hop_is_allowed - dt, 0)
end

local WALL_TAGS = { "wall" }
function ScanForPlatformInDir(self, my_platform, map, my_x, my_z, dir_x, dir_z, steps, step_size)
    local is_at_edge = self:IsAtEdge(my_platform, map, my_x, my_z, dir_x, dir_z)
    local is_first_hop_point = true
    for i = 1,steps do
        local pt_x, pt_z = my_x + dir_x * i * step_size, my_z + dir_z * i * step_size
        local platform = map:GetPlatformAtPoint(pt_x, pt_z)
        -- prevent jumping back onto the same platform because if you click an action and land near the edge of a platform
        -- you would sometimes turn around and jump right back
        if platform == nil or not (self.last_platform_visited == platform) then
            local is_water = not map:IsVisualGroundAtPoint(pt_x, 0, pt_z)
			if not is_water then
        		--search for nearby walls and fences with active physics.
                for _, v in ipairs(TheSim:FindEntities(math.floor(pt_x), 0, math.floor(pt_z), 1, WALL_TAGS)) do
                    if v ~= self.inst and
                    v.entity:IsVisible() and
                    v.components.placer == nil and
                    v.entity:GetParent() == nil and
                    v.Physics:IsActive() then
                        return false, 0, 0, nil
                    end
                end
            end
            if is_at_edge and platform ~= my_platform then
                if platform ~= nil or not is_water then
                    --print("SUCCESS!")
                    if is_first_hop_point then
                        is_first_hop_point = false
                    else
                        return true, pt_x, pt_z, platform
                    end
                end
            end
        end
    end
    return false, 0, 0, nil
end

local function copy_env(old, new)
    local env = {}
	for k, v in pairs(GLOBAL.getfenv(old)) do
		env[k] = v
	end
    local idx = 1
    while true do
        k, v = GLOBAL.debug.getupvalue(old, idx)
        if k == nil then
            break
        end
        env[k] = v
        idx = idx + 1
    end
    GLOBAL.setfenv(new, env)
end

local function replace_locomotor(locomotor)
	copy_env(locomotor.OnUpdate, locomotor_OnUpdate)
	locomotor.OnUpdate = locomotor_OnUpdate
	copy_env(locomotor.ScanForPlatformInDir, ScanForPlatformInDir)
	locomotor.ScanForPlatformInDir = ScanForPlatformInDir
end

AddComponentPostInit("locomotor", replace_locomotor)

local function postinitworld(inst)
	inst:AddComponent("shipyardmanager")
end
AddPrefabPostInit("world", postinitworld)

local function noshipyardblock(inst)
	inst:AddTag("NOSHIPYARDBLOCK")
end
AddPrefabPostInit("seeds", noshipyardblock)
AddPrefabPostInit("puffin", noshipyardblock)
AddPrefabPostInit("boards", noshipyardblock)

AddMinimapAtlas("minimap/worksite_panel.xml")