local function open_vertices_channel(inst, n)
	if not inst.vertices_positions then
		inst.vertices_positions = {}
		for i = 1, n do
			table.insert(inst.vertices_positions, net_float(inst.GUID, "vertices_x_"..i, "vertices_data"))
			table.insert(inst.vertices_positions, net_float(inst.GUID, "vertices_z_"..i, "vertices_data"))
		end
	end
end

local function send_vertices(inst, vertices)
	for k, v in pairs(vertices) do
		inst.vertices_positions[2 * k - 1]:set_local(v[1]) --for event
		inst.vertices_positions[2 * k - 1]:set(v[1])

		inst.vertices_positions[2 * k]:set_local(v[2])
		inst.vertices_positions[2 * k]:set(v[2])
	end
end

local function read_vertices(inst, n)
	local data = {}
	local i = 0
	local value
	repeat
		i = i + 1
		value = inst.vertices_positions[i]:value()
		table.insert(data, value)
	until i == 2 * n or not value or value == 0

	if not value or value == 0 then
		return
	end

	local vertices = {}
	for i = 1, n do
		table.insert(vertices, {data[2 * i - 1], data[2 * i]})
	end
	return vertices
end

local function send_data(inst, vertices)
	inst.vertices_length:set(#vertices)		
	inst.send_vertices = vertices
	inst.boat_data:set(inst.boat_data:value() or SpawnPrefab("boat_data"))

	inst:DoTaskInTime(0, function()
		open_vertices_channel(inst.boat_data:value(), #vertices)
		inst:DoTaskInTime(0, function()
			send_vertices(inst.boat_data:value(), vertices)
		end)
		inst:DoTaskInTime(1, function() --resend in case first event was not capted by client
			send_vertices(inst.boat_data:value(), vertices)
		end)
	end)
end

local function receive_data(inst, fn)
	
	local function finish()	
		local boat_data = inst.boat_data:value()
		local length = inst.vertices_length:value()
		local vertices = read_vertices(boat_data, length)
		if vertices then
			boat_data:RemoveEventCallback("vertices_data", finish)			
			fn(vertices)
		end
	end

	local function wait_vertices()
		inst:RemoveEventCallback("vertices.length", wait_vertices)
		local boat_data = inst.boat_data:value()
		local length = inst.vertices_length:value()

		open_vertices_channel(boat_data, length)
		local vertices = read_vertices(boat_data, length)

		if vertices then
			fn(vertices)
		else
			boat_data:ListenForEvent("vertices_data", finish)
		end	
	end

	local function wait_length()
		inst:RemoveEventCallback("boat_data.entity", wait_length)
		local boat_data = inst.boat_data:value()
		local length = inst.vertices_length:value()
		if length and length > 0 then
			wait_vertices(boat_data, length)
		else
			inst:ListenForEvent("vertices.length", wait_vertices)
		end
	end

	local function wait_boat_data()
		if inst.boat_data:value() then
			wait_length(inst.boat_data:value())
		else
			inst:ListenForEvent("boat_data.entity", wait_length)
		end
	end
	wait_boat_data()
end

local Boat_Data_NetWork = Class(function(self, inst)
    self.inst = inst

	inst.receive_data = receive_data
	inst.send_data = send_data	
end)

return Boat_Data_NetWork

