-- To identitfy client flag based on server Guid --

local nil_guid = 0

local function GetPrev(inst)
	if TheWorld.components.shipyardmanager and inst.prev_flag_guid then
		return TheWorld.components.shipyardmanager:Getinst(inst.prev_flag_guid:value())
	end
end

local function GetNext(inst)
	if TheWorld.components.shipyardmanager and inst.next_flag_guid then
		return TheWorld.components.shipyardmanager:Getinst(inst.next_flag_guid:value())
	end
end

local function SetPrev(inst, prev_flag)
	if prev_flag then
		inst.prev_flag_guid:set(prev_flag.sourceguid:value())
	else
		inst.prev_flag_guid:set(nil_guid)
	end
end

local function SetNext(inst, next_flag)
	if next_flag then
		inst.next_flag_guid:set(next_flag.sourceguid:value())
	else
		inst.next_flag_guid:set(nil_guid)
	end
end

local Shipyard = Class(function(self, inst)
    self.inst = inst

	inst.GetPrev = GetPrev
	inst.GetNext = GetNext
	inst.SetPrev = SetPrev
	inst.SetNext = SetNext

	inst.prev_flag_guid = net_uint(inst.GUID, "prev_flag", "prev_flag")
	inst.next_flag_guid = net_uint(inst.GUID, "next_flag")

	inst.protect = net_event(inst.GUID, "protect", "protect")
	inst.unprotect = net_event(inst.GUID, "unprotect", "unprotect")
end)

return Shipyard

