local Shipyardmanager = Class(function(self, inst)
    self.inst = inst
	self.guidmapping = {}
	self.flag_to_shipyard = {}
	self.shipyard_to_flags = {}
	self.flag_to_ropes = {}
	self.builder_to_data = {}
end)

---- Cache for _CalcAndCheckShipyard ----
function Shipyardmanager:RegisterShipyard(flags, data)
	if flags and data then
		self.shipyard_to_flags[data] = {}
		for _, flag in pairs(flags) do
			self.flag_to_shipyard[flag] = data
			table.insert(self.shipyard_to_flags[data], flag)
		end
	end
end

function Shipyardmanager:UnregisterShipyard(flag)
	local shipyard = self.flag_to_shipyard[flag]
	if shipyard then
		local flags = self.shipyard_to_flags[shipyard]
		for _, flag in pairs(flags or {}) do
			self.flag_to_shipyard[flag] = nil
		end
		self.shipyard_to_flags[shipyard] = nil
	end
end

function Shipyardmanager:GetShipyard(flag)
	return self.flag_to_shipyard[flag]
end

---- Used to associat ropes to flag on client ----
function Shipyardmanager:RegisterRope(rope)
	local flag = rope.flag:value()
	if not self.flag_to_ropes[flag] then
		self.flag_to_ropes[flag] = {}
	end	
	self.flag_to_ropes[flag][rope] = true
end

function Shipyardmanager:UnRegisterRope(rope)
	local flag = rope.flag:value()
	if self.flag_to_ropes[flag] then
		self.flag_to_ropes[flag][rope] = nil
	end
end

function Shipyardmanager:GetRegisteredRopes(flag)
	return self.flag_to_ropes[flag]
end

return Shipyardmanager
