local assets =
{
	Asset("ANIM", "anim/boat_plants.zip")
}

local function OnRepaired(inst, doer, repair_item)
	if inst.entity:GetParent() then
		inst.entity:GetParent().components.repairable:Repair(doer, repair_item)
	end
end

local function synchealth(inst)
	local boat = inst.entity:GetParent()
	if boat then
		inst.replica.health = boat.replica.health
		inst.components.health = boat.components.health
	end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
	inst.entity:AddNetwork()

	inst:AddTag("walkableplatform") --necessary for mouseover

	inst:AddTag("DECOR")
    inst.AnimState:SetBank("boat_plants")
    inst.AnimState:SetBuild("boat_plants")
	inst.AnimState:SetSortOrder(ANIM_SORT_ORDER.OCEAN_BOAT)
	inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
	inst.AnimState:SetLayer(LAYER_BACKGROUND) --overwritten on spawn
	--inst.AnimState:PlayAnimation("idle_"..math.random(0, 5))

	inst:DoTaskInTime(0, synchealth)

    inst.entity:SetPristine()

	if not TheWorld.ismastersim then
		return inst
	end

	inst:AddComponent("repairable")
	inst.components.repairable.repairmaterial = MATERIALS.WOOD
	inst.components.repairable.onrepaired = OnRepaired

	inst:AddComponent("health")

	inst.persists = false
	return inst
end

return Prefab("boat_plant", fn, assets)
