local function build_boat_collision_mesh(vertices, height, angle)
 	-- vertices must draw a closed polygon
	local triangles = {}
	local y0 = 0
    local y1 = height

	local idx0 = #vertices
    for idx1 = 1, #vertices do

        local x0, z0 = VecUtil_RotateDir(vertices[idx0][1], vertices[idx0][2], angle)
		local x1, z1 = VecUtil_RotateDir(vertices[idx1][1], vertices[idx1][2], angle)
    
		--vertical one    
        table.insert(triangles, x0)
        table.insert(triangles, y0)
        table.insert(triangles, z0)

        table.insert(triangles, x0)
        table.insert(triangles, y1)
        table.insert(triangles, z0)

        table.insert(triangles, x1)
        table.insert(triangles, y0)
        table.insert(triangles, z1)

        table.insert(triangles, x1)
        table.insert(triangles, y0)
        table.insert(triangles, z1)

        table.insert(triangles, x0)
        table.insert(triangles, y1)
        table.insert(triangles, z0)

        table.insert(triangles, x1)
        table.insert(triangles, y1)
        table.insert(triangles, z1)

		idx0 = idx1
    end

	return triangles
end

local function Update_Mesh(inst, angle, inactive)
	local x, y, z = inst.Transform:GetWorldPosition()
	inst.Physics:SetActive(false)

	if inst.ground_support then
		inst.ground_support.Physics:ConstrainTo(nil)
	end	

	inst.Physics:SetTriangleMesh(build_boat_collision_mesh(inst.vertices, inst.height, angle))

	inst.Transform:SetPosition(x, 0, z)

	if inst.ground_support then
		inst.ground_support.Transform:SetPosition(x, 0, z)
		if inactive == nil then
			inst.ground_support.Physics:ConstrainTo(inst.entity)
		end
	end
	if inactive == nil then
		inst.Physics:SetActive(true)
	end
end

local function boat_player_collision_fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	local phys = inst.entity:AddPhysics()
	phys:SetMass(0)
	phys:SetFriction(0)
	phys:SetDamping(5)
	phys:SetCollisionGroup(COLLISION.BOAT_LIMITS)
	phys:ClearCollisionMask()
	phys:CollidesWith(COLLISION.CHARACTERS)
	inst.height = 3
	inst.Update_Mesh = Update_Mesh
	phys:SetDontRemoveOnSleep(true)
	inst.Physics:SetActive(false)

	inst:AddTag("NOBLOCK")
	inst:AddTag("NOCLICK")
		
	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
	    return inst
	end

	inst.persists = false

	return inst
end

local function boat_item_collision_fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
  	  
	local phys = inst.entity:AddPhysics()
	phys:SetMass(1000)
	phys:SetFriction(0)
	phys:SetDamping(5)
	phys:SetCollisionGroup(COLLISION.BOAT_LIMITS)
	phys:ClearCollisionMask()
	phys:CollidesWith(COLLISION.ITEMS)
	phys:CollidesWith(COLLISION.FLYERS)
	inst.height = 3
	inst.Update_Mesh = Update_Mesh
	phys:SetDontRemoveOnSleep(true)
	inst.Physics:SetActive(false)

	local ground_support = SpawnPrefab("ground_support")
	inst.ground_support = ground_support

	inst:AddTag("NOBLOCK")
	inst:AddTag("NOCLICK")

	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
	    return inst
	end

	inst.persists = false

	return inst
end

local function OnCollide_hull(inst, other, world_position_on_a_x, world_position_on_a_y, world_position_on_a_z, world_position_on_b_x, world_position_on_b_y, world_position_on_b_z, world_normal_on_b_x, world_normal_on_b_y, world_normal_on_b_z, lifetime_in_frames)
	if inst.boat ~= nil then
		inst.boat.oncollide(inst.boat, other, world_position_on_a_x, world_position_on_a_y, world_position_on_a_z, world_position_on_b_x, world_position_on_b_y, world_position_on_b_z, world_normal_on_b_x, world_normal_on_b_y, world_normal_on_b_z, lifetime_in_frames)
	end
end

local function boat_hull_collision_fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	local phys = inst.entity:AddPhysics()
	phys:SetMass(500)
	phys:SetFriction(0)
	phys:SetDamping(5)
	phys:SetCollisionGroup(COLLISION.OBSTACLES)
	phys:ClearCollisionMask()
	phys:CollidesWith(COLLISION.OBSTACLES)
	phys:CollidesWith(COLLISION.WORLD)
	inst.height = 3
	inst.Update_Mesh = Update_Mesh
	phys:SetCollisionCallback(OnCollide_hull)
	phys:SetDontRemoveOnSleep(true)
	inst.Physics:SetActive(false)

	inst.ground_support = SpawnPrefab("ground_support")

	inst:AddTag("NOBLOCK") -- it's fine to build things on top of them
	inst:AddTag("NOCLICK")

	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
	    return inst
	end

	inst.persists = false

	return inst
end

local function OnCollide_world(inst, other, world_position_on_a_x, world_position_on_a_y, world_position_on_a_z, world_position_on_b_x, world_position_on_b_y, world_position_on_b_z, world_normal_on_b_x, world_normal_on_b_y, world_normal_on_b_z, lifetime_in_frames)
	--grab the boats instead of the world_collider
	if inst.boat ~= nil then
		if other.boat ~= nil then
			other = other.boat
			if inst.boat == other then
				return
			end
		end
		inst.boat.oncollide(inst.boat, other, world_position_on_a_x, world_position_on_a_y, world_position_on_a_z, world_position_on_b_x, world_position_on_b_y, world_position_on_b_z, world_normal_on_b_x, world_normal_on_b_y, world_normal_on_b_z, lifetime_in_frames)	
	end
end

local function boat_world_collision_fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddNetwork()

	local phys = inst.entity:AddPhysics()
	phys:SetMass(500)
	phys:SetFriction(0)
	phys:SetDamping(5)
	phys:SetCollisionGroup(COLLISION.BOAT_LIMITS)
	phys:ClearCollisionMask()
	phys:CollidesWith(COLLISION.LAND_OCEAN_LIMITS)
	phys:CollidesWith(COLLISION.GROUND)
	--phys:CollidesWith(COLLISION.WORLD)
	phys:CollidesWith(COLLISION.OBSTACLES)
	phys:SetCollisionCallback(OnCollide_world)
	phys:SetDontRemoveOnSleep(true)
	phys:SetActive(false)

	inst:AddTag("NOBLOCK")
	inst:AddTag("NOCLICK")

	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
	    return inst
	end

	inst.persists = false

	return inst
end

local function ground_support_fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	local phys = inst.entity:AddPhysics()
	phys:SetMass(500)
	phys:SetFriction(0)
	phys:SetDamping(5)
	phys:ClearCollisionMask()
	phys:CollidesWith(COLLISION.GROUND)
	phys:SetCylinder(2, 2)
	phys:SetDontRemoveOnSleep(true)

	inst:AddTag("NOBLOCK")
	inst:AddTag("NOCLICK")

	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
	    return inst
	end

	inst.persists = false
	return inst
end

local function bridge_anchor_fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddNetwork()

	inst:AddTag("NOBLOCK")
	inst:AddTag("NOCLICK")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

	inst:AddComponent("boatdrag")
	inst.components.boatdrag.drag = TUNING.BOAT.ANCHOR.BASIC.ANCHOR_DRAG
	inst.components.boatdrag.max_velocity_mod = TUNING.BOAT.ANCHOR.BASIC.MAX_VELOCITY_MOD

	inst.persists = false
	return inst
end

local function marker_fn() --debug tool
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddNetwork()

	inst.entity:AddAnimState()
	inst.AnimState:SetBank("carrot")
	inst.AnimState:SetBuild("carrot")	
	inst.AnimState:PlayAnimation("planted")

	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
		return inst
	end

	inst.persists = false

	return inst
end

local function data_fn()
	local inst = CreateEntity()

	inst.entity:AddNetwork()		
	inst.entity:SetCanSleep(false)
	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
		return inst
	end

	inst.persists = false
	return inst
end

return  Prefab("ground_support", ground_support_fn),
		Prefab("boat_data", data_fn),
    	Prefab("marker_c", marker_fn, {Asset("ANIM", "anim/carrot.zip")}),
		Prefab("boat_player_collision_common", boat_player_collision_fn),
		Prefab("boat_item_collision_common", boat_item_collision_fn),
		Prefab("boat_hull_collision_common", boat_hull_collision_fn),
		Prefab("boat_world_collision_common", boat_world_collision_fn),
		Prefab("bridge_anchor", bridge_anchor_fn)
