local assets =
{
    Asset("ANIM", "anim/boat_lip_fx.zip")
}

local prefabs =
{
}

local function Update(inst, boat_angle, camangle)
	--all in degrees
	if inst.hide or (inst.Transform:GetRotation() +  boat_angle + camangle) % 360 >= 180 then
		inst:Hide()
	else
		inst:Show()
	end
end

local function boatlipfx_fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    inst:AddTag("NOBLOCK")
    inst:AddTag("DECOR")

    inst.AnimState:SetBank("lip_fx")
    inst.AnimState:SetBuild("boat_lip_fx")
    inst.AnimState:PlayAnimation("anim", true)
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    inst.AnimState:SetLayer(LAYER_BELOW_GROUND)
    inst.AnimState:SetSortOrder(ANIM_SORT_ORDER_BELOW_GROUND.BOAT_LIP)
    inst.AnimState:SetFinalOffset(0)
    inst.AnimState:SetOceanBlendParams(TUNING.OCEAN_SHADER.EFFECT_TINT_AMOUNT)  
    inst.AnimState:SetInheritsSortKey(false)

	inst.Update = Update

	inst:Hide()
	inst.hide = true --prevent usual bot rotation to make lip visible
	if not TheNet:IsDedicated() then
		inst:DoTaskInTime(0.7, function() 
			inst.hide = false;
			local boat_angle = inst.entity:GetParent() and inst.entity:GetParent().Transform:GetRotation() or 0
			inst:Update(boat_angle, TheCamera:GetHeading())			
		end)
	end

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
       
    inst.persists = false

    return inst
end

return Prefab("boatlip_fx", boatlipfx_fn, assets, prefabs)
