local MakeBoat, MakeKit, Complete_data, AddRecipe, GetModConfigData = unpack(require("prefabs/boat_common"))

local function boat() --overwrite classic boat
	local data = {}
	data.prefabname = "boat"
	data.bank = "boat_01"
	data.build = "boat_test"

	data.health = TUNING.BOAT.HEALTH
	data.vertices = { { 4, 0 }, { 3.8042260651806, 1.2360679774998 }, { 3.2360679774998, 2.3511410091699 }, { 2.3511410091699, 3.2360679774998 }, { 1.2360679774998, 3.8042260651806 }, { 2.4492935982947e-16, 4 }, { -1.2360679774998, 3.8042260651806 }, { -2.3511410091699, 3.2360679774998 }, { -3.2360679774998, 2.3511410091699 }, { -3.8042260651806, 1.2360679774998 }, { -4, 4.8985871965894e-16 }, { -3.8042260651806, -1.2360679774998 }, { -3.2360679774998, -2.3511410091699 }, { -2.3511410091699, -3.2360679774998 }, { -1.2360679774998, -3.8042260651806 }, { -7.3478807948841e-16, -4 }, { 1.2360679774998, -3.8042260651806 }, { 2.3511410091699, -3.2360679774998 }, { 3.2360679774998, -2.3511410091699 }, { 3.8042260651806, -1.2360679774998 }, { 4, -9.7971743931788e-16 } }
	data.burnable_locator = {{0, 0}, {0, 2.5}, {0, -2.5}, {2.5, 0}, {-2.5, 0}}   -- where boat takes fire {x, z}
	data.walkingplank = {0, 3.95, 0}  -- x, z, theta

	data.item_prefabname = "boat_item"
	STRINGS.NAMES[string.upper(data.item_prefabname)] = "Boat Kit"
	data.itemasset = Asset("INV_IMAGE", "boat_item")
	data.itembank = "seafarer_boat"
	data.itembuild = "seafarer_boat"
	AddRecipe(data.item_prefabname, {Ingredient("boards", 4)}, RECIPETABS.SEAFARING, TECH.SEAFARING_TWO)
	data.loot = {boards = 4}

	Complete_data(data)
	return data
end

local function rectangle()
	local data = {}
	data.prefabname = "boat_rectangle"
	data.bank = "boat_rectangle"
	data.build = "boat_rectangle"
	data.health = TUNING.BOAT.HEALTH * 1.5
	data.vertices = {{6.25, 5}, {-6.25, 5}, {-6.25, -5}, {6.25, -5}}
	data.burnable_locator = {{-3.75, -3}, {-3.75, 0}, {-3.75, 3}, {0, -3}, {0, 0}, {0, 3}, {3.75, -3}, {3.75, 0}, {3.75, 3}}
	data.walkingplank = {0, 5, 0}

	data.item_prefabname = data.prefabname.."_item"
	STRINGS.NAMES[string.upper(data.item_prefabname)] = "Rectangle Boat Kit"
	data.itembank = "rectangle"
	data.itembuild = "boat_items"
	AddRecipe(data.item_prefabname, {Ingredient("boards", 8)}, RECIPETABS.SEAFARING, TECH.SEAFARING_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/"..data.item_prefabname..".xml")
	data.loot = {boards = 8}

	STRINGS.RECIPE_DESC[string.upper(data.item_prefabname)] = "A wide but slow platform."
	STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(data.item_prefabname)] = "Maybe I'll have enough room to build a base."

	data.postinitprefabfn = (function(inst) 
		if TheWorld.ismastersim and GetModConfigData("rectangle") ~= "classic" then
			inst.maxspeedmultiplier = 0.8
		end
	end)

	Complete_data(data)
	return data
end

local function moon()
	local data = {}
	data.prefabname = "boat_moon"
	data.bank = "boat_moon"
	data.build = "boat_moon"
	data.health = TUNING.BOAT.HEALTH * 0.75
	data.vertices = {{-3.9779005524861875, 2.7255985267034992}, {-4.622467771639042, 1.2338858195211786}, {-4.732965009208103, -0.40515653775322286}, {-4.30939226519337, -2.154696132596685}, {-3.443830570902394, -3.443830570902394}, {-2.0257826887661143, -4.511970534069982}, {-0.4604051565377532, -4.917127071823205}, {1.289134438305709, -4.8802946593001835}, {2.7808471454880297, -4.29097605893186}, {3.756906077348066, -3.4990791896869244}, {4.5488029465930016, -2.4493554327808473}, {4.383057090239411, -2.0626151012891345}, {2.85451197053407, -2.4493554327808473}, {1.3627992633517496, -1.9889502762430937}, {0.5340699815837937, -0.7918968692449356}, {0.49723756906077343, 0.47882136279926335}, {1.252302025782689, 1.8047882136279927}, {2.6519337016574585, 2.3756906077348066}, {4.346224677716391, 2.0810313075506444}, {4.5488029465930016, 2.4861878453038675}, {3.4806629834254146, 3.793738489871086}, {2.044198895027624, 4.677716390423573}, {0.34990791896869244, 4.972375690607735}, {-1.3627992633517496, 4.751381215469613}, {-2.89134438305709, 3.9779005524861875}}
	data.burnable_locator = {}
	data.walkingplank = {0, 5, 0}

	data.item_prefabname = data.prefabname.."_item"
	STRINGS.NAMES[string.upper(data.item_prefabname)] = "Moon Boat Kit"
	data.itembank = "moon"
	data.itembuild = "boat_items"
	AddRecipe(data.item_prefabname, {Ingredient("moonglass", 8), Ingredient("boards", 1)}, RECIPETABS.MOON_ALTAR, TECH.MOON_ALTAR_TWO, nil, nil, true, nil, nil, "images/inventoryimages/"..data.item_prefabname..".xml")
	data.loot = {boards = 1, moonglass = 8}

	STRINGS.RECIPE_DESC[string.upper(data.item_prefabname)] = "Sail under the protection of the Moon."
	STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(data.item_prefabname)] = "It radiates a strange power."

	if GetModConfigData("moon") ~= "classic" then
		data.postinitprefabfn = function(inst) inst:AddTag("NoWaveyjones") end
	end

	Complete_data(data)
	return data
end

local function bridge()
	local data = {}
	data.prefabname = "boat_bridge"
	data.bank = "boat_bridge"
	data.build = "boat_bridge"

	data.health = TUNING.BOAT.HEALTH * 0.5
	data.vertices = {{5, 0.8}, {-5, 0.8}, {-5, -0.8}, {5, -0.8}}
	data.burnable_locator = {{-3, 0}, {0, 0}, {3, 0}}
	data.walkingplank = nil

	data.item_prefabname = data.prefabname.."_item"
	STRINGS.NAMES[string.upper(data.item_prefabname)] = "Bridge Kit"
	data.itembank = "bridge"
	data.itembuild = "boat_items"
	AddRecipe(data.item_prefabname, {Ingredient("boards", 1), Ingredient("rope", 1)}, RECIPETABS.SEAFARING, TECH.SEAFARING_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/"..data.item_prefabname..".xml")
	data.loot = {boards = 1, rope = 1}

	STRINGS.RECIPE_DESC[string.upper(data.item_prefabname)] = "Build bridges, not walls."
	STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(data.item_prefabname)] = "I will attach it to the ground for safety."

	data.postinitprefabfn = (function(inst) 
		if TheWorld.ismastersim  and GetModConfigData("bridge") ~= "classic" then
			local anchor = SpawnPrefab("bridge_anchor")
			inst.components.hull:AttachEntityToBoat(anchor, 0, 0)
			inst.components.boatphysics:AddBoatDrag(anchor)
		end
	end)

	Complete_data(data)
	return data
end

local function raft()
	local data = {}
	data.prefabname = "boat_raft"
	data.bank = "boat_raft"
	data.build = "boat_raft"

	data.health = TUNING.BOAT.HEALTH * 0.4
	data.vertices = {{1.8, 1.3}, {-1.8, 1.3}, {-1.8, -1.3}, {1.8, -1.3}}
	data.burnable_locator = {{0, 0}}
	data.walkingplank = nil

	data.item_prefabname = data.prefabname.."_item"
	STRINGS.NAMES[string.upper(data.item_prefabname)] = "Raft Kit"
	data.itembank = "raft"
	data.itembuild = "boat_items"
	AddRecipe(data.item_prefabname, {Ingredient("log", 4), Ingredient("rope", 1)}, RECIPETABS.SEAFARING, TECH.SEAFARING_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/"..data.item_prefabname..".xml")
	data.loot = {log = 5, rope = 1}

	STRINGS.RECIPE_DESC[string.upper(data.item_prefabname)] = "Boat at your own risk."
	STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(data.item_prefabname)] = "I'm not sure I want to sail with this thing."

	data.postinitprefabfn = (function(inst)
		if TheWorld.ismastersim  and GetModConfigData("bridge") ~= "classic" then
			local anchor = SpawnPrefab("bridge_anchor")
			anchor.components.boatdrag.drag = 1E-6 -- anything > 0
			anchor.components.boatdrag.max_velocity_mod = 1
			inst.components.hull:AttachEntityToBoat(anchor, 0, 0)
			inst.components.boatphysics:AddBoatDrag(anchor)
		end
	end)

	Complete_data(data)
	return data
end

local function caravel()
	local data = {}
	data.prefabname = "boat_caravel"
	data.bank = "boat_caravel"
	data.build = "boat_caravel"

	data.health = TUNING.BOAT.HEALTH
	data.vertices = {{-1.5, -3.7266666666666666}, {0.013333333333333334, -3.7}, {1.5533333333333332, -3.533333333333333}, {3.066666666666667, -3.033333333333333}, {4.34, -2.3066666666666666}, {5.493333333333333, -1.28}, {6.453333333333333, 0.04}, {5.446666666666666, 1.4266666666666667}, {4.253333333333333, 2.42}, {2.9066666666666667, 3.2133333333333334}, {1.3933333333333333, 3.6333333333333333}, {-0.21333333333333335, 3.7533333333333334}, {-1.8, 3.7666666666666666}, {-3.36, 3.58}, {-4.533333333333333, 2.62}, {-4.6066666666666665, 1.0733333333333333}, {-4.62, -0.006666666666666667}, {-4.573333333333333, -1.3733333333333333}, {-4.433333333333334, -2.566666666666667}, {-3.02, -3.6133333333333333}}
	data.burnable_locator = {{-2, -2}, {-2, 2}, {2, -2}, {2, 2}, {0, 0}, {4, 0}}
	data.walkingplank = {-1, 3.85, 0}

	data.item_prefabname = data.prefabname.."_item"
	STRINGS.NAMES[string.upper(data.item_prefabname)] = "Caravel Kit"
	data.itembank = "caravel"
	data.itembuild = "boat_items"
	AddRecipe(data.item_prefabname, {Ingredient("boards", 6)}, RECIPETABS.SEAFARING, TECH.SEAFARING_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/"..data.item_prefabname..".xml")
	data.loot = {boards = 6}

	STRINGS.RECIPE_DESC[string.upper(data.item_prefabname)] = "Sail the ocean with agility."
	STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(data.item_prefabname)] = "It seems easier to navigate, maybe I won't sink this time..."

	data.postinitprefabfn = (function(inst) 
		if TheWorld.ismastersim and GetModConfigData("caravel") ~= "classic" then
			inst.rudderturnspeedmultiplier = 1.3
		end
	end)

	Complete_data(data)
	return data
end

local function custom()
	local data = {}
	data.prefabname = "boat_custom"
	data.bank = "boat_custom"
	data.build = "boat_custom" --empty animation of the right length
	data.custom = true
	data.construct_data = (function(inst, draw_vertices, vertices, cuts, area, radius)
		local data = inst.data
		data.custom = true
		data.draw_vertices = draw_vertices
		data.vertices = vertices
		data.cuts = cuts
		data.health = math.ceil(math.sqrt(area / 50) * 37) * 5
		data.burnable_locator = {}
		data.loot = {boards = math.ceil(area / 12.5)}
		data.walkingplank = nil
		data.maxspeedmultiplier = math.min(1, math.sqrt(8.0 / radius))
		data.rudderturnspeedmultiplier = math.min(8.0 / radius, 1.0)
		Complete_data(data)
		return data
	end)
	return data
end

local boats = {   --ordered as in tab
	GetModConfigData("raft") and raft(),
	GetModConfigData("bridge") and bridge(),
	GetModConfigData("boat") and boat(),
	GetModConfigData("caravel") and caravel(),
	GetModConfigData("rectangle") and rectangle(),
	GetModConfigData("moon") and moon()
}

local prefs = {}
for k, data in pairs(boats) do
	if data then
		table.insert(prefs,  MakeBoat(data))
		local item, placer = MakeKit(data)
		table.insert(prefs, item)
		table.insert(prefs, placer)
	end
end
if GetModConfigData("shipyard") then
	table.insert(prefs, MakeBoat(custom()))
end

return unpack(prefs)
