local env = getfenv(1)
for k, v in pairs(require('boat_mathutil')) do env[k] = v end
for k, v in pairs(require('prefabs/shipyard_common')) do env[k] = v end
setfenv(1, env)
local _, _, Complete_data, AddRecipe, GetModConfigData, is_valid_placement, PLANT_SCALE = unpack(require("prefabs/boat_common"))

local assets =
{
	Asset("ANIM", "anim/shipyard_builder.zip"),
	Asset("ATLAS", "images/inventoryimages/shipyard_builder_item.xml"),
	Asset("IMAGE", "images/inventoryimages/shipyard_builder_item.tex"),
	Asset("ATLAS", "minimap/worksite_panel.xml"),
	Asset("IMAGE", "minimap/worksite_panel.tex"),
	--Asset("MINIMAP_IMAGE", "worksite_panel2")
}

local prefabs =
{
	"shipyard_flag",
	"shipyard_rope",
	"shipyard_arrow"
}

local EXTRA_IGNORE_TAGS = {"NOSHIPYARDBLOCK"}
local function _CalcAndCheckShipyard(flag, only_land)
	--this function is expensive thus we use a cache
	--is the polygon buildable ?
	local flags, draw_vertices = GetShipyard(flag)
	local valid, announce, bad_indexes, x, z, area, vertices, cuts, radius, draw_vertices = is_constructible_poly(draw_vertices, 0.55 * PLANT_SCALE)
	if not valid then
		local flag_pairs
		if bad_indexes then
			flag_pairs = {}
			for _, v in pairs(bad_indexes) do
				table.insert(flag_pairs, {flags[v[1]], flags[v[2]]})
			end
		end	
		return false, announce, flag_pairs
	end
	--does it cross land or contain objects ?
	local radius = CalcRadius(vertices)
	local bissectors = vertices_bissectors(vertices)
	local placer_vertices, mapping = subdivise(shift_vertices(vertices, bissectors, 0.2), 0.5)
	local extra_world_point = make_grid(vertices, 2, 2)

	local valid, k = is_valid_placement({x = x, y = 0, z = z}, nil, placer_vertices, radius, only_land, extra_world_point, EXTRA_IGNORE_TAGS)
	if not valid then
		if only_land and k and k <= #placer_vertices then
			local flag1, flag2 = Closest_flags({placer_vertices[k][1] + x, 0, placer_vertices[k][2] + z}, 10)			
			return false, 'obstructed', flag1 and flag2 and {{flag1, flag2}}
		else
			return false, 'obstructed'
		end
	end
	return true, "success", nil, x, z, area, vertices, cuts, radius, draw_vertices
end

local function CalcAndCheckShipyard(flag, only_land)
	--cache for _CalcAndCheckShipyard
	if only_land and TheWorld.components.shipyardmanager:GetShipyard(flag) then
		return unpack(TheWorld.components.shipyardmanager:GetShipyard(flag))
	end
	local data = {_CalcAndCheckShipyard(flag, only_land)}
	if only_land then
		TheWorld.components.shipyardmanager:RegisterShipyard(GetShipyard(flag), data)
	end
	return unpack(data)
end

local function OnConstructed(inst, doer)
	for i, v in ipairs(CONSTRUCTION_PLANS[inst.prefab] or {}) do
		if inst.components.constructionsite:GetMaterialCount(v.type) < v.amount then
			return
		end
	end
	local valid, announce, _, x, z, area, vertices, cuts, radius, draw_vertices = CalcAndCheckShipyard(inst.flag, false)

	if not valid then
		doer.components.talker:Say(STRINGS.ACTIONS.SHIPYARD_FAILED)
		--pop one boards from the site
		inst.components.constructionsite.materials["boards"].amount = inst.components.constructionsite.materials["boards"].amount - 1
		local x, y, z = doer.Transform:GetWorldPosition()
		SpawnPrefab("boards").components.inventoryitem:DoDropPhysics(x, y, z, true)
		return
	end

	--everything good, build now	
	local boat = SpawnPrefab("boat_custom")

	local angle = inst:GetAngleToPoint(x, 0, z)
	vertices = rotate_vertices(vertices, angle * DEGREES)
	draw_vertices = rotate_vertices(draw_vertices, angle * DEGREES)
	local data = boat:construct_data(draw_vertices, vertices, cuts, area, radius)
	boat:post_fn(data)

	local flags, draw_vertices = GetShipyard(inst.flag)
	boat:send_data(rotate_vertices(draw_vertices, angle * DEGREES))

	boat.Transform:SetPosition(x, 0, z)
	boat.Transform:SetRotation(angle)
	boat.components.boatphysics:SetRotation(-angle * DEGREES)
	boat.sg:GoToState("place")

	--some cool effects
	for _, plant in pairs(boat.plants) do
		plant:Hide()
		plant:DoTaskInTime(0.7 * math.random(), function() plant:Show() end)
	end
	for i, plant in pairs(boat.edge_plants) do
		plant:Hide()
		plant:DoTaskInTime(0.7 * i / #boat.edge_plants, function() plant:Show() end)
	end

	--remove the shipyard
	inst:Remove()
	for _, flag in pairs(flags) do
		flag:Remove()
	end
end

local function like_to_flag(inst, flag)
	if flag then
		local flags = GetShipyard(flag)
		for _, flag in pairs(flags) do
			flag:protect()
		end
		inst.flag = flag
	end
end

local function unlink(inst)
	if inst.flag then
		local flags = GetShipyard(inst.flag)
		for _, flag in pairs(flags) do
			flag:unprotect()
		end
	end
	inst.flag = nil
end

local function SetConstructionCost(inst, area)
	local cost = math.ceil(area / 12.5)
	inst.prefab = tostring(inst.prefab)..tostring(inst.GUID) --hack for construction plan
	CONSTRUCTION_PLANS[inst.prefab] = {Ingredient("boards", cost)}
end

local function Color_shipyard(flags, ...)
	for _, flag in pairs(flags) do
		flag.AnimState:SetAddColour(...)
		for rope in pairs(flag:GetRopes()) do
			rope.AnimState:SetAddColour(...)
		end
	end
end

local function Color_error(bad_flags, ...)
	for _, f in pairs(bad_flags) do
		f[1].AnimState:SetAddColour(...)
		if f[1] ~= f[2] then
			f[2].AnimState:SetAddColour(...)
			for rope in pairs(f[1]:GetRopes()) do
				rope.AnimState:SetAddColour(...)
			end
		end
	end
end

local PLACER_DIST = 1.5
local function OnUpdate_placer(inst)
	Color_shipyard(inst.flags, 0, 0, 0, 0) --shipyard may change, we have to clear now
	local flag, _, dist = Closest_flags({inst.Transform:GetWorldPosition()}, 10)
	if flag and dist < PLACER_DIST then
		local valid, announce, bad_flags, x, z = CalcAndCheckShipyard(flag, true)
		local flags = GetShipyard(flag)
		if valid then
			Color_shipyard(flags, 0, 0.5, 0, 0)
			if not inst.arrow then
				inst.arrow = SpawnPrefab("shipyard_arrow")
				inst.arrow.AnimState:SetMultColour(0.25, 0.75, 0.25, 0)
				inst.arrow.AnimState:PlayAnimation("idle", true)
			else
				inst.arrow:Show()
			end
			local angle = inst:GetAngleToPoint(x, 0, z)
			inst.arrow.Transform:SetRotation(angle - 90)

			local x0, y0, z0 = inst.Transform:GetWorldPosition()
			local nx, nz, length = VecUtil_NormalAndLength(x - x0, z - z0)
			inst.arrow.Transform:SetPosition(x0 + nx * 3, 0, z0 + nz * 3)
		else
			if bad_flags then
				Color_error(bad_flags, 0.75, 0, 0, 0)
			else
				Color_shipyard(flags, 0.5, 0, 0, 0)
			end
			if inst.arrow then
				inst.arrow:Hide()
			end
		end
		inst.flags = flags
	else
		Color_shipyard(inst.flags, 0, 0, 0, 0)
		if inst.arrow then
			inst.arrow:Hide()
		end
	end
end

local function custom_candeploy_fn(inst, pt, mouseover, deployer)
	local flag, _, dist = Closest_flags({pt.x, pt.y, pt.z}, 10)
	return flag and dist < PLACER_DIST and CalcAndCheckShipyard(flag, true)
end

local function Ondeploy(inst, pt, deployer, rot)
	local flag, _, dist = Closest_flags({pt.x, 0, pt.z}, 10)

	local valid, announce, _, _, _, area = CalcAndCheckShipyard(flag)

	if dist < PLACER_DIST and valid then
		local builder = SpawnPrefab("shipyard_builder")
		builder.Transform:SetPosition(pt.x, 0, pt.z)
		like_to_flag(builder, flag)
		builder.area:set(area)
		SetConstructionCost(builder, area)
		inst.components.finiteuses:Use(1)
		deployer.components.inventory:GiveItem(inst)
	else
		if not valid then
			deployer.components.talker:Say(STRINGS.ACTIONS.SHIPYARD_FAILED)
		end
		deployer.components.inventory:GiveItem(inst)
	end
end

local function Onremove(inst)
	inst.AnimState:PlayAnimation("break")
	unlink(inst)
end

local function onhammered(inst, worker)
	if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
		inst.components.burnable:Extinguish()
	end
	local fx = SpawnPrefab("collapse_small")
	fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
	fx:SetMaterial("wood")
	inst:Remove()
end

function onhit(inst)
	if not inst:HasTag("burnt") then
		inst.AnimState:PlayAnimation("hit")
		inst.AnimState:PushAnimation("idle", true)
	end
end

local function onbuilt(inst)
	inst.SoundEmitter:PlaySound("dontstarve/common/sign_craft")
end

local function getspecialdescription(inst, view)
	if inst:HasTag('burnt') then 
		return STRINGS.CHARACTERS.GENERIC.DESCRIBE.SHIPYARD_BUILDER["BURNT"]
	else
		for i, v in ipairs(CONSTRUCTION_PLANS[inst.prefab] or {}) do
			local num = v.amount - inst.components.constructionsite:GetMaterialCount(v.type)
			return string.format(STRINGS.CHARACTERS.GENERIC.DESCRIBE.SHIPYARD_BUILDER["GENERIC"], num)
		end
	end
end

local function OnSave(inst, data)
	if inst:HasTag("burnt") or (inst.components.burnable ~= nil and inst.components.burnable:IsBurning()) then
		data.burnt = true
	end

	if inst.flag then
		data.flag_pos = {inst.flag.Transform:GetWorldPosition()}
		data.area = inst.area:value()
		data.constructionsite = inst.components.constructionsite:OnSave()
	end
	local prefab = inst.prefab
	inst.prefab = "shipyard_builder" --go around the construction plan hack
	inst:DoTaskInTime(0, function() inst.prefab = prefab end)
end

local function OnLoad(inst, data)
	if data ~= nil and data.burnt then
		inst.components.burnable.onburnt(inst)
		return
	end
	inst:DoTaskInTime(0, function()
		if TheWorld.ismastersim and data and data.flag_pos then
			local x, y, z = unpack(data.flag_pos)
			local ents = TheSim:FindEntities(x, y, z, 0.01, SHIPYARD_FLAGS)
			if #ents > 0 then
				inst:DoTaskInTime(0,  --let flags time to link themself
				function()
					local flag = ents[1]
					like_to_flag(inst, flag)
					inst.area:set(data.area)
					SetConstructionCost(inst, data.area)
				inst.components.constructionsite:OnLoad(data.constructionsite or {materials = nil})
				end)
			end
		end
	end)
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddMiniMapEntity()
	inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()

	inst.AnimState:SetBank("shipyard_builder")
	inst.AnimState:SetBuild("shipyard_builder")
	inst.AnimState:PlayAnimation("idle")

	inst:AddTag("constructionsite")
	inst:AddTag("NOSHIPYARDBLOCK")

	inst.MiniMapEntity:SetIcon("worksite_panel.tex")

	MakeInventoryFloatable(inst, "small", 0, 0.7)
	inst.components.floater.bob_percent = 0

	inst:SetPhysicsRadiusOverride(1.85)
	inst.constructionname = "Boat"

	MakeWaterObstaclePhysics(inst, 0.2, 2, 1.25)

	inst.area = net_float(inst.GUID, "shipyard.area", "shipyard.area")

	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
		inst:DoTaskInTime(0, function()
			inst:ListenForEvent("shipyard.area", SetConstructionCost(inst, inst.area:value()))
		end)
		return inst
	end

	inst.OnSave = OnSave
	inst.OnLoad = OnLoad

	inst:AddComponent("inspectable")
	inst.components.inspectable.getspecialdescription = getspecialdescription --around construction site hack

	inst:AddComponent("constructionsite")
	inst.components.constructionsite:SetConstructionPrefab("construction_container")
	inst.components.constructionsite:SetOnConstructedFn(OnConstructed)

	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
	inst.components.workable:SetWorkLeft(3)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit)

	inst:ListenForEvent("onremove", Onremove)
	inst:ListenForEvent("onbuilt", onbuilt)

	MakeSmallBurnable(inst, nil, nil, true)
	inst:ListenForEvent("burntup", unlink)

	inst:DoTaskInTime(0, function(inst)
		inst.components.floater:OnLandedServer()
	end)

	return inst
	end

	local function item_fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddNetwork()

	MakeInventoryPhysics(inst)
	MakeInventoryFloatable(inst, "med", 0.2, 0.9)

	inst:AddTag("portableitem")
	inst:AddTag("usedeployspacingasoffset")

	inst.AnimState:SetBank("shipyard_builder")
	inst.AnimState:SetBuild("shipyard_builder")
	inst.AnimState:PlayAnimation("item")

	inst:AddComponent("deployable")
	inst.components.deployable.ondeploy = Ondeploy
	inst.components.deployable.DeploySpacingRadius = function(self) return 0.15 end
	inst.components.deployable:SetDeployMode(DEPLOYMODE.CUSTOM)
	inst._custom_candeploy_fn = custom_candeploy_fn
	inst.components.deployable.deploystring = "deploy"

	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
		return inst
	end

	inst:AddComponent("inspectable")

	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(10)
	inst.components.finiteuses:SetUses(10)
	inst.components.finiteuses:SetOnFinished(inst.Remove)

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/shipyard_builder_item.xml"

	MakeHauntableLaunchAndIgnite(inst)

	return inst
end

local function placer_postinit_fn(inst)
	inst:AddComponent("updatelooper")
	inst.flags = {}
	inst.components.updatelooper:AddOnUpdateFn(OnUpdate_placer)
	inst:ListenForEvent("onremove", function(inst)
		Color_shipyard(inst.flags, 0, 0, 0, 0)
		if inst.arrow then
			inst.arrow:Remove()
		end
	end)
end

STRINGS.NAMES["SHIPYARD_BUILDER_ITEM"] = "Naval Architect's Tools"
STRINGS.NAMES["SHIPYARD_BUILDER"] = "Worksite Panel"
STRINGS.RECIPE_DESC["SHIPYARD_BUILDER_ITEM"] = "Approve your ship project."
STRINGS.CHARACTERS.GENERIC.DESCRIBE["SHIPYARD_BUILDER_ITEM"] = "The perfect kit to build a boat."
STRINGS.CHARACTERS.GENERIC.DESCRIBE["SHIPYARD_BUILDER"] = 
	{
		GENERIC = "I need %i boards to finish the boat.",
		BURNT = "Water and fire don't go well together."
	}
STRINGS.ACTIONS.SHIPYARD_FAILED = "Something is blocking the construction."

AddRecipe("shipyard_builder_item", {Ingredient("goldnugget", 2),Ingredient("papyrus", 1), Ingredient("boards", 1)}, RECIPETABS.SEAFARING, TECH.SEAFARING_TWO, nil, nil, nil, 1, nil, "images/inventoryimages/shipyard_builder_item.xml")

return  Prefab("shipyard_builder", fn, assets, prefabs),
		Prefab("shipyard_builder_item", item_fn, assets),
		MakePlacer("shipyard_builder_item_placer", "shipyard_builder", "shipyard_builder", "idle", nil, nil, nil, nil, nil, nil, placer_postinit_fn)

