local SHIPYARD_FLAGS = {"shipyard_flag"}
local SHIPYARD_ROPES = {"shipyard_rope"}

local function GetShipyard(flag)
	local visited = {}
	local vertices = {}
	local flags = {}
	repeat
		if not flag then --shipyard is open
			return {}, {}
		end
		local x, y, z = flag.Transform:GetWorldPosition()
		table.insert(vertices, {x, z})
		table.insert(flags, flag)
		visited[flag] = true
		flag = flag.next_flag:value()
	until visited[flag]
	return flags, vertices
end

local function Closest_flags(position, FIND_DIST)
	local x, y, z = unpack(position)
	local flags = TheSim:FindEntities(x, y, z, FIND_DIST, SHIPYARD_FLAGS)
	for _, rope in pairs(TheSim:FindEntities(x, y, z, FIND_DIST, SHIPYARD_ROPES)) do
		if rope.flag:value() then
			table.insert(flags, rope.flag:value())
		end
	end
	if #flags == 0 then
		return
	end
	local processed = {}
	local min_distsq, prev_flag, next_flag
	for _, flag in pairs(flags) do
		if not processed[flag] then
			local flags, vertices = GetShipyard(flag) -- get the network of flags
			local min_x, min_z, distsq, i, j
			if #flags == 0 then
			elseif #flags == 1 then
				distsq, i, j = flags[1]:GetDistanceSqToPoint(x, y, z), 1, 1
			else
				min_x, min_z, i, j = closest_point_in_poly(x, z, 0, 0, vertices) --closest point in the network from the target
				distsq = VecUtil_LengthSq(x - min_x, z - min_z) --distance between the network and the target

				if i == nil or j == nil then --the closest point is a single vertices
					local k = i or j
					local n, nx, nz = calc_bissector_vector(vertices[(k - 2) % #vertices + 1],
														vertices[k],
														vertices[k % #vertices + 1])
					if vectorial_product(vertices[k], {vertices[k][1] + n * nx, vertices[k][2] + n * nz}, {x, z}) > 0 then
						i, j = k, k % #vertices + 1 --next_flag is chosen
					else
						i, j = (k - 2) % #vertices + 1, k --prev_flag is chosen
					end
				end

				for _, flag in pairs(flags) do
					processed[flag] = true
				end
			end
			if min_distsq == nil or distsq < min_distsq then
				min_distsq, prev_flag, next_flag = distsq, flags[i], flags[j]
			end
		end
	end
	return prev_flag, next_flag, min_distsq and math.sqrt(min_distsq)
end

local function reorder_pairs(old, reversed, base)
	if reversed then
		local new = {}
		for _, v in pairs(old) do
			table.insert(new, {base - v[2] + 1, base - v[1] + 1})
		end
		return new
	else
		return old
	end
end

local function is_constructible_poly(draw_vertices, l)
	-- polygon is self intersecting
	local bad_indexes = crossing_edge(draw_vertices)
	if #bad_indexes > 0 then
		return false, "self intersect", bad_indexes
	end

	--polygon is reversed
	local _, _, A = centroid(draw_vertices)
	local reversed = false
	if A < 0 then
		reversed = true
		local new_vertices = {}
		for k, v in pairs(draw_vertices) do
			new_vertices[#draw_vertices - k + 1] = v
		end
		draw_vertices = new_vertices
	end

	--two borders are too close to fit plant in
	local bissectors = vertices_bissectors(draw_vertices)
	local inner, index_mapping = cut_reflex_angle(shift_vertices(draw_vertices, bissectors, -l), bissectors, l)
	local bad_indexes = crossing_edge(inner)
	if #bad_indexes > 0 then
		local bad_indexes_origin = {}
		for k, v in pairs(bad_indexes) do
			table.insert(bad_indexes_origin, {index_mapping[v[1]], index_mapping[v[2]]})
		end
		return false, "too tiny", reorder_pairs(bad_indexes_origin, reversed, #draw_vertices)
	end

	--some angle cannot be repaired to contain plant
	local valid, cuts, vertices = cut_edges(draw_vertices, bissectors, 0.6) --cut edge
	if not valid then
		return false, "edgy", reorder_pairs(cuts, reversed, #draw_vertices)
	end

	local x, z, area = centroid(vertices)
	if area < 4.0 then
		return false, "too small", nil
	end

	for k, v in pairs(draw_vertices) do
		draw_vertices[k] = {v[1] - x, v[2] - z}
	end
	for k, v in pairs(vertices) do
		vertices[k] = {v[1] - x, v[2] - z}
	end

	--to avoid offscreen unload
	local radius = CalcRadius(vertices)
	if radius > 60 then 
		return false, "too long", nil
	end

	return true, "success", nil, x, z, area, vertices, cuts, radius, draw_vertices
end

-- export all local functions
local env = {}
local i = 1
while true do
    local name, value = debug.getlocal(1, i)
    if name == 'env' then break end
    env[name] = value
    i = i + 1
end
return env
