local assets =
{
	Asset("ANIM", "anim/shipyard_rope.zip"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
	inst.entity:AddNetwork()

    inst:AddTag("NOBLOCK")
	inst:AddTag("NOCLICK")
    inst:AddTag("DECOR")
	inst:AddTag("shipyard_rope")

    inst.AnimState:SetBank("shipyard_rope")
    inst.AnimState:SetBuild("shipyard_rope")
    inst.AnimState:PlayAnimation("idle")
	inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
	inst.AnimState:SetLayer(LAYER_BELOW_GROUND)
    inst.AnimState:SetSortOrder(ANIM_SORT_ORDER_BELOW_GROUND.BOAT_TRAIL)

	--link rope to flag on client
	inst.flag = net_entity(inst.GUID, "parent_flag", "receive_flag")
	inst:ListenForEvent("receive_flag", function()
		TheWorld.components.shipyardmanager:RegisterRope(inst) end)
	inst:ListenForEvent("onremove", function() 
		TheWorld.components.shipyardmanager:UnRegisterRope(inst) end)

    inst.entity:SetPristine()

	inst.persists = false
	return inst
end

return Prefab("shipyard_rope", fn, assets)
