local events =
{

}

local function SpawnFragment(lp, prefix, offset_x, offset_y, offset_z, ignite)
    local fragment = SpawnPrefab(prefix)
    fragment.Transform:SetPosition(lp.x + offset_x, lp.y + offset_y, lp.z + offset_z)

    if offset_y > 0 then
        local physics = fragment.Physics
        if physics ~= nil then
            physics:SetVel(0, -0.25, 0)
        end
    end

	if ignite then
		fragment.components.burnable:Ignite()
	end

	return fragment
end

local function getrandompoint(inst)
	local x, z, c = nil, nil, 0
	local bx, by, bz = inst.Transform:GetWorldPosition()
	while c < 50 and (x == nil or not inst:is_point_on_boat(bx + x, by, bz + z)) do
		local radius = GetRandomMinMax(0, inst.components.hull:GetRadius())
		local angle = GetRandomMinMax(0, 2 * PI)
		x, z = radius * math.cos(angle), radius * math.sin(angle)
		c = c + 1
	end
	if not inst:is_point_on_boat(bx + x, by, bz + z) then	
		x, z = 0, 0 
	end
	return x, z
end

local states =
{
    State{
        name = "place",
        onenter = function(inst)
            inst.SoundEmitter:PlaySound("turnoftides/common/together/boat/place")
            inst.SoundEmitter:PlaySound("turnoftides/common/together/water/splash/large",nil,.3)
            inst.AnimState:PlayAnimation("place")
        end,

        events =
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },
    },

    State{
        name = "idle",
        onenter = function(inst)
            inst.AnimState:PlayAnimation("idle_full", true)
        end,

        events =
        {
            EventHandler("death", function(inst) inst.sg:GoToState("ready_to_snap") end),
        },
    },

    State{
        name = "ready_to_snap",
        onenter = function(inst)
            inst.sg:SetTimeout(0.75)
        end,

        ontimeout = function(inst)
            inst.sg:GoToState("snapping")
        end,
    },


    State{
        name = "snapping",
        onenter = function(inst)
			if inst.plants then
				for _, plant in pairs(inst.plants) do
					if math.random() < 0.2 then
						plant:DoTaskInTime(3 * math.random(), function() 
							local fx_shard = SpawnPrefab("fx_shard")
							fx_shard.Transform:SetPosition(plant.Transform:GetWorldPosition())
							plant:Remove()
						end)
					end
				end
			else
		        local fx_boat_crackle = SpawnPrefab("fx_boat_crackle")
		        fx_boat_crackle.Transform:SetPosition(inst.Transform:GetWorldPosition())
			end

	        inst.AnimState:PlayAnimation("crack") 
	        inst.sg:SetTimeout(1)
	        for k,v in pairs(inst.components.walkableplatform:GetEntitiesOnPlatform()) do
	            v:PushEvent("onpresink")
	        end
        end,

        events =
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("popping") end),
        },

        timeline =
        {
            TimeEvent(0 * FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/creak")
            end),
            TimeEvent(2 * FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/damage",{intensity= .1})
            end),
            TimeEvent(17 * FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/damage",{intensity= .2})
            end),
            TimeEvent(32* FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/damage",{intensity= .3})
            end),
            TimeEvent(39* FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/damage",{intensity= .3})
            end),
            TimeEvent(39* FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/creak")
            end),
            TimeEvent(51 * FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/damage",{intensity= .4})
            end),
            TimeEvent(58 * FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/damage",{intensity= .4})
            end),
            TimeEvent(60 * FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/damage",{intensity= .5})
            end),
            TimeEvent(71 * FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/damage",{intensity= .5})
            end),
            TimeEvent(75 * FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/damage", {intensity= .6})
            end),
            TimeEvent(82 * FRAMES, function(inst)
                inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/damage", {intensity= .6})
            end),
        },
    },

    State{
        name = "popping",
        onenter = function(inst)
            local fx_boat_crackle = SpawnPrefab("fx_boat_pop")
            fx_boat_crackle.Transform:SetPosition(inst.Transform:GetWorldPosition())
            inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/damage", {intensity= 1})
            inst.SoundEmitter:PlaySoundWithParams("turnoftides/common/together/boat/sink")

            local ignitefragments = inst.activefires > 0
            local locus_point = Vector3(inst.Transform:GetWorldPosition())

			for prefab, number in pairs(inst.loot) do
				for i = 1, number do
					local x, z = getrandompoint(inst)
					SpawnFragment(locus_point, prefab, x, 0, z, ignitefragments)
				end
			end
            inst:Remove()
        end,
    }
}

return StateGraph("boat", states, events, "idle")
