require "prefabutil"

local assets =
{
	Asset("ANIM", "anim/mini_yurt.zip"),
}


local function onhammered(inst, worker)
	if inst:HasTag("fire") and inst.components.burnable then
		inst.components.burnable:Extinguish()
	end
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove()
end

local function onhit(inst, worker)
	if not inst:HasTag("burnt") then
		inst.AnimState:PlayAnimation("hit")
		inst.AnimState:PushAnimation("idle", true)
	end
end

local function onfinished(inst)
	if not inst:HasTag("burnt") then
		inst.AnimState:PlayAnimation("destroy")
		inst:ListenForEvent("animover", function(inst, data) inst:Remove() end)
		inst.SoundEmitter:PlaySound("dontstarve/common/tent_dis_pre")
		inst.persists = false
		inst:DoTaskInTime(16*FRAMES, function() inst.SoundEmitter:PlaySound("dontstarve/common/tent_dis_twirl") end)
	end
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("idle", true)
end


local function onsleep(inst, sleeper)
	if GetClock():IsDay() then
		local tosay = "ANNOUNCE_NODAYSLEEP"
		if GetWorld():IsCave() then
			tosay = "ANNOUNCE_NODAYSLEEP_CAVE"
		end
		if sleeper.components.talker then
			sleeper.components.talker:Say(GetString(sleeper.prefab, tosay))
			return
		end
	end

	if inst:HasTag("fire") then
		if sleeper.components.talker then
			sleeper.components.talker:Say(GetString(sleeper.prefab, "ANNOUNCE_NOSLEEPONFIRE"))
		end
		return
	end
	
	local hounded = GetWorld().components.hounded
	local notags = {"FX", "NOCLICK","INLIMBO"}
	local danger = FindEntity(inst, 10, function(target) 
		return
			(target:HasTag("monster") and not target:HasTag("player") and not sleeper:HasTag("spiderwhisperer"))
			or (target:HasTag("monster") and not target:HasTag("player") and sleeper:HasTag("spiderwhisperer") and not target:HasTag("spider"))
			or (target:HasTag("pig") and not target:HasTag("player") and sleeper:HasTag("spiderwhisperer"))
			or (target.components.combat and target.components.combat.target == sleeper)
	end, nil, notags)
	
	if hounded and (hounded.warning or hounded.timetoattack <= 0) then
		danger = true
	end
	
	if danger then
		if sleeper.components.talker then
			sleeper.components.talker:Say(GetString(sleeper.prefab, "ANNOUNCE_NODANGERSLEEP"))
		end
		return
	end
	
	if sleeper.components.hunger.current < TUNING.CALORIES_MED then
		sleeper.components.talker:Say(GetString(sleeper.prefab, "ANNOUNCE_NOHUNGERSLEEP"))
		return
	end
	
	sleeper.components.health:SetInvincible(true)
	sleeper.components.playercontroller:Enable(false)

	GetPlayer().HUD:Hide()
	TheFrontEnd:Fade(false,1)

	inst:DoTaskInTime(1.2, function() 
		
		GetPlayer().HUD:Show()
		TheFrontEnd:Fade(true,1) 
		
		-- if GetClock():IsDay() then

			-- local tosay = "ANNOUNCE_NODAYSLEEP"
			-- if GetWorld():IsCave() then
				-- tosay = "ANNOUNCE_NODAYSLEEP_CAVE"
			-- end

			-- if sleeper.components.talker then				
				-- sleeper.components.talker:Say(GetString(sleeper.prefab, tosay))
				-- sleeper.components.health:SetInvincible(false)
				-- sleeper.components.playercontroller:Enable(true)
				-- return
			-- end
		-- end
		
		-- SANITY_HUGE = 50
		-- CALORIES_MEDSMALL = calories_per_day/4
		-- HEALING_MEDLARGE = 30
		
		if sleeper.components.sanity then
			print("miniatureyurtSanity",miniatureyurtSanity)
			if miniatureyurtSanity == "low" then
				sleeper.components.sanity:DoDelta(TUNING.SANITY_SMALL, false)
			elseif miniatureyurtSanity == "medium" then
				sleeper.components.sanity:DoDelta(TUNING.SANITY_MEDLARGE, false)	
			elseif miniatureyurtSanity == "high" then
				sleeper.components.sanity:DoDelta(TUNING.SANITY_HUGE, false)	
			end
		end
		
		if sleeper.components.hunger then	
			print("miniatureyurtHunger",miniatureyurtHunger)
			if miniatureyurtHunger == "low" then
				sleeper.components.hunger:DoDelta(-TUNING.CALORIES_SMALL, false, true)
			elseif miniatureyurtHunger == "medium" then
				sleeper.components.hunger:DoDelta(-TUNING.CALORIES_MEDSMALL, false, true)		
			elseif miniatureyurtHunger == "high" then
				sleeper.components.hunger:DoDelta(-TUNING.CALORIES_HUGE, false, true)		
			end
		end
		
		if sleeper.components.health then
			print("miniatureyurtHealth",miniatureyurtHealth)
			if miniatureyurtHealth == "low" then
				sleeper.components.health:DoDelta(TUNING.HEALING_SMALL, false, "mini_yurt", true)
			elseif miniatureyurtHealth == "medium" then
				sleeper.components.health:DoDelta(TUNING.HEALING_MEDLARGE, false, "mini_yurt", true)	
			elseif miniatureyurtHealth == "high" then
				sleeper.components.health:DoDelta(TUNING.HEALING_LARGE, false, "mini_yurt", true)		
			end	
		end
		
		if sleeper.components.temperature and sleeper.components.temperature.current < TUNING.TARGET_SLEEP_TEMP then
			sleeper.components.temperature:SetTemperature(TUNING.TARGET_SLEEP_TEMP)
		end		
		
		local moisture_start = nil
		if sleeper.components.moisture and sleeper.components.moisture:GetMoisture() > 0 then
			moisture_start = sleeper.components.moisture.moisture
		end

		inst.components.finiteuses:Use()
		

		if moisture_start then
			sleeper.components.moisture.moisture = moisture_start - TUNING.SLEEP_MOISTURE_DELTA
			if sleeper.components.moisture.moisture < 0 then sleeper.components.moisture.moisture = 0 end
		end
		
		sleeper.components.health:SetInvincible(false)
		sleeper.components.playercontroller:Enable(true)
		sleeper.sg:GoToState("wakeup")	

		inst.components.finiteuses:Use()
		

		sleeper.components.health:SetInvincible(false)
		sleeper.components.playercontroller:Enable(true)
		sleeper.sg:GoToState("wakeup")	
	end)
end

local function onsave(inst, data)
	if inst:HasTag("burnt") or inst:HasTag("fire") then
        data.burnt = true
    end
end

local function onload(inst, data)
	if data and data.burnt then
        inst.components.burnable.onburnt(inst)
    end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst:AddTag("mini_yurt")    
    
    MakeObstaclePhysics(inst, 0.8)    

    inst:AddTag("structure")
    anim:SetBank("mini_yurt")
    anim:SetBuild("mini_yurt")
    anim:PlayAnimation("idle", true)
    
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "mini_yurt.tex" )
	
    --[[inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = 2
    inst.components.fuel.startsize = "medium"
    --]]
    
    inst:AddComponent("inspectable")

    inst:AddComponent("lootdropper")
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(4)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit)

	inst:AddComponent("finiteuses")
	print("miniatureyurtUses",miniatureyurtUses)
	if miniatureyurtUses == "low" then
		inst.components.finiteuses:SetMaxUses(16)
		inst.components.finiteuses:SetUses(16)
	elseif miniatureyurtUses == "medium" then
		inst.components.finiteuses:SetMaxUses(32)
		inst.components.finiteuses:SetUses(32)
	elseif miniatureyurtUses == "high" then
		inst.components.finiteuses:SetMaxUses(64)
		inst.components.finiteuses:SetUses(64)
	end
    inst.components.finiteuses:SetOnFinished( onfinished )
	    
		    
	inst:AddComponent("sleepingbag")
	inst.components.sleepingbag.onsleep = onsleep
	MakeSnowCovered(inst, .01)
	inst:ListenForEvent( "onbuilt", onbuilt)

	MakeLargeBurnable(inst, nil, nil, true)
	MakeLargePropagator(inst)

	inst.OnSave = onsave 
    inst.OnLoad = onload
	
    return inst
end

STRINGS.NAMES.TUB 								= "mini_yurt"
STRINGS.RECIPE_DESC.TUB							= "Like a regular tub, but more bigger"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.TUB 			= "It's big! I can see myself swimming in this."
STRINGS.CHARACTERS.WILLOW.DESCRIBE.TUB 			= "They teach a lot of things in the Girl Scouts."
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.TUB			= "Wolfgang feels more gentic after a bath."
STRINGS.CHARACTERS.WENDY.DESCRIBE.TUB 			= "Death draws closer as each hour passes."
STRINGS.CHARACTERS.WX78.DESCRIBE.TUB 				= "REBOOTING FACILITY.no!god!water!!!!!"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.TUB 		= "Maybe I need to take a bath and have a rest of my brain."
STRINGS.CHARACTERS.WOODIE.DESCRIBE.TUB 			= "It's a warm pool. Better than bathing with rain."
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.TUB 			= "Noble man needs a more study and fancy tub."

if IsDLCEnabled(REIGN_OF_GIANTS) then 
	STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.TUB 	= "As a gorgeous maiden also a female viking warrior,maybe I needs to take a bath then dress myself!"
	STRINGS.CHARACTERS.WEBBER.DESCRIBE.TUB		= "Let us take a good bath to have a relax now."
end

if IsDLCEnabled(CAPY_DLC) then 
	STRINGS.CHARACTERS.WOODLEGS.DESCRIBE.TUB		= "Reminds me of land. Lots of it."
	STRINGS.CHARACTERS.WALANI.DESCRIBE.TUB		= "Nothing like I have seen before."
	STRINGS.CHARACTERS.WARLY.DESCRIBE.TUB			= "Makes for a good restaurant theme."
end

return	Prefab( "common/objects/mini_yurt", fn, assets),
		MakePlacer( "common/mini_yurt_placer", "mini_yurt", "mini_yurt", "idle" ) 
