local unpack=GLOBAL.unpack
local require=GLOBAL.require
local Vector3=GLOBAL.Vector3
local TheInput=GLOBAL.TheInput
local EQUIPSLOTS=GLOBAL.EQUIPSLOTS
local TUNING=GLOBAL.TUNING
local ACTIONS=GLOBAL.ACTIONS
local RPC=GLOBAL.RPC
local SendRPCToServer=GLOBAL.SendRPCToServer

local HANDLED_KEY=GLOBAL["KEY_"..GetModConfigData("KEY")]

local TASK=nil
local LURES={
    d="SPOON_DAY", --REd
    n="SPOON_DUSK", --GREEn
    e="SPOON_NIGHT", --BLUe
}

local function IsHUDScreen()
    local screen=TheFrontEnd~=nil and TheFrontEnd:GetActiveScreen() or nil
	return screen and screen.name and type(screen.name) == "string" and screen.name == "HUD"
end

local function GetFishingRod()
    local fishingrod=GLOBAL.ThePlayer.replica.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
    if fishingrod~=nil and fishingrod.replica.oceanfishingrod~=nil then
        return fishingrod
    end
end

local function GetLure()
    local fishingrod=GetFishingRod()
    if fishingrod==nil then
        return
    end
    return fishingrod.replica.container:GetItems()[2] or 
        (fishingrod.replica.container and not fishingrod.replica.container._isopen and
        fishingrod.lure~=nil and fishingrod.lure:IsValid() and fishingrod.lure or nil)
end

local function GetLureEfficiency(lure)
    if lure==nil then
        return 0
    end
    local last=string.sub(lure.prefab, -1)
    local state_eff=1
    if LURES[last]~=nil then
        state_eff=TUNING.OCEANFISHING_LURE[LURES[last]].timeofday[GLOBAL.TheWorld.state.phase] or 0
    end
    local perish_eff=1
    if lure.replica.inventoryitem~=nil and lure.replica.inventoryitem.classified~=nil then
        perish_eff=math.min(lure.replica.inventoryitem.classified.perish:value()/62,1)
    end
    return state_eff*perish_eff
end

local function IsCriticalTension()
    local fishingrod=GetFishingRod()
    if fishingrod~=nil then 
        return fishingrod.replica.oceanfishingrod:IsLineTensionHigh()
    end
end

local function FindFishingPoint()
    local fish=GLOBAL.FindEntity(
        GLOBAL.ThePlayer,
        10,
        function(guy)
            return GLOBAL.TheWorld.Map:GetPlatformAtPoint(guy.Transform:GetWorldPosition())==nil
        end,
        {"oceanfishable"},
        {"INLIMBO"}
    )
    if fish~=nil then
        return fish:GetPosition()
    end
end

local function FindItem(index)
    for k,v in pairs(GLOBAL.ThePlayer.replica.inventory:GetItems()) do
        if v.prefab==index or v:HasTag(index) then
            return v
        end
    end
end

local function GetBetterLure()
    local lure=GetLureEfficiency(GetLure())
    local best={-1/0,nil,nil}
    for k,v in pairs(GLOBAL.ThePlayer.replica.inventory:GetItems()) do
        if v:HasTag("oceanfishing_lure") then 
            local efficiency=GetLureEfficiency(v)
            if best[1]<efficiency then
                best={efficiency,k,v}
            end
        end
    end
    if best[1]>lure then
        return best[3],best[2]
    end
end

local function IsFishing(onlyfish)
    local fishingrod=GetFishingRod()
    if fishingrod==nil then 
        return false
    end
    local target=fishingrod.replica.oceanfishingrod:GetTarget()
    if not onlyfish then
        return target~=nil,target
    elseif target~=nil then
        return target:HasTag("oceanfish"),target
    end
end

local function Say(text)
    GLOBAL.ThePlayer.components.talker:Say(text)
end

local function Equip(item)
    SendRPCToServer(RPC["EquipActionItem"],item)
end

local function MoveLure(lure,topocket,slot)
    local fishingrod=GetFishingRod()
    if fishingrod==nil then 
        return
    end
    if topocket then
        SendRPCToServer(RPC["MoveItemFromAllOfSlot"],2,fishingrod)
        fishingrod.lure=nil
    else
        SendRPCToServer(RPC["MoveInvItemFromAllOfSlot"],slot,fishingrod)
        fishingrod.lure=lure --Потому что не видит её когда рыбачит
    end
end

local function StartFising(x,z)
    if not GLOBAL.TheWorld.ismastersim then
        SendRPCToServer(RPC["RightClick"],ACTIONS.OCEAN_FISHING_CAST.code,x,z)
    else
        --GLOBAL.ThePlayer.sg:GoToState("oceanfishing_cast")
        --GLOBAL.BufferedAction(GLOBAL.ThePlayer, nil, ACTIONS.OCEAN_FISHING_CAST,GetFishingRod(),Vector3(x,0,z)):Do()
    end
end

local function StopFising()
    local fishing,target=IsFishing()
    if fishing then
        local pos=target:GetPosition()
        SendRPCToServer(RPC["RightClick"],ACTIONS.OCEAN_FISHING_STOP.code,pos.x,pos.z)
    end
end

local function Reel()
    local fishing,target=IsFishing()
    if fishing then
        local pos=target:GetPosition()
        SendRPCToServer(RPC["RightClick"],ACTIONS.OCEAN_FISHING_REEL.code,pos.x,pos.z)
    end
end

local function Catch()
    local fishing,target=IsFishing()
    if fishing then
        local pos=target:GetPosition()
        SendRPCToServer(RPC["RightClick"],ACTIONS.OCEAN_FISHING_CATCH.code,pos.x,pos.z)
    end
end

local function FishingTask()
    if IsFishing() then
        local fishing,fish=IsFishing(true)
        if fishing and not IsCriticalTension() then
            if fish:HasTag("oceachfishing_catchable") then
                Catch()
            else
                Reel()
            end
        elseif GetBetterLure()~=nil then
            StopFising()
        end
    else
        local fishingrod=GetFishingRod()
        if fishingrod~=nil then
            local point=FindFishingPoint()
            local lure,slot=GetBetterLure()
            if point~=nil and lure==nil then
                StartFising(point.x,point.z)
            elseif lure~=nil then
                local olure=GetLure()
                if olure~=nil then
                    MoveLure(olure,true)
                else
                    MoveLure(lure,false,slot)
                end
            end
        else
            local fishingrod=FindItem("oceanfishingrod")
            if fishingrod~=nil then
                Equip(fishingrod)
            end
        end
    end
end

TheInput:AddKeyUpHandler(HANDLED_KEY,function()
    if not IsHUDScreen() then
        return
    end
    if TASK~=nil then
        TASK:Cancel()
        TASK=nil
        Say("Disabled")
    else
        TASK=GLOBAL.ThePlayer:DoPeriodicTask(.5,FishingTask)
        Say("Enabled")
    end
end)