local assets =
{
    Asset("ANIM", "anim/sworda.zip"),	
	
	Asset("ATLAS", "images/inventoryimages/sworda.xml"),    
	Asset("IMAGE", "images/inventoryimages/sworda.tex")
}



local function onequip(inst, owner) 
	local old_abs = owner.components.health.absorb
    local skin_build = inst:GetSkinBuild()
    if skin_build ~= nil then
        owner:PushEvent("equipskinneditem", inst:GetSkinName())
        owner.AnimState:OverrideItemSkinSymbol("swap_body", skin_build, "swap_body", inst.GUID, "sworda")
    else
		owner.AnimState:OverrideSymbol("swap_body", "sworda", "swap_body")
    end 

	if owner and not owner:HasTag("boarsword") then
		owner:AddTag("boarsword")
		owner.components.health.absorb = old_abs+0.2
	end
end

local function onunequip(inst, owner) 
	local old_abs = owner.components.health.absorb
    owner.AnimState:ClearOverrideSymbol("swap_body")   
	
    local skin_build = inst:GetSkinBuild()
    if skin_build ~= nil then
        owner:PushEvent("unequipskinneditem", inst:GetSkinName())
    end	
	
	if owner and owner:HasTag("boarsword") then
		owner:RemoveTag("boarsword")
		owner.components.health.absorb = old_abs-0.2
	end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("sworda")
    inst.AnimState:SetBuild("sworda")
    inst.AnimState:PlayAnimation("anim")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")    
	inst.components.inventoryitem.imagename = "sworda"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/sworda.xml"
	
    inst:AddComponent("armor")
    inst.components.armor:InitCondition("2500", "0.2")
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY   
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    MakeHauntableLaunch(inst)
	
	local oldOnPickup = inst.components.inventoryitem.OnPickup
	inst.components.inventoryitem.OnPickup = function(self, pickupguy)
		if pickupguy.prefab == "inosuke" then
			if not self.inst.itemowner then
				self.inst.itemowner = pickupguy
			end
			if pickupguy == self.inst.itemowner then
				oldOnPickup(self, pickupguy)
			elseif pickupguy.components.talker then
				pickupguy.components.talker:Say("That sword is not mine.")
			end
		elseif pickupguy.components.talker then
			pickupguy.components.talker:Say("I cannot wield that.")
		end
	end

    return inst
end

return Prefab("sworda", fn, assets, prefabs)
