local characterName="baixue"

local DESTSOUNDS =
{
    {   --magic
        soundpath = "dontstarve/common/destroy_magic",
        ing = { "nightmarefuel", "livinglog" },
    },
    {   --cloth
        soundpath = "dontstarve/common/destroy_clothing",
        ing = { "silk", "beefalowool" },
    },
    {   --tool
        soundpath = "dontstarve/common/destroy_tool",
        ing = { "twigs" },
    },
    {   --gem
        soundpath = "dontstarve/common/gem_shatter",
        ing = { "redgem", "bluegem", "greengem", "purplegem", "yellowgem", "orangegem" },
    },
    {   --wood
        soundpath = "dontstarve/common/destroy_wood",
        ing = { "log", "boards" },
    },
    {   --stone
        soundpath = "dontstarve/common/destroy_stone",
        ing = { "rocks", "cutstone" },
    },
    {   --straw
        soundpath = "dontstarve/common/destroy_straw",
        ing = { "cutgrass", "cutreeds" },
    },
}
local DESTSOUNDSMAP = {}
for i, v in ipairs(DESTSOUNDS) do
    for i2, v2 in ipairs(v.ing) do
        DESTSOUNDSMAP[v2] = v.soundpath
    end
end
DESTSOUNDS = nil

local function CheckSpawnedLoot(loot)
    if not ((loot.components.inventoryitem ~= nil and loot.components.inventoryitem:IsHeld()) or loot:IsOnValidGround()) then
        SpawnPrefab("splash_ocean").Transform:SetPosition(loot.Transform:GetWorldPosition())
        if loot:HasTag("irreplaceable") then
            loot.Transform:SetPosition(FindSafeSpawnLocation(loot.Transform:GetWorldPosition()))
        else
            loot:Remove()
        end
    end
end

local function SpawnLootPrefab(inst, lootprefab)
    if lootprefab == nil then
        return
    end

    local loot = SpawnPrefab(lootprefab)
    if loot == nil then
        return
    end

    local x, y, z = inst.Transform:GetWorldPosition()

    if loot.Physics ~= nil then
        local angle = math.random() * 2 * PI
        loot.Physics:SetVel(2 * math.cos(angle), 10, 2 * math.sin(angle))

        if inst.Physics ~= nil then
            local len = loot.Physics:GetRadius() + inst.Physics:GetRadius()
            x = x + math.cos(angle) * len
            z = z + math.sin(angle) * len
        end

        loot:DoTaskInTime(1, CheckSpawnedLoot)
    end

    loot.Transform:SetPosition(x, y, z)

    return loot
end

local function destroystructure(staff, target)
    local recipe = AllRecipes[target.prefab]
    if recipe == nil then
        --Action filters should prevent us from reaching here normally
        return
    end

    local ingredient_percent =
        (   (target.components.finiteuses ~= nil and target.components.finiteuses:GetPercent()) or
            (target.components.fueled ~= nil and target.components.inventoryitem ~= nil and target.components.fueled:GetPercent()) or
            (target.components.armor ~= nil and target.components.inventoryitem ~= nil and target.components.armor:GetPercent()) or
            1
        ) / recipe.numtogive

    --V2C: Can't play sounds on the staff, or nobody
    --     but the user and the host will hear them!
    local caster = staff.components.inventoryitem.owner

    for i, v in ipairs(recipe.ingredients) do
        if caster ~= nil and DESTSOUNDSMAP[v.type] ~= nil then
            caster.SoundEmitter:PlaySound(DESTSOUNDSMAP[v.type])
        end
        if string.sub(v.type, -3) ~= "gem" or string.sub(v.type, -11, -4) == "precious" then
            --V2C: always at least one in case ingredient_percent is 0%
            local amt = math.max(1, math.ceil(v.amount * ingredient_percent))
            for n = 1, amt do
                SpawnLootPrefab(target, v.type)
            end
        end
    end

    if caster ~= nil then
        caster.SoundEmitter:PlaySound("dontstarve/common/staff_dissassemble")

        if caster.components.sanity ~= nil then
--            caster.components.sanity:DoDelta(-TUNING.SANITY_MEDLARGE)
        end
    end

--    staff.components.finiteuses:Use(1)

    if target.components.inventory ~= nil then
        target.components.inventory:DropEverything()
    end

    if target.components.container ~= nil then
        target.components.container:DropEverything()
    end

    if target.components.spawner ~= nil and target.components.spawner:IsOccupied() then
        target.components.spawner:ReleaseChild()
    end

    if target.components.occupiable ~= nil and target.components.occupiable:IsOccupied() then
        local item = target.components.occupiable:Harvest()
        if item ~= nil then
            item.Transform:SetPosition(target.Transform:GetWorldPosition())
            item.components.inventoryitem:OnDropped()
        end
    end

    if target.components.trap ~= nil then
        target.components.trap:Harvest()
    end

    if target.components.stackable ~= nil then
        --if it's stackable we only want to destroy one of them.
        target.components.stackable:Get():Remove()
    else
        target:Remove()
    end
end

local function applyupgrades(inst)
    local max_upgrades = 30
    inst.level = math.min(inst.level, max_upgrades)

    local hunger_percent = inst.components.hunger:GetPercent()
    local health_percent = inst.components.health:GetPercent()
    local sanity_percent = inst.components.sanity:GetPercent()

    inst.components.hunger.max = math.ceil(175 + (inst.level < 21 and 0 or inst.level-21) * 3)
    inst.components.health.maxhealth = math.ceil(200 + (inst.level < 21 and 0 or inst.level-21) * 3)
    inst.components.sanity.max = math.ceil(200 + (inst.level < 21 and 0 or inst.level-21) * 5)

    inst.components.hunger:SetPercent(hunger_percent)
    inst.components.health:SetPercent(health_percent)
    inst.components.sanity:SetPercent(sanity_percent)
	
	inst.baoji = inst.level < 11 and inst.level * .03 or .3
	
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, characterName.."_level", inst.level < 11 and 1 or (inst.level < 21 and 1 + (inst.level-21) * .2 or 1 + 2))
end	

local function onpreload(inst, data)
    if data ~= nil and data.level ~= nil then
        inst.level = data.level
        applyupgrades(inst)
        if data.health and data.health.health then inst.components.health:SetCurrentHealth(data.health.health) end
        if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
        if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
        inst.components.health:DoDelta(0)
        inst.components.hunger:DoDelta(0)
        inst.components.sanity:DoDelta(0)
    end
end

local function onsave(inst, data)
    data.level = inst.level > 0 and inst.level or nil
end		

local function LevelUp(inst)
	inst.level = inst.level + 1
	applyupgrades(inst) 
	inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
end

local function oneat(inst, food)
    if food and food.components.edible then
        if inst.level < 11 and food.prefab == "redgem" then
			LevelUp(inst)
		elseif inst.level < 21 and food.prefab == "bluegem" then
			LevelUp(inst)
		elseif food.prefab == "purplegem" then
			LevelUp(inst)
		end
    end
end												

local MakePlayerCharacter = require "prefabs/player_common"
return MakePlayerCharacter(characterName, {}, {}, 
function(inst) 
	inst:AddTag(characterName.."_skiller")
	inst.MiniMapEntity:SetIcon(characterName..".tex")
end, 
function(inst)
	inst.soundsname = "wilson"
																						
	inst.components.health:SetMaxHealth(175)
	inst.components.hunger:SetMax(175)
	inst.components.sanity:SetMax(175)
																						
	function inst.components.combat:ApplyDamageMult()
		self.damagemultiplier = 1.3
		for k,v in pairs(self.ExternalDamageMults or {}) do
			if v then
				self.damagemultiplier = self.damagemultiplier + v
			end
		end
	end
	function inst.components.combat:SetExternalDamageMult(key, value)
		self.ExternalDamageMults = self.ExternalDamageMults or {} 
		self.ExternalDamageMults[key] = value
		self:ApplyDamageMult()
	end
	inst.components.combat:ApplyDamageMult()
																						
	inst.components.sanity.night_drain_mult = 1.5
	inst.components.sanity.neg_aura_mult = 1.1
	
        inst:AddComponent("reader")																					
	inst.components.hunger.hungerrate = 1.5 * TUNING.WILSON_HUNGER_RATE
	inst.components.sanity.dapperness = TUNING.DAPPERNESS_LARGE
        inst.components.temperature.inherentinsulation = (TUNING.INSULATION_PER_BEARD_BIT * 0.5)
        inst.components.combat.min_attack_period = 0.1
        inst.components.locomotor.walkspeed = 8
        inst.components.locomotor.runspeed = 10
	inst.components.sanity.neg_aura_mult = 0
																				
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, characterName, 1)
	
	--
	inst:DoPeriodicTask(1, function()
		if TheWorld.state.isfullmoon then
			inst:AddTag("notarget")
		else
			inst:RemoveTag("notarget")
		end
	end)
	
	local light = inst.entity:AddLight()
	inst.Light:Enable(true)
	inst.Light:SetRadius(10)
	inst.Light:SetFalloff(.5)
	inst.Light:SetIntensity(0.9)
	inst.Light:SetColour(245/85,85/85,245/85)
	
	inst.level = 0
	
	table.insert(inst.components.eater.preferseating, FOODTYPE.ELEMENTAL)
    table.insert(inst.components.eater.caneat, FOODTYPE.ELEMENTAL)
    inst:AddTag(FOODTYPE.ELEMENTAL.."_eater")
	inst.components.eater:SetOnEatFn(oneat)
	
	applyupgrades(inst)
	inst.OnSave = onsave
    inst.OnPreLoad = onpreload
	
end, 
{																						
	--"spear",	
	"baixue_dao",
})

,Prefab("baixue_dao",function()
	local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)   
    inst.AnimState:SetBank("baixue_dao")
    inst.AnimState:SetBuild("baixue_dao")
    inst.AnimState:PlayAnimation("idle")
    inst:AddTag("sharp")
    if not TheWorld.ismastersim then
        return inst
    end
    inst.entity:SetPristine()
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(77)
	inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 1.33)
    inst.components.tool:SetAction(ACTIONS.MINE, 1.33)
	inst:AddComponent("spellcaster")
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canonlyuseonrecipes = true
    inst.components.spellcaster:SetSpellFn(destroystructure)
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "baixue_dao"
    inst.components.inventoryitem.atlasname = "images/baixue_dao.xml"
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( function (inst, owner)
		owner.AnimState:OverrideSymbol("swap_object", "baixue_dao_swap", "baixue_dao_swap")
		owner.AnimState:Show("ARM_carry")
		owner.AnimState:Hide("ARM_normal")
	end )
    inst.components.equippable:SetOnUnequip( function (inst, owner)
		owner.AnimState:Hide("ARM_carry")
		owner.AnimState:Show("ARM_normal")
	end )
    return inst
end,
{
	Asset("ANIM", "anim/baixue_dao.zip"),
    Asset("ANIM", "anim/baixue_dao_swap.zip"),
    Asset("ATLAS", "images/baixue_dao.xml"),
})

,Prefab("baixue_biandang",function()
	local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)   
    inst.AnimState:SetBank("baixue_biandang")
    inst.AnimState:SetBuild("baixue_biandang")
    inst.AnimState:PlayAnimation("idle")
    if not TheWorld.ismastersim then
        return inst
    end
    inst.entity:SetPristine()
    inst:AddComponent("inspectable")
    inst:AddComponent("edible")
	inst.components.edible.healthvalue = 55
    inst.components.edible.hungervalue = 77
    inst.components.edible.sanityvalue = 33
    inst.components.edible.foodtype = FOODTYPE.MEAT
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "baixue_biandang"
    inst.components.inventoryitem.atlasname = "images/baixue_biandang.xml"
    return inst
end,
{
	Asset("ANIM", "anim/baixue_biandang.zip"),
    Asset("ATLAS", "images/baixue_biandang.xml"),
})

,Prefab("baixue_smzy",function()
	local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)   
    inst.AnimState:SetBank("baixue_smzy")
    inst.AnimState:SetBuild("baixue_smzy")
    inst.AnimState:PlayAnimation("idle")
    if not TheWorld.ismastersim then
        return inst
    end
    inst.entity:SetPristine()
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(30)
    inst.components.weapon:SetRange(12,16)
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(500)
    inst.components.finiteuses:SetUses(500)
    inst.components.finiteuses:SetOnFinished(inst.Remove)
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "baixue_smzy"
    inst.components.inventoryitem.atlasname = "images/baixue_smzy.xml"
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( function (inst, owner)
		owner.AnimState:OverrideSymbol("swap_object", "baixue_smzy_swap", "baixue_smzy_swap")
		owner.AnimState:Show("ARM_carry")
		owner.AnimState:Hide("ARM_normal")
	end )
    inst.components.equippable:SetOnUnequip( function (inst, owner)
		owner.AnimState:Hide("ARM_carry")
		owner.AnimState:Show("ARM_normal")
	end )
    return inst
end,
{
	Asset("ANIM", "anim/baixue_smzy.zip"),
	Asset("ANIM", "anim/baixue_smzy_swap.zip"),
    Asset("ATLAS", "images/baixue_smzy.xml"),
})

,Prefab("baixue_feidao",function()
	local inst = CreateEntity()
    inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	inst.AnimState:SetBank("izayoi_sword")
    inst.AnimState:SetBuild("izayoi_sword")
	inst.AnimState:PlayAnimation("spin_loop", true)
	inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)
	inst:AddTag("NOCLICK")
	inst:AddTag("FX")
--	inst:AddTag("izayoi_sword_fx")
    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	inst.SoundEmitter:PlaySound("dontstarve/wilson/boomerang_throw")
--	inst._collide_table = {}
	local dmg = 100
	local period = 1/30
	inst:DoPeriodicTask(period, function()
		if inst then
			local x, y, z = inst.Transform:GetWorldPosition()	
			local ents = TheSim:FindEntities(x, y, z, 1.5)
			for k, v in pairs(ents) do
				if v and v:IsValid() and not v:HasTag("INLIMBO") and v ~= inst.master and 
					not (v.components.follower and v.components.follower.leader == inst.master ) and 
					(TheNet:GetPVPEnabled() or not v:HasTag("player")) and
--					not table.contains(inst._collide_table, v.GUID) and 
					not v:HasTag("companion")
				then
					if v.components.health and not v.components.health:IsDead() and v.components.combat then
						SpawnPrefab("sparks").Transform:SetPosition(v:GetPosition():Get())
						if v.components.combat.Zg_GetAttacked then
							v.components.combat:Zg_GetAttacked(inst.master, dmg)
						else
							v.components.combat:GetAttacked(inst.master, dmg)
						end
						SpawnPrefab("sparks").Transform:SetPosition(x, y, z)
						inst:Remove()
--						table.insert(inst._collide_table, v.GUID)
					end
				end
			end
			--[[if inst._targetpos then
				local dist2 = inst._targetpos:Dist( inst:GetPosition() )
				if dist2 <= .5 then
					RemoveSelf(inst)
				end
			end--]]
		end
	end)
	inst:DoTaskInTime(1.5, function()
		local x, y, z = inst.Transform:GetWorldPosition()	
		SpawnPrefab("sparks").Transform:SetPosition(x, y, z)
		inst:Remove()
	end)
    return inst
end,
{
	Asset("ANIM", "anim/izayoi_sword.zip"),
})




