local characterName="template"															

local MakePlayerCharacter = require "prefabs/player_common"
return MakePlayerCharacter(characterName, {}, {}, 
function(inst) 
	inst:AddTag(characterName.."_skiller")
	inst.MiniMapEntity:SetIcon(characterName..".tex")
end, 
function(inst)
	inst.soundsname = "wilson"
																						
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(200)
																						
	function inst.components.combat:ApplyDamageMult()
		self.damagemultiplier = 1
		for k,v in pairs(self.ExternalDamageMults or {}) do
			if v then
				self.damagemultiplier = self.damagemultiplier + v
			end
		end
	end
	function inst.components.combat:SetExternalDamageMult(key, value)
		self.ExternalDamageMults = self.ExternalDamageMults or {} 
		self.ExternalDamageMults[key] = value
		self:ApplyDamageMult()
	end
	inst.components.combat:ApplyDamageMult()
																						
	inst.components.sanity.night_drain_mult = 1
	inst.components.sanity.neg_aura_mult = 1
																						
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
																						
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, characterName, 1)
	
end, 
{																						
	--"spear",						
})
