local characterName="baixue"							

local localPrefabFiles={
	characterName, 
}
local localAssets={
	Asset( "ATLAS", "images/saveslot_portraits/"..characterName..".xml" ),
    Asset( "ATLAS", "bigportraits/"..characterName..".xml" ),
	Asset( "ATLAS", "images/map_icons/"..characterName..".xml" ),
    Asset( "ATLAS", "images/avatars/avatar_"..characterName..".xml" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_"..characterName..".xml" ),
	Asset( "ANIM", "anim/"..characterName..".zip" ),
	Asset( "ANIM", "anim/ghost_"..characterName.."_build.zip" ),
--[[
	Asset("SOUNDPACKAGE", "sound/"..characterName..".fev"),	
	Asset("SOUND", "sound/"..characterName..".fsb"),
--]]
}

for k,v in pairs(localPrefabFiles) do
	if v then 
		table.insert(PrefabFiles,v)
	end
end
for k,v in pairs(localAssets) do
	if v then
		table.insert(Assets,v)
	end
end
STRINGS.CHARACTER_TITLES[characterName] = "星伽白雪"	
STRINGS.CHARACTER_NAMES[characterName] = characterName
STRINGS.CHARACTER_DESCRIPTIONS[characterName] = 		
[[*传统的大和抚子
*性格很温柔但是对金次有独特的喜爱
*对情敌十分恐怖
]]
STRINGS.CHARACTER_QUOTES[characterName] = "\"\""	
STRINGS.NAMES[string.upper(characterName)] = characterName

STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(characterName)] = 
{
	GENERIC = "",
	ATTACKER = "",
	MURDERER = "",
	REVIVER = "",
	GHOST = "",
}
AddMinimapAtlas("images/map_icons/"..characterName..".xml")
AddModCharacter(characterName, "FEMALE")					


table.insert(Assets, Asset("ATLAS", "images/"..characterName.."128.xml"))
local characterTab = AddRecipeTab(characterName, -1, "images/"..characterName.."128.xml", characterName.."128.tex", characterName.."_skiller")

SetDesc("baixue_dao","绯金色女","绯金色女","绯金色女")

local product = "baixue_biandang"
AddRecipe(product, 
{
	Ingredient("humanmeat",1),
},
characterTab, TECH.NONE, nil, nil, nil, nil, nil, 
"images/"..product..".xml", product..".tex")
SetDesc(product,"魔鬼便当","魔鬼便当","魔鬼便当")

local product = "baixue_smzy"
AddRecipe(product, 
{
	Ingredient("flint",12), Ingredient("goldnugget",7), Ingredient("bluegem",1)
},
characterTab, TECH.NONE, nil, nil, nil, nil, nil, 
"images/"..product..".xml", product..".tex")
SetDesc(product,"沙漠之鹰","沙漠之鹰","沙漠之鹰")


local base_x = -750	---750
local delta_x = 175	--175

local skill_valid={										
	z={validfn=function(inst, x, y, z)
		if inst.sg and not inst.sg:HasStateTag("busy") and not inst:HasTag("playerghost") then
			return inst["z_skill"]
		end
	end,cd=30,atlas="",id=0,name="星伽忍术",info=""},
	
	x={validfn=function(inst, x, y, z)
		if inst.sg and not inst.sg:HasStateTag("busy") and not inst:HasTag("playerghost") then
			return inst["x_skill"]
		end
	end,cd=15,atlas="",id=1,name="鬼道术",info=""},
	
	c={validfn=function(inst, x, y, z)
		if inst.sg and not inst.sg:HasStateTag("busy") and not inst:HasTag("playerghost") then
			return inst["c_skill"]
		end
	end,cd=20,atlas="",id=2,name="绯绯星伽神",info=""},
	
	v={validfn=function(inst, x, y, z)
		if inst.sg and not inst.sg:HasStateTag("busy") and not inst:HasTag("playerghost") then
			return inst["v_skill"]
		end
	end,cd=30,atlas="",id=3,name="星伽剑气波",info=""},
}

local function ValidGround(x,y,z)
	local map = TheWorld.Map
    local ptx, pty, ptz = x, y, z
    local tilecenter_x, tilecenter_y, tilecenter_z  = map:GetTileCenterPoint(ptx, 0, ptz)
    local tx, ty = map:GetTileCoordsAtPoint(ptx, 0, ptz)
    local actual_tile = map:GetTile(tx, ty)
    if actual_tile ~= nil and tilecenter_x ~= nil and tilecenter_z ~= nil then
        if actual_tile == GROUND.IMPASSABLE then
            local xpercent = (tilecenter_x - ptx) / TILE_SCALE + .5
            local ypercent = (tilecenter_z - ptz) / TILE_SCALE + .5
            local x_min = xpercent > .666 and -1 or 0
            local x_max = xpercent < .333 and 1 or 0
            local y_min = ypercent > .666 and -1 or 0
            local y_max = ypercent < .333 and 1 or 0
            local x_off = 0
            local y_off = 0
            for x = x_min, x_max do
                for y = y_min, y_max do
                    local tile = map:GetTile(tx + x, ty + y)
                    if tile > actual_tile then
                        actual_tile = tile
                        x_off = x
                        y_off = y
                    end
                end
            end
        end
    end
	return actual_tile ~= nil and actual_tile ~= GROUND.IMPASSABLE
end

local skill_valid2={
	z={validfn=function(inst, x, y, z)
		return skill_valid.z.validfn(inst, x, y, z)
	end},
	
	x={validfn=function(inst, x, y, z)
		return skill_valid.x.validfn(inst, x, y, z)
	end},
	
	c={validfn=function(inst, x, y, z)
		if not ValidGround(x,y,z) then
			inst.components.talker:Say("不是有效的位置")
			return
		end
		return skill_valid.c.validfn(inst, x, y, z)
	end},
	
	v={validfn=function(inst, x, y, z)
		return skill_valid.v.validfn(inst, x, y, z)
	end},
}

local skills = {									
	z = function(inst, x, y, z)
			if not inst.components.health:IsDead() then
				--发射飞刀
				local a,b,c = inst.Transform:GetWorldPosition()
				local angle = inst:GetAngleToPoint(x,y,z)
				local angles = {}
				local num = 15
				for k = 1, num do
					angles[k] = angle + (k-1)*360/num
					while angles[k] > 360 do
						angles[k] = angles[k] - 360
					end
					local fx = SpawnPrefab("baixue_feidao")
					fx.Transform:SetPosition(a,b,c)
					fx.Transform:SetRotation(angles[k])
					fx.Physics:SetMotorVelOverride(15,0,0)
				end
			end
		end,
		
	x = function(inst, x, y, z)
			if not inst.components.health:IsDead() then
				--眩晕, 选最近的敌人
				local tar = FindEntity(inst, 15, function(guy)
					return guy 
						and guy.components.combat 
						and not guy.components.combat:IsAlly(inst)
						and guy.brain
				end)
				if tar then
					local a,b,c = tar.Transform:GetWorldPosition()
					SpawnPrefab("lightning").Transform:SetPosition(a,b,c)
					tar.brain:Stop()
					tar.components.combat:SetTarget(nil)
					if tar.components.locomotor then
						tar.components.locomotor:Stop()
					end
					if tar.sg and tar.sg.sg and tar.sg.sg.states and tar.sg.sg.states["idle"] then
						tar.sg:GoToState("idle")
					end
					if tar.AnimState then
						tar.AnimState:SetMultColour(.5,.5,.5,1)	
					end
					tar:DoTaskInTime(4.3, function()
						if tar and tar.brain then
							tar.brain:Start()
							if tar.AnimState then
								tar.AnimState:SetMultColour(1,1,1,1)	
							end
						end
					end)
				end
			end
		end,
		
	c = function(inst, x, y, z)
			if not inst.components.health:IsDead() then
				--冲刺
				inst.Transform:SetPosition(x,y,z)
				local tauntfx = SpawnPrefab("tauntfire_fx")
				tauntfx.Transform:SetPosition(x, y, z)
				tauntfx.Transform:SetRotation(inst.Transform:GetRotation())
				local ents = TheSim:FindEntities(x, y, z, 6, nil, { "FX", "NOCLICK", "DECOR", "INLIMBO" })
				for k, v in pairs(ents) do
					if v 
						and v.components.health 
						and v.components.combat 
						and not v.components.combat:IsAlly(inst) 
						then
						v.components.health:DoFireDamage(123, inst, true)
					end
				end
			end
		end,	
		
	v = function(inst, x, y, z)
			if not inst.components.health:IsDead() then
				--剑气
			end
		end,
}
for key, v in pairs(skills) do
	AddModRPCHandler(characterName, key.."_skill", v)
end

local handlers = {}
AddPlayerPostInit(function(inst)
	if inst.prefab == characterName then
		inst:AddComponent("timer")
		inst:ListenForEvent("timerdone", function(inst, data) inst[data.name] = true end)
		for key, v in pairs(skill_valid) do
			inst[key.."_skill"] = true					
			if not ( inst[key.."_skill"] or inst.components.timer:TimerExists(key.."_skill") ) then
				inst.components.timer:StartTimer(key.."_skill", v.cd)
			end
		end
		for key, v in pairs(skill_valid) do
			handlers[key] = TheInput:AddKeyDownHandler(GLOBAL["KEY_"..(string.upper(key))], function() 
				if inst == ThePlayer then
					local x, y, z = ( TheInput:GetWorldPosition() or Vector3(0,0,0) ):Get()
					local screen = TheFrontEnd:GetActiveScreen()
					local IsHUDActive = screen and screen.name == "HUD"
					if inst:IsValid() and skill_valid2[key].validfn(inst, x, y, z) and IsHUDActive then
						inst[key.."_skill"] = false
						if not ( inst[key.."_skill"] or inst.components.timer:TimerExists(key.."_skill") ) then
							inst.components.timer:StartTimer(key.."_skill", v.cd)
						end
						SendModRPCToServer(MOD_RPC[characterName][key.."_skill"], x, y, z) 
					end
				end
			end)
		end
	end
end)

for key, info in pairs(skill_valid) do	
	if info and info.atlas and info.atlas~="" then
		table.insert(Assets, Asset("ATLAS", "images/"..info.atlas..".xml"))
	end
end	
local skillsbutton = require("widgets/"..characterName.."_skillbutton")
local function AddSkillButton(self) 
	if self.owner and self.owner:HasTag(characterName.."_skiller") then	
		for key, info in pairs(skill_valid) do	
			if info then
				self["skillbutton_"..key] = self:AddChild( skillsbutton("images/"..info.atlas..".xml", info.atlas..".tex", base_x + delta_x * info.id, nil, nil, info.name, info.info) )
			end
		end											
		local old_OnUpdate = self.OnUpdate
		self.OnUpdate = function(self, dt)
			old_OnUpdate(self, dt)
			local x, y, z = ( TheInput:GetWorldPosition() or Vector3(0,0,0) ):Get()
			for key, info in pairs(skill_valid) do
				if info then
					if self.owner[key.."_skill"] ~= true then
						self["skillbutton_"..key]:SetTint(0.2,0.2,0.2,1)
						self["skillbutton_"..key]:SetColour(1,0,0,1)
						self["skillbutton_"..key]:SetString( math.ceil( self.owner.components.timer:GetTimeLeft(key.."_skill") or 0) )
					elseif info.validfn(self.owner, x, y, z) ~= true then
						self["skillbutton_"..key]:SetTint(0.2,0.2,0.2,1)
						self["skillbutton_"..key]:SetColour(1,0,0,1)
						self["skillbutton_"..key]:SetString(string.upper(key))
					else
						self["skillbutton_"..key]:SetTint(1,1,1,1)
						self["skillbutton_"..key]:SetColour(0,1,0,1)
						self["skillbutton_"..key]:SetString(string.upper(key))
					end
				end
			end
		end
	end
end
AddClassPostConstruct("widgets/inventorybar", AddSkillButton)


AddPlayerPostInit(function(inst)
	if TheNet:GetIsServer() then
		inst:ListenForEvent("onhitother",function(inst,data)
			if data.damage then
				local x,y,z = inst.Transform:GetWorldPosition()
				local ents = TheSim:FindEntities(x,y,z,10)
				local count = 0
				for k,v in pairs(ents) do
					if v and v.prefab == characterName then
						count = count + 1
					end
				end
				if not inst.components.health:IsDead() and count > 0 then
					inst.components.health:DoDelta(data.damage*count*.25)
				end
			end
		end)
		
		inst:DoPeriodicTask(1,function()
			if TheWorld.state.isfullmoon then
				local x,y,z = inst.Transform:GetWorldPosition()
				local ents = TheSim:FindEntities(x,y,z,10)
				local count = 0
				for k,v in pairs(ents) do
					if v and v.prefab == characterName then
						count = count + 1
					end
				end
				inst.components.locomotor:SetExternalSpeedMultiplier(inst, characterName.."_buff", 1+count*.2)
				if not inst.components.health:IsDead() then
					inst.components.health:DoDelta(5*count)
				end
			else
				inst.components.locomotor:SetExternalSpeedMultiplier(inst, characterName.."_buff", 1)
			end
		end)
	end
end)

AddPrefabPostInitAny(function(inst)
	if TheNet:GetIsServer() then
		if not inst:HasTag("player")
			and inst.components.combat
			and inst.components.locomotor
			then
			
			function inst.components.combat:ApplyDamageMult()
				self.damagemultiplier = self.damagemultiplier or 1
				for k,v in pairs(self.ExternalDamageMults or {}) do
					if v then
						self.damagemultiplier = self.damagemultiplier + v
					end
				end
			end
			function inst.components.combat:SetExternalDamageMult(key, value)
				self.ExternalDamageMults = self.ExternalDamageMults or {} 
				self.ExternalDamageMults[key] = value
				self:ApplyDamageMult()
			end
			inst.components.combat:ApplyDamageMult()
			
			inst:DoPeriodicTask(1,function()
				if TheWorld.state.isfullmoon then
					local x,y,z = inst.Transform:GetWorldPosition()
					local ents = TheSim:FindEntities(x,y,z,10)
					local count = 0
					for k,v in pairs(ents) do
						if v and v.prefab == characterName then
							count = count + 1
						end
					end
					if count > 0 then
						inst.components.locomotor:SetExternalSpeedMultiplier(inst, characterName.."_buff", .8)
						inst.components.combat:SetExternalDamageMult(characterName.."_buff", -.4)
					else
						inst.components.locomotor:SetExternalSpeedMultiplier(inst, characterName.."_buff", 1)
						inst.components.combat:SetExternalDamageMult(characterName.."_buff", 0)
					end
				else
					inst.components.locomotor:SetExternalSpeedMultiplier(inst, characterName.."_buff", 1)
					inst.components.combat:SetExternalDamageMult(characterName.."_buff", 0)
				end
			end)
		end
	end
end)





















