local characterName="template"							

local localPrefabFiles={
	characterName, 
}
local localAssets={
	Asset( "ATLAS", "images/saveslot_portraits/"..characterName..".xml" ),
    Asset( "ATLAS", "bigportraits/"..characterName..".xml" ),
	Asset( "ATLAS", "images/map_icons/"..characterName..".xml" ),
    Asset( "ATLAS", "images/avatars/avatar_"..characterName..".xml" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_"..characterName..".xml" ),
	Asset( "ANIM", "anim/"..characterName..".zip" ),
	Asset( "ANIM", "anim/ghost_"..characterName.."_build.zip" ),
--[[
	Asset("SOUNDPACKAGE", "sound/"..characterName..".fev"),	
	Asset("SOUND", "sound/"..characterName..".fsb"),
--]]
}

for k,v in pairs(localPrefabFiles) do
	if v then 
		table.insert(PrefabFiles,v)
	end
end
for k,v in pairs(localAssets) do
	if v then
		table.insert(Assets,v)
	end
end
STRINGS.CHARACTER_TITLES[characterName] = "示例人物"	
STRINGS.CHARACTER_NAMES[characterName] = characterName
STRINGS.CHARACTER_DESCRIPTIONS[characterName] = 		
[[*介绍1
*介绍2
*介绍3
]]
STRINGS.CHARACTER_QUOTES[characterName] = "\"座右铭\""	
STRINGS.NAMES[string.upper(characterName)] = characterName

STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(characterName)] = 
{
	GENERIC = "",
	ATTACKER = "",
	MURDERER = "",
	REVIVER = "",
	GHOST = "",
}
AddMinimapAtlas("images/map_icons/"..characterName..".xml")
AddModCharacter(characterName, "MALE")					

--[[
table.insert(Assets, Asset("ATLAS", "images/"..characterName.."128.xml"))
local characterTab = AddRecipeTab(characterName, -1, "images/"..characterName.."128.xml", characterName.."128.tex", characterName.."_skiller")
--]]

--[[
local product = "spear"
AddRecipe(product, 
{
	Ingredient("moonrocknugget",20), Ingredient("trinket_1", 1),
},
characterTab, TECH.NONE, nil, nil, nil, nil, nil, 
"images/"..product..".xml", product..".tex")
SetDesc(product,"示例物品","示例物品的检阅信息","示例物品配方描述")
--]]

--[[
local base_x = -750	---750
local delta_x = 175	--175

local skill_valid={										
	z={validfn=function(inst, x, y, z)
		if inst.sg and not inst.sg:HasStateTag("busy") and not inst:HasTag("playerghost") then
			return inst["z_skill"]
		end
	end,cd=3,atlas="",id=0,name="技能名字",info="(说明)"},
}

local skill_valid2={
	z={validfn=function(inst, x, y, z)
		return skill_valid.z.validfn(inst, x, y, z)
	end},
}

local skills = {									
	z = function(inst, x, y, z)
			if not inst.components.health:IsDead() then
				
			end
		end,
}
for key, v in pairs(skills) do
	AddModRPCHandler(characterName, key.."_skill", v)
end

local handlers = {}
AddPlayerPostInit(function(inst)
	if inst.prefab == characterName then
		inst:AddComponent("timer")
		inst:ListenForEvent("timerdone", function(inst, data) inst[data.name] = true end)
		for key, v in pairs(skill_valid) do
			inst[key.."_skill"] = true					
			if not ( inst[key.."_skill"] or inst.components.timer:TimerExists(key.."_skill") ) then
				inst.components.timer:StartTimer(key.."_skill", v.cd)
			end
		end
		for key, v in pairs(skill_valid) do
			handlers[key] = TheInput:AddKeyDownHandler(GLOBAL["KEY_"..(string.upper(key))], function() 
				if inst == ThePlayer then
					local x, y, z = ( TheInput:GetWorldPosition() or Vector3(0,0,0) ):Get()
					local screen = TheFrontEnd:GetActiveScreen()
					local IsHUDActive = screen and screen.name == "HUD"
					if inst:IsValid() and skill_valid2[key].validfn(inst, x, y, z) and IsHUDActive then
						inst[key.."_skill"] = false
						if not ( inst[key.."_skill"] or inst.components.timer:TimerExists(key.."_skill") ) then
							inst.components.timer:StartTimer(key.."_skill", v.cd)
						end
						SendModRPCToServer(MOD_RPC[characterName][key.."_skill"], x, y, z) 
					end
				end
			end)
		end
	end
end)

for key, info in pairs(skill_valid) do	
	if info and info.atlas and info.atlas~="" then
		table.insert(Assets, Asset("ATLAS", "images/"..info.atlas..".xml"))
	end
end	
local skillsbutton = require("widgets/"..characterName.."_skillbutton")
local function AddSkillButton(self) 
	if self.owner and self.owner:HasTag(characterName.."_skiller") then	
		for key, info in pairs(skill_valid) do	
			if info then
				self["skillbutton_"..key] = self:AddChild( skillsbutton("images/"..info.atlas..".xml", info.atlas..".tex", base_x + delta_x * info.id, nil, nil, info.name, info.info) )
			end
		end											
		local old_OnUpdate = self.OnUpdate
		self.OnUpdate = function(self, dt)
			old_OnUpdate(self, dt)
			local x, y, z = ( TheInput:GetWorldPosition() or Vector3(0,0,0) ):Get()
			for key, info in pairs(skill_valid) do
				if info then
					if self.owner[key.."_skill"] ~= true then
						self["skillbutton_"..key]:SetTint(0.2,0.2,0.2,1)
						self["skillbutton_"..key]:SetColour(1,0,0,1)
						self["skillbutton_"..key]:SetString( math.ceil( self.owner.components.timer:GetTimeLeft(key.."_skill") or 0) )
					elseif info.validfn(self.owner, x, y, z) ~= true then
						self["skillbutton_"..key]:SetTint(0.2,0.2,0.2,1)
						self["skillbutton_"..key]:SetColour(1,0,0,1)
						self["skillbutton_"..key]:SetString(string.upper(key))
					else
						self["skillbutton_"..key]:SetTint(1,1,1,1)
						self["skillbutton_"..key]:SetColour(0,1,0,1)
						self["skillbutton_"..key]:SetString(string.upper(key))
					end
				end
			end
		end
	end
end
AddClassPostConstruct("widgets/inventorybar", AddSkillButton)
--]]
























