require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/treasure_chest.zip"),
	Asset("ANIM", "anim/ui_chest_3x2.zip"),
	

	Asset("ANIM", "anim/pandoras_chest.zip"),
	Asset("ANIM", "anim/skull_chest.zip"),
	Asset("ANIM", "anim/pandoras_chest_large.zip"),
	Asset("ANIM", "anim/luggage.zip"),
	Asset("ANIM", "anim/octopus_chest.zip"),
	
	Asset("MINIMAP_IMAGE", "treasure_chest"),
	Asset("MINIMAP_IMAGE", "minotaur_chest"),
	Asset("MINIMAP_IMAGE", "pandoras_chest"),
	Asset("MINIMAP_IMAGE", "luggage_chest"),
}

local prefabs =
{
	"collapse_small",
}

local chests = {
	treasure_chest = {
		bank="chest",
		build="treasure_chest",
	},
	skull_chest = {
		bank="skull_chest",
		build="skull_chest",
	},
	pandoras_chest = {
		bank="pandoras_chest",
		build="pandoras_chest",
	},
	minotaur_chest = {
		bank = "pandoras_chest_large",
		build = "pandoras_chest_large",
	},
	luggage_chest = {
		bank = "luggage",
		build = "luggage",
	},
	octopus_chest = {
		bank = "octopus_chest",
		build = "octopus_chest",
	},
}


local function onopen(inst) 
	if not inst:HasTag("burnt") then
		inst.AnimState:PlayAnimation("open")

		if inst:HasTag("aquatic") then
			inst.AnimState:PushAnimation("opened", true)
		end

		if inst.prefab == "luggagechest" then
			inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/steamer_trunk/steamer_trunk_open")
		else
			inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
		end
	end
end 

local function onclose(inst)
	if not inst:HasTag("burnt") then
		inst.AnimState:PlayAnimation("close")

		if inst:HasTag("aquatic") then
			inst.AnimState:PushAnimation("closed", true)
		end
		
		if inst.prefab == "luggagechest" then
			inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/steamer_trunk/steamer_trunk_close")
		else
			inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")
		end
	end
end

local function oncloseocto(inst)
	if not inst:HasTag("burnt") then
		inst.AnimState:PlayAnimation("close")
		inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")

		if not inst.components.container:IsEmpty() then
			inst.AnimState:PushAnimation("closed", true)
			return
		else
		
			inst.AnimState:PushAnimation("sink", false)
			
			inst:DoTaskInTime(96*FRAMES, function (inst)
				inst.SoundEmitter:PlaySound("dontstarve_DLC002/creatures/seacreature_movement/splash_small")
			end)

			inst:ListenForEvent("animqueueover", function (inst)
				inst:Remove()
			end)
		end
	end
end 

local function onhammered(inst, worker)
	if inst:HasTag("fire") and inst.components.burnable then
		inst.components.burnable:Extinguish()
	end
	inst.components.lootdropper:DropLoot()
	if inst.components.container then inst.components.container:DropEverything() end
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")	
	inst:Remove()
end

local function onhit(inst, worker)
	if not inst:HasTag("burnt") then
		inst.AnimState:PlayAnimation("hit")
		inst.AnimState:PushAnimation("closed", true)
		if inst.components.container then 
			inst.components.container:DropEverything() 
			inst.components.container:Close()
		end
	end
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("closed", true)
end

local function onsave(inst, data)
	if inst:HasTag("burnt") or inst:HasTag("fire") then
		data.burnt = true
	end
end

local joecounter = 1
local function onload(inst, data)
	if data and data.burnt then
		inst.components.burnable.onburnt(inst)
	end

	-- from the worldgen data
	if data and data.joeluggage then
		joecounter = joecounter%4
		inst:AddComponent("scenariorunner")
		inst.components.scenariorunner:SetScript("chest_luggage"..tostring(joecounter + 1))
		inst.components.scenariorunner:Run()
		joecounter = joecounter + 1
	end
end

local slotpos = {}

for y = 2, 0, -1 do
	for x = 0, 2 do
		table.insert(slotpos, Vector3(80*x-80*2+80, 80*y-80*2+80,0))
	end
end
		
local function chest(style)
	local fn = function(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		local minimap = inst.entity:AddMiniMapEntity()
		minimap:SetIcon( style..".png" )
		
		inst:AddTag("structure")
		inst:AddTag("chest")
		inst.AnimState:SetBank(chests[style].bank)
		inst.AnimState:SetBuild(chests[style].build)
		inst.AnimState:PlayAnimation("closed", true)
		
		inst:AddComponent("floatable")

		inst:AddComponent("inspectable")
		inst:AddComponent("container")
		inst.components.container:SetNumSlots(#slotpos)
		
		inst.components.container.onopenfn = onopen
		inst.components.container.onclosefn = onclose
		
		inst.components.container.widgetslotpos = slotpos
		inst.components.container.widgetanimbank = "ui_chest_3x3"
		inst.components.container.widgetanimbuild = "ui_chest_3x3"
		inst.components.container.widgetpos = Vector3(0,200,0)
		inst.components.container.side_align_tip = 160
		
		if style ~= "octopus_chest" then
			inst:AddComponent("lootdropper")
			inst:AddComponent("workable")
			inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
			inst.components.workable:SetWorkLeft(2)
			inst.components.workable:SetOnFinishCallback(onhammered)
			inst.components.workable:SetOnWorkCallback(onhit)
		else
			MakeInventoryPhysics(inst)
			inst:AddComponent("inventoryitem")
			inst.components.inventoryitem.canbepickedup = false
			inst.components.inventoryitem.cangoincontainer = false
			inst.components.inventoryitem.nobounce = true
			inst.components.container.onclosefn = oncloseocto
		end
		
		inst:ListenForEvent( "onbuilt", onbuilt)
		MakeInventoryPhysics(inst)
local function turnon(inst)
    inst.components.machine.ison = true
    inst:AddComponent("inventoryitem")
end
local function turnoff(inst)
    inst.components.machine.ison = false
    inst:RemoveComponent("inventoryitem")
end
    inst:AddComponent("machine")
    inst.components.machine.turnonfn = turnon
    inst.components.machine.turnofffn = turnoff
    inst:AddComponent("equippable")	

		MakeSmallBurnable(inst, nil, nil, true)
		MakeSmallPropagator(inst)

		inst.OnSave = onsave 
		inst.OnLoad = onload

		if style == "luggage_chest" or style == "octopus_chest" then
			inst:AddTag("aquatic")
			inst:AddComponent("waterproofer")
    		inst.components.waterproofer.effectiveness = 0
		end

		return inst
	end
	return fn
end



return Prefab( "common/treasurechest", chest("treasure_chest"), assets, prefabs),
		MakePlacer("common/treasurechest_placer", "chest", "treasure_chest", "closed"),
		Prefab( "common/pandoraschest", chest("pandoras_chest"), assets, prefabs),
		Prefab( "common/skullchest", chest("skull_chest"), assets, prefabs),
		Prefab("common/minotaurchest", chest("minotaur_chest"), assets, prefabs),
		Prefab("common/luggagechest", chest("luggage_chest"), assets, prefabs),
		Prefab("common/octopuschest", chest("octopus_chest"), assets, prefabs)

