<?php

/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
class Ctl_Product extends Ctl {
    
    public function items($cat_id=0,$brand_id=0,$page=1){
        $this->index($cat_id, $brand_id, $page);
    }
    
    public function  index($cat_id=0,$brand_id=0,$page=1){
        $cat_id = (int) $cat_id;
        $brand_id = (int)$brand_id;
        $cateList = K::M('product/cate')->fetch_all();
        $filter = $pager = array();
        $pager['page'] = max(intval($page), 1);
        $pager['limit'] = $limit = 50;
        if(isset($cateList[$cat_id])){
            $cate = $cateList[$cat_id];
            $childCate = $cateIds = array();
            if($cate['parent_id'] == 0){  
                foreach($cateList as $val){
                    if($val['parent_id'] == $cat_id){
                        $childCate[] = $val;
                        $cateIds[] =$val['cat_id'];
                    }
                }
            }else{
                foreach($cateList as $val){
                   if($val['parent_id'] == $cate['parent_id']){
                        $childCate[] = $val;
                    } 
                }
                $this->pagedata['parent_id'] = $cate['parent_id'];
            }
            $filter['cat_id'] = empty($cateIds) ?  $cat_id :$cateIds; 
            $brandList = K::M('product/brand')->items_by_cat($cat_id);
            if($brandList){
                $this->pagedata['brandList'] = $brandList;
                if(isset($brandList[$brand_id])){
                    $filter['brand_id'] = $brand_id;
                }
            }
            $this->pagedata['childCate'] = $childCate;
        }
        if ($items = K::M('product/product')->items($filter, null, $page, $limit, $count)) {
            $pager['count'] = $count;
            $pager['pagebar'] = $this->mkpage($count, $limit, $page, $this->mklink('product:items', array($cat_id,$brand_id, '{page}')), array());
        }
        $this->pagedata['items'] = $items;
        $this->pagedata['pager'] = $pager;
        
        $this->pagedata['cateList'] = $cateList;
        $this->pagedata['cat_id'] = $cat_id;
        $this->pagedata['brand_id'] = $brand_id;
        K::M('helper/seo')->init('product',array(
                    'cat_name'      =>  isset($cate) ? $cate['cat_name'] : '',
                    'brand_name'    => isset($brandList[$brand_id]) ? $brandList[$brand_id]['brand_name'] : ''
        ));
        $this->tmpl = 'product.html';
    }
    
    public function detail($product_id){
        if(!($product_id = (int)$product_id) && !($product_id = (int)$this->GP('product_id'))){
            $this->error(404);
        }else if(!$detail = K::M('product/product')->detail($product_id)){
            $this->error(404);
        }else{
            K::M('helper/seo')->init('product_detail',array(
                'title'      =>  $detail['product_name'],    
            ));
            $this->pagedata['cate'] = K::M('product/cate')->detail($detail['cat_id']);
            $this->pagedata['brand'] = K::M('product/brand')->detail($detail['brand_id']);
            $this->pagedata['detail'] = $detail;
            $this->tmpl = 'product_detail.html';
        }
    }
    
    
    public function yuyue($product_id){
        if(!($product_id = (int)$product_id) && !($product_id = (int)$this->GP('product_id'))){
            $this->err->add('没有您要的数据', 211);
        }else if(!$detail = K::M('product/product')->detail($product_id)){
            $this->err->add('没有您要的数据', 212);
        }else{
            if($this->checksubmit('data')){
               if(!$data = $this->GP('data')){
                    $this->err->add('非法的数据提交', 201);
                }else{
                    $data['product_id'] = $product_id;
                    if($yuyue_id = K::M('product/yuyue')->create($data)){
                        $obj = K::M('sms/sms');
                        $obj->send($data['mobile'],'sms_product_yuyue',array('name'=>$data['contact'] ? $data['contact'] : '业主','mobile'=>$data['mobile'],'product'=>$detail['product_name']));
                        $obj->admin('sms_admin_product',array('name'=>$data['contact'] ? $data['contact'] : '业主','mobile'=>$data['mobile'],'product'=>$detail['product_name']));
                        K::M('net/tongji')->commit('product',$yuyue_id,  $this->request['ismobile']);
                        K::M('product/product')->update_count($product_id,'yue_num');
                        $this->err->add('添加内容成功');
                    }
                } 
            }else{
                $this->pagedata['detail'] = $detail;
                $this->tmpl = 'product_yuyue.html';              
            }
        }
    }
    
}
    