local assets=
{
    Asset("ANIM", "anim/anchor.zip"),
    Asset("ANIM", "anim/swap_anchor.zip"),
  
    Asset("ATLAS", "images/inventoryimages/anchor.xml"),
    Asset("IMAGE", "images/inventoryimages/anchor.tex"),
}

local prefabs = 
{

}

--Taken from Arcade's Momiji

local function ShouldAcceptItem(inst, item)
    if item.prefab == "flint" then
       return true
    end
    return false
end

local function OnGetItemFromPlayer(inst, giver, item)
    if item.prefab == "flint" then
       inst.components.finiteuses.current = inst.components.finiteuses.current + inst.components.finiteuses.total *0.2
    end
    if inst.components.finiteuses.current > inst.components.finiteuses.total then
       inst.components.finiteuses.current = inst.components.finiteuses.total
    end
end

local function OnEquip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_anchor", "anchor")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end
  
local function OnUnequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end
 
local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
     
    MakeInventoryPhysics(inst)   
      
    inst.AnimState:SetBank("anchor")
    inst.AnimState:SetBuild("anchor")
    inst.AnimState:PlayAnimation("idle")
 
    inst:AddTag("sharp")
 
    if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()
     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(48)
	
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(100)
    inst.components.finiteuses:SetUses(100)
    if inst.components.finiteuses.current < 0 then
       inst.components.finiteuses.current = 0
    end

    inst.components.finiteuses:SetOnFinished(inst.Remove)
	  
    inst:AddComponent("inspectable")
      
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "anchor"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/anchor.xml"
      
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	inst.components.equippable.walkspeedmult = 0.9
	
    inst:AddComponent("trader")
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
	     
    return inst
end

STRINGS.NAMES.ANCHOR = "Anchor"
STRINGS.RECIPE_DESC.ANCHOR = "Weigh anchor!"
STRINGS.CHARACTERS.IKAZUCHI.DESCRIBE.ANCHOR = "It's my trusty anchor."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ANCHOR = "It's Ikazuchi's anchor."

return  Prefab("common/inventory/anchor", fn, assets, prefabs) 