
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting items
local no_inv = {
}

-- Custom starting items
local start_inv = {
	"anchor",
}

local function productivityreset(inst) --Taken from Buster
    if(inst.productivitysanitytimer~=nil)
    then
        inst.productivitysanitytimer:Cancel()
        inst.productivitysanitytimer = nil
		inst.productivitysanityrate = inst.productivitysanityrate + 0.05
		if inst.productivitysanityrate >= 0.2 then
			inst.productivitysanityrate = 0.2
		end
    end
    inst.productivitysanitytimer = inst:DoPeriodicTask(30,
        function()
			inst.productivitysanityrate = inst.productivitysanityrate - 0.05
			if inst.productivitysanityrate <= -0.2 then
				inst.productivitysanityrate = -0.2
				inst.productivitysanitytimer:Cancel()
				inst.productivitysanitytimer = nil
			end
        end
    )
end
local function onproductivityreset(inst, data)
    productivityreset(inst)
end

local function ondeath(inst)
    inst.components.talker:Say((GetString(inst, "ANNOUNCE_DEATH")))
	if(inst.productivitysanitytimer~=nil)
    then
        inst.productivitysanitytimer:Cancel()
        inst.productivitysanitytimer = nil
		inst.productivitysanityrate = 0
    end
end

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	productivityreset(inst)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "ikazuchi_speed_mod", 1)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "ikazuchi_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "ikazuchi.tex" )
	inst:AddTag("anchor_builder")
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	inst.productivitysanityrate = 0
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(100)
	
	--Productivity (Taken from Buster)
	if TUNING.IKAZUCHI.RELY_ON_ME == true then
		productivityreset(inst)
		local custom_rate_fn_old = inst.components.sanity.custom_rate_fn
		inst.components.sanity.custom_rate_fn = function(inst)
			local deltaRate = (inst.productivitysanityrate or 0)
			if(custom_rate_fn_old~=nil)
			then
				deltaRate = deltaRate + custom_rate_fn_old(inst)
			end
			return deltaRate
		end
		--inst:ListenForEvent("donecooking", onproductivityreset)
		inst:ListenForEvent("onattackother", onproductivityreset)
		inst:ListenForEvent("onmissother", onproductivityreset)
		inst:ListenForEvent("working", onproductivityreset)
		inst:ListenForEvent("finishedwork", onproductivityreset)
		inst:ListenForEvent("picksomething", onproductivityreset)
		inst:ListenForEvent("killed", onproductivityreset)
	end
	
	-- Speed Modifier
	if TUNING.IKAZUCHI.LIGHTNING_SPEED == true then
		inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.25)
		inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.25)
	end
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	inst:ListenForEvent("death", ondeath)
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
end

if TUNING.IKAZUCHI.WEIGH_ANCHOR == true then
	return MakePlayerCharacter("ikazuchi", prefabs, assets, common_postinit, master_postinit, start_inv)
else
	return MakePlayerCharacter("ikazuchi", prefabs, assets, common_postinit, master_postinit, no_inv)
end