PrefabFiles = {
	"akatsuki",
	"akatsuki_none",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/akatsuki.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/akatsuki.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/akatsuki.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/akatsuki.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/akatsuki_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/akatsuki_silho.xml" ),

    Asset( "IMAGE", "bigportraits/akatsuki.tex" ),
    Asset( "ATLAS", "bigportraits/akatsuki.xml" ),
	
	Asset( "IMAGE", "images/map_icons/akatsuki.tex" ),
	Asset( "ATLAS", "images/map_icons/akatsuki.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_akatsuki.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_akatsuki.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_akatsuki.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_akatsuki.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_akatsuki.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_akatsuki.xml" ),
	
	Asset( "IMAGE", "images/names_akatsuki.tex" ),
    Asset( "ATLAS", "images/names_akatsuki.xml" ),
	
    Asset( "IMAGE", "bigportraits/akatsuki_none.tex" ),
    Asset( "ATLAS", "bigportraits/akatsuki_none.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

GLOBAL.TUNING.AKATSUKI = {}
if GetModConfigData("Nameship Leadership") == "Off" then
	GLOBAL.TUNING.AKATSUKI.NAMESHIP_LEADERSHIP = false
else
	GLOBAL.TUNING.AKATSUKI.NAMESHIP_LEADERSHIP = true
end

if GetModConfigData("Properly Dressed") == "Off" then
	GLOBAL.TUNING.AKATSUKI.PROPERLY_DRESSED = false
else
	GLOBAL.TUNING.AKATSUKI.PROPERLY_DRESSED = true
end

if GetModConfigData("Draw Fire") == "Off" then
	GLOBAL.TUNING.AKATSUKI.DRAW_FIRE = false
else
	GLOBAL.TUNING.AKATSUKI.DRAW_FIRE = true
end

local leadership_auras = {} --Taken from broccoli

AddPrefabPostInit("akatsuki", function(inst)
    if not GLOBAL.TheWorld.ismastersim then
        return
    end
    leadership_auras[inst.GUID] = { range = 10, mult_bonus = 1.10, absorb_per = 0.10 }
    inst.OnDespawn = function(inst)
        leadership_auras[inst.GUID] = nil
    end
end)
  
AddPlayerPostInit(function(inst)
    if inst.components.combat == nil then
        return
	end
    if not GLOBAL.TheWorld.ismastersim then
        return
    end
    local old_cd = inst.components.combat.CalcDamage
    inst.components.combat.CalcDamage = function(self, target, weapon, multiplier)
		if GLOBAL.TUNING.AKATSUKI.NAMESHIP_LEADERSHIP == true then
			for k, v in pairs(leadership_auras) do
				local p = GLOBAL.Ents[k]
				if p ~= self.inst and p:IsNear(self.inst, v.range) then
					multiplier = (multiplier or 1) * v.mult_bonus
					break
				end
			end
		end
        return old_cd(self, target, weapon, multiplier)
    end
    local old_ga = inst.components.combat.GetAttacked
    inst.components.combat.GetAttacked = function(self, attacker, damage, weapon, stimuli)
		if GLOBAL.TUNING.AKATSUKI.NAMESHIP_LEADERSHIP == true then
			if damage ~= nil then
				for k, v in pairs(leadership_auras) do
					local p = GLOBAL.Ents[k]
					if p ~= self.inst and p:IsNear(self.inst, v.range) then
						damage = damage * (1 - v.absorb_per)
						break
					end
				end
			end
		end
        return old_ga(self, attacker, damage, weapon, stimuli)
    end
end)

-- The character select screen lines
STRINGS.CHARACTER_TITLES.akatsuki = "First-class Lady"
STRINGS.CHARACTER_NAMES.akatsuki = "Akatsuki"
STRINGS.CHARACTER_DESCRIPTIONS.akatsuki = "*Nameship Leadership\n*Properly Dressed\n*Draw Fire"
STRINGS.CHARACTER_QUOTES.akatsuki = "\"Treat me like the fully-fledged lady that I am!\""

-- Custom speech strings
STRINGS.CHARACTERS.AKATSUKI = require "speech_akatsuki"

-- The character's name as appears in-game 
STRINGS.NAMES.AKATSUKI = "Akatsuki"

AddMinimapAtlas("images/map_icons/akatsuki.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("akatsuki", "FEMALE")

