
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting items
local no_inv = {
}

local start_inv = {
	"lantern",
}

local TAUNTABLETAGS = { -- from Tirix
	"monster", 
	"moose", 
	"frog",
	"tallbird",
	"merm",
	"walrus",
	"killer",
}

local function ontaunt(inst)
	if TUNING.AKATSUKI.DRAW_FIRE == true then
		if inst:HasTag("lightequipped") or inst:HasTag("torchequipped") then
			--print("Taunting!")
			local x,y,z = inst.Transform:GetWorldPosition()
			local ents = TheSim:FindEntities(x,y,z, SpringCombatMod(10), {"_combat"}, {"INLIMBO", "player"}, TAUNTABLETAGS )
			for k,v in pairs(ents) do 
				if not (v.components.health and v.components.health:IsDead()) and (v.components.combat and v.components.combat.target ~= inst) and not(inst.components.sanity and inst.components.sanity:IsSane() and v:HasTag("shadowcreature")) then
					v.components.combat:SetTarget(inst)
				end
			end
		end
	end
end

local function ondeath(inst)
    inst.components.talker:Say((GetString(inst, "ANNOUNCE_DEATH")))
	if TUNING.AKATSUKI.DRAW_FIRE == true then
		if inst.taunt_task ~= nil then
			inst.taunt_task:Cancel()
			inst.taunt_task = nil
		end
	end
	inst:RemoveTag("hatequipped")
	inst:RemoveTag("armorequipped")
	inst:RemoveTag("torchequipped")
	inst:RemoveTag("lightequipped")
end

local function lightcheck(inst)
	if TUNING.AKATSUKI.DRAW_FIRE == true then
		if inst:HasTag("torchequipped") or inst:HasTag("lightequipped") then
			if inst.taunt_task == nil then
				inst.taunt_task = inst:DoPeriodicTask(1, ontaunt, nil, 1)
				ontaunt(inst, 0)
			end
		else
			if inst.taunt_task ~= nil then
				inst.taunt_task:Cancel()
				inst.taunt_task = nil
			end
		end
	end
end

local function onequip(inst, item)
	if item.eslot == EQUIPSLOTS.HEAD then
		local equip = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
		if equip.prefab == "minerhat" or
		equip.prefab == "molehat" then
			inst:AddTag("lightequipped")
		end
		inst:AddTag("hatequipped")
	end
	if item.eslot == EQUIPSLOTS.BODY then
		local equip = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.BODY)
		inst:AddTag("armorequipped")
	end
	if item.eslot == EQUIPSLOTS.HANDS then
		local equip = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
		if equip.prefab == "torch" or
		equip.prefab == "lantern" or
		equip.prefab == "lighter" then
			--print("TORCH!")
			inst:AddTag("torchequipped")
		end
	end
	lightcheck(inst)
end

local function onunequip(inst, item)
	if item.eslot == EQUIPSLOTS.HEAD then
		inst:RemoveTag("lightequipped")
		inst:RemoveTag("hatequipped")
	end
	if item.eslot == EQUIPSLOTS.BODY then
		inst:RemoveTag("armorequipped")
	end
	if item.eslot == EQUIPSLOTS.HANDS then
		--print("NO TORCH!")
		inst:RemoveTag("torchequipped")
	end
	lightcheck(inst)
end

-- When the character is revived from human
local function onbecamehuman(inst)
	lightcheck(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "akatsuki_speed_mod", 1)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "akatsuki_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
	lightcheck(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "akatsuki.tex" )
	inst:AddTag("anchor_builder")
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"	
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(125)
	inst.components.hunger:SetMax(125)
	inst.components.sanity:SetMax(150)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	if TUNING.AKATSUKI.PROPERLY_DRESSED == true then
		inst.components.sanity.custom_rate_fn = function(inst)
			local deltaclothes = 0
			if inst:HasTag("hatequipped") then
				deltaclothes = deltaclothes + 0.1
			end
			if inst:HasTag("armorequipped") then
				deltaclothes = deltaclothes + 0.1
			end
			return deltaclothes
		end
	end
	
	inst:ListenForEvent("equip", onequip)
	inst:ListenForEvent("unequip", onunequip)
	inst:ListenForEvent("death", ondeath)
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
end

if TUNING.AKATSUKI.DRAW_FIRE == true then
	return MakePlayerCharacter("akatsuki", prefabs, assets, common_postinit, master_postinit, start_inv)
else
	return MakePlayerCharacter("akatsuki", prefabs, assets, common_postinit, master_postinit, no_inv)
end
