
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
	Asset("ANIM", "anim/plasma.zip"),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
}

local function ondeath(inst)
	inst.components.talker:Say((GetString(inst, "ANNOUNCE_DEATH")))
    if inst.nanodeath == true and TUNING.INAZUMA.SERIOUS_SIDE == true then
		inst.AnimState:SetBuild("inazuma")
		if TUNING.INAZUMA.RELUCTANCE == true then
			inst.components.combat.damagemultiplier = 0.75
		else
			inst.components.combat.damagemultiplier = 1
		end
		inst.components.health:SetAbsorptionAmount(0)
		inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1)
		inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1)
		inst.nanodeath = false
		if inst.nanodeath_task ~= nil then
			inst.nanodeath_task:Cancel()
			inst.nanodeath_task = nil
		end
	end
end

local function OnEat(inst, food)
    if food.prefab == "eggplant"
	or food.prefab == "eggplant_cooked"
	or food.prefab == "stuffedeggplant"
	then
		if inst.nanodeath == true and TUNING.INAZUMA.SERIOUS_SIDE == true then
			inst.components.sanity:DoDelta(-20)
			inst.sg:GoToState("electrocute")
			inst.AnimState:SetBuild("inazuma")
			inst.components.talker:Say(GetString(inst, "ANNOUNCE_EGGPLANTRETURN"))
			if TUNING.INAZUMA.RELUCTANCE == true then
				inst.components.combat.damagemultiplier = 0.75
			else
				inst.components.combat.damagemultiplier = 1
			end
			inst.components.health:SetAbsorptionAmount(0)
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1)
			inst.nanodeath = false
			if inst.nanodeath_task ~= nil then
				inst.nanodeath_task:Cancel()
				inst.nanodeath_task = nil
			end
		else
			inst.components.sanity:DoDelta(-10)
			inst.components.talker:Say(GetString(inst, "ANNOUNCE_EGGPLANT"))
		end
    end
end

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "inazuma_speed_mod", 1)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "inazuma_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

local function onupdate(inst, dt)
	if	TUNING.INAZUMA.SERIOUS_SIDE == true then
		if inst.components.sanity.current > 100 and inst.nanodeath == true then
			inst.sg:GoToState("electrocute")
			inst.AnimState:SetBuild("inazuma")
			inst.components.talker:Say(GetString(inst, "ANNOUNCE_RETURN"))
			if TUNING.INAZUMA.RELUCTANCE == true then
				inst.components.combat.damagemultiplier = 0.75
			else
				inst.components.combat.damagemultiplier = 1
			end
			inst.components.health:SetAbsorptionAmount(0)
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1)
			inst.nanodeath = false
			if inst.nanodeath_task ~= nil then
				inst.nanodeath_task:Cancel()
				inst.nanodeath_task = nil
			end
		end
	end
end

local function onlightingstrike(inst)
	if inst.components.health ~= nil and not (inst.components.health:IsDead() or inst.components.health:IsInvincible()) then
		if inst.components.inventory:IsInsulated() then
			inst:PushEvent("lightningdamageavoided")
		else
			if TUNING.INAZUMA.SERIOUS_SIDE == true then
				if inst.nanodeath == false then
					inst.AnimState:SetBuild("plasma")
					inst.sg:GoToState("electrocute")
					--inst.components.health:DoDelta(TUNING.HEALING_SUPERHUGE, false, "lightning")
					inst.components.sanity:DoDelta(-TUNING.SANITY_HUGE)
					inst.components.talker:Say(GetString(inst, "ANNOUNCE_CHARGE"))
					inst.components.combat.damagemultiplier = 1.5
					inst.components.health:SetAbsorptionAmount(-0.5)
					inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.1)
					inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.1)
					inst.nanodeath = true
					if inst.nanodeath_task == nil then
						inst.nanodeath_task = inst:DoPeriodicTask(1, onupdate, nil, 1)
						onupdate(inst, 0)
					end					
				else
					inst.sg:GoToState("electrocute")
					inst.components.sanity:DoDelta(-TUNING.SANITY_MEDLARGE)
					inst.components.talker:Say(GetString(inst, "ANNOUNCE_DOUBLECHARGE"))
				end
			else
				local mult = TUNING.ELECTRIC_WET_DAMAGE_MULT * inst.components.moisture:GetMoisturePercent()
				local damage = TUNING.LIGHTNING_DAMAGE + mult * TUNING.LIGHTNING_DAMAGE
				-- Magic hit point stuff that isn't being used right now
				-- if damage >= inst.components.health.currenthealth - 5 and inst.components.health.currenthealth > 10 then
				--     damage = inst.components.health.currenthealth - 5
				-- end

				inst.components.health:DoDelta(-damage, false, "lightning")
				inst.sg:GoToState("electrocute")
			end
		end
	end
end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "inazuma.tex" )
	inst:AddTag("anchor_builder")
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.nanodeath = false
	inst.nanodeath_task = nil
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(150)
	
	-- Sanity aura to nearby players, opposite if Plasma form
	if TUNING.INAZUMA.TRULY_ANGEL == true then
		inst:AddComponent("sanityaura")
		inst.components.sanityaura.aurafn = function(inst, observer)
			if inst.nanodeath == true then
				if observer.prefab == "hibiki" then 
					return 0
				else
					return -TUNING.SANITYAURA_TINY
				end
			else
				return TUNING.SANITYAURA_TINY
			end
			return 0
		end
	end
	
	local function sanityfn(inst)
		if TUNING.INAZUMA.SERIOUS_SIDE == true then
			local w = TheWorld.state
			if w.israining then
				if inst.nanodeath == false then
					return -(TUNING.SANITYAURA_TINY)
				end
			else
				if inst.nanodeath == true then
					return -(TUNING.SANITYAURA_TINY)
				end
			end
		end
		return 0
	end
	inst.components.sanity.custom_rate_fn = sanityfn
	
	if TUNING.INAZUMA.SERIOUS_SIDE == true then
		inst.components.playerlightningtarget:SetHitChance(1)
		inst.components.playerlightningtarget:SetOnStrikeFn(onlightingstrike)
	end
	
	-- Damage multiplier (optional)
	if TUNING.INAZUMA.RELUCTANCE == true then
		inst.components.combat.damagemultiplier = 0.75
	end
	inst.components.health:SetAbsorptionAmount(0)
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	inst.components.eater:SetOnEatFn(OnEat)
	inst:ListenForEvent("death", ondeath)
	
	if TUNING.INAZUMA.RELUCTANCE == true then
		-- Dodge mechanic taken from http://steamcommunity.com/sharedfiles/filedetails/?id=612991019
		inst._GetAttacked = inst.components.combat.GetAttacked
		inst.components.combat.GetAttacked = function(attacker, damage, weapon, stimuli)
			if math.random() > .10 then
				inst._GetAttacked(attacker, damage, weapon, stimuli) 
			else
				if inst.nanodeath == false then
					inst.components.talker:Say(GetString(inst, "ANNOUNCE_AVOID"))
				else
					inst._GetAttacked(attacker, damage, weapon, stimuli) 
				end
			end
		end
	end
end

return MakePlayerCharacter("inazuma", prefabs, assets, common_postinit, master_postinit, start_inv)
