#Python 3.8.6
#coding:utf-8

名字 = '间书'
版本 = '0.1'
主页 = "https://err44.com/间书"
作者 = '空想'
博客 = 'https://err44.com'
捐赠 = 'https://err44.com/捐赠'
初时 = '2020/10/06 03:10:13'
末日 = '2020/10/15 08:00:01'

#导入引用库
import os,datetime,time,threading
from multiprocessing import Pool

import requests,ast,colorama
from flask import Flask
from lxml import etree




#初始化变量
with open(f'data/config.ini','r',encoding='utf-8') as f:
    x = ast.literal_eval(f.read())
    #
    PID = os.getpid()
    colorama.init(True)

    WEB_开关 = x["WEB_开关"]
    WEB_PID = False
    WEB_WWW = "127.0.0.1"
    WEB_PORT = x["WEB_PORT"]
    WEB_地址 = F"http://{WEB_WWW}:{WEB_PORT}"
    if WEB_PORT == 80:
        WEB_地址 = F"http://{WEB_WWW}"
    if WEB_PORT == 443:
        WEB_地址 = F"https://{WEB_WWW}"

    代理开关 = x["代理开关"]
    代理协议 = x["代理协议"]
    代理网址 = x["代理网址"]
    代理端口 = x["代理端口"]

    订阅频率 = x["订阅频率"]
    订阅次数 = 0

    if 代理开关:
        代理 = {
                    "http": f"{代理协议}://{代理网址}:{代理端口}",
                    "https": f"{代理协议}://{代理网址}:{代理端口}",
                    }
        代理开关 = (colorama.Fore.GREEN + "启动" + colorama.Fore.RESET)
    else:
        代理 = None
        代理开关 = (colorama.Fore.RED + "关闭" + colorama.Fore.RESET)



#main
def main():
    with open(f'data/model.ini','r',encoding='utf-8') as f:
        model = ast.literal_eval(f.read())
    with open(f'data/save.ini','r',encoding='utf-8') as f:
        save = ast.literal_eval(f.read())


    def run(k,x,pid):
        url = k+str(pid)
        if pid=="/":
            url = k
        headers = x["headers"]
        try:                    #尝试执行代码
            html_text = requests.get(url,timeout=20,proxies=代理,headers=headers).text
            html = etree.HTML(html_text)
        except:					#如果代码抛出错误，运行下面代码
            print(colorama.Fore.RED + "获取失败",url)
            print("")
        print(colorama.Fore.GREEN + "获取成功",url)

        title  = html.xpath('/html/head/title/text()')[0]
        if x["rss标题xp"]:    title = html.xpath(F'{x["rss标题xp"]}')[0]
        imgurl = ""
        if x["rss封面xp"]:    imgurl = html.xpath(F'{x["rss封面xp"]}')[0]
        简介    = html.xpath('/html/head/title/text()')[0]
        if x["rss简介xp"]:    简介 = html.xpath(F'{x["rss简介xp"]}')[0]

        titles = html.xpath(F'{x["标题xp组"]}')
        urls = html.xpath(F'{x["链接xp组"]}')
        imgs = []
        if x["预览xp组"]:    imgs = html.xpath(F'{x["预览xp组"]}')
        dates = []
        if x["时间xp组"]:    dates = html.xpath(F'{x["时间xp组"]}')
        # print(titles,imgs,urls)



        a = f"""<?xml version="1.0" encoding="UTF-8"?>
        <rss version="2.0">

        <channel>

            <title><![CDATA[{title}]]></title>
            <link>{url}</link>
            <description><![CDATA[{简介}]]></description>
            <generator>间书</generator>
            <pubDate>{datetime.datetime.now()}</pubDate>
            """




        o = ""
        oY = False
        i = 0
        for t,l in zip(titles,urls):
            tiao = False
            if url not in save : save[url] = [[],[]]
            if x["过滤选项"] == 0:
                if t in save[url][0]:
                    tiao = True
                    break
            elif x["过滤选项"] == 1:
                if l in save[url][1]:
                    tiao = True
                    break
            
            if not tiao:
                d = datetime.datetime.now()
                if dates:
                    d = dates[i]
                if imgs:
                    imgurl = imgs[i]
                i += 1

                o += f"""
            <item>
            <title><![CDATA[{t}]]></title>
            <description><img src="{x["封面补全"]+imgurl}" title="{title}" alt="{title}" /></description>
            <link>{x["链接补全"]+l}</link>
            <pubDate>{d}</pubDate>
            </item>
            """

                oY = True
                if url not in save:
                    save[url] = [[],[]]
                save[url][0].append(t)
                save[url][1].append(l)

                

        z = """
        </channel>

        </rss>
        """
        rss = a+o+z
        # print(a+o+z)


        
        保存目录 = x["保存目录"]
        if not 保存目录:
            保存目录 = k.split("//")[1]
            if pid == "/":
                保存目录 = 保存目录.split("/")
                pid = 保存目录[-1]
                del 保存目录[-1]
                保存目录 = "/".join(保存目录)
                保存目录 += "/"

        if not os.path.exists(F"rss/{保存目录}"):  # 判断是否存在目录
            os.makedirs(F"rss/{保存目录}")

        if oY:
            # 保存目录 = x["保存目录"]
            # if 保存目录:
            #     if "//" in 保存目录:
            #         保存目录 = k.split("//")[1]
                    
            #     if pid == "/":
            #         pid = ""
            #         保存目录 = 保存目录.rstrip("/")
            #         c = 保存目录.split("/")[-1]
            #         a = 保存目录.rstrip("/"+c)
            #         if not os.path.exists(F"rss/{a}"):  # 判断是否存在文件
            #             os.makedirs(F"rss/{a}")
            #     else:
            #         if not os.path.exists(F"rss/{保存目录}"):  # 判断是否存在目录
            #             os.makedirs(F"rss/{保存目录}")

            with open(f'rss/{保存目录}{pid}','w',encoding='utf-8') as f:
                f.write(f"{rss}")
            with open(f'data/save.ini','w',encoding='utf-8') as f:
                f.write(f"{save}")
            print(colorama.Fore.GREEN + "成功更新",title)
            print("订阅链接",WEB_地址+"/rss"+F"/{保存目录}{pid}")
            print("")
        else:
            # 保存目录 = x["保存目录"]
            # if 保存目录 and "//" in 保存目录: 保存目录 = k.split("//")[1]
            print("暂无更新",title)
            print("订阅链接",WEB_地址+"/rss"+F"/{保存目录}{pid}")
            print("")


    for k,x in model.items():
        for q in x["ID"]:
            po.apply_async(run(k,x,pid=q))



def web():
    global WEB_PID,WEB_地址,WEB_开关
    web = Flask(__name__,static_folder="")

    #get访问
    @web.route("/")
    def hello_world():
        return "间书 web服务"

    WEB_PID = threading.get_native_id()

    if WEB_开关:
        WEB_开关 = (colorama.Fore.GREEN + "启动" + colorama.Fore.RESET)
    else:
        WEB_开关 = (colorama.Fore.RED + "关闭" + colorama.Fore.RESET)
        WEB_地址 = False
        return 0

    web.run(host=WEB_WWW,port=WEB_PORT)
    



def 公告():
    global 订阅次数

    订阅次数 += 1

    # os.system("cls")

    print(f"""{"—"*50}

    名字：\t{名字}
    版本：\t{版本}
    主页：\t{主页}
    作者：\t{作者}
    博客：\t{博客}
    捐赠：\t{捐赠}
    初时：\t{初时}
    末日：\t{末日}

    主进程ID：\t{PID}

    web状态：\t{WEB_开关}
    web线程ID：\t{WEB_PID}
    web域名：\t{WEB_WWW}
    web端口：\t{WEB_PORT}
    web地址：\t{WEB_地址}

    代理状态：\t{代理开关}
    代理协议：\t{代理协议}
    代理网址：\t{代理网址}
    代理端口：\t{代理端口}
    代理地址：\t{代理}

    订阅频率：\t{订阅频率}秒
    订阅次数：\t{colorama.Fore.YELLOW + str(订阅次数) + colorama.Fore.RESET}次
    订阅时间：\t{str(datetime.datetime.now()).split(".")[0]}

    {"—"*50}
    """)


    
if __name__ == "__main__":

    #开启web子线程
    WEB = threading.Thread(target=web).start()

    #创建进程池
    po = Pool()

    #开启
    while 1:
        time.sleep(1)
        os.system("cls")
        公告()
        main()
        time.sleep(订阅频率)

    exit()