function ShuttleInfo:CanLaunch()
  return self.shuttle_obj == false
end

function UniversalStorageDepot:Init()
  self.placement_offset = {}
  self.max_storage_per_resource = 500000
  self.max_z = 5
end


function WasteRockDumpSite:GameInit()
  self.max_amount_WasteRock = 7000000
  self.demand.WasteRock:SetAmount(self.max_amount_WasteRock)
  if self.supply.Concrete then
    self.supply.Concrete:SetAmount(0)
  end
  self:SetCount(0)
end

function AirProducer:CreateLifeSupportElements()
  if self.air_production < 40000 then
	self.air_production = 40000
  end
  self.air = NewSupplyGridProducer(self)
  self.air:SetProduction(self.working and self.air_production or 0)
end

function WaterProducer:CreateLifeSupportElements()
  if self.water_production < 30000 then
	self.water_production = 30000
  end
  self.water = NewSupplyGridProducer(self)
  self.water:SetProduction(self.working and self.water_production or 0)
end


local dest_tolerance = 200
function BaseRover:RechargeFromGrid(target_cable, dont_move, forever)
  if not IsValid(target_cable) then
    return
  end
  local pnt = target_cable:GetPos()
  local target_grid = target_cable.electricity.grid
  if not dont_move then
    if not self:Goto(pnt) and (not IsValid(target_cable) or HexAxialDistance(target_cable, self) > dest_tolerance) or not IsValid(self) then
      return
    end
    if not IsValid(target_cable) then
      return
    end
  end
  if self.battery_current <= 0 then
    self.battery_thread_data.accumulate_on_stop = false
  end
  self:StopBatteryThread()
  if self:HasMember("Siege") and self.sieged_state then
    if not self.siege_destro_pushed then
      self:Siege(true)
    end
  else
    self:SetState("idle")
  end
  self.battery_cable_used_for_recharge = target_cable
  self.cable_death_notifier = PlaceObject("NotifyMeOnCableDeath", {parent_rover = self})
  target_cable:Attach(self.cable_death_notifier)
  local old_status = self.override_ui_status
  self:PushDestructor(function(self)
    self.cable_death_notifier:Dispose()
    self.cable_death_notifier = nil
    self.battery_cable_used_for_recharge = false
    if self.electricity then
      self.electricity.grid:RemoveElement(self.electricity)
      self.electricity = false
    end
    if self.battery_thread_data and self.battery_thread_data.hourly_delta > 0 then
      self:StopBatteryThread()
    end
    self.override_ui_status = old_status
  end)
  self:CreateElectricityElement()
  target_grid:AddElement(self.electricity)
  self.override_ui_status = "RechargeFromGridNoPower"
  if forever then
    Halt()
  else
    self.waiting_wakeup_recharge = true
    self:PushDestructor(function(self)
      self.waiting_wakeup_recharge = false
      self.force_exit_recharge_loop = false
    end)
    while IsValid(target_cable) and not self.force_exit_recharge_loop and self.battery_current < self.battery_max do
      WaitWakeup(const.HourDuration)
    end
    self:PopAndCallDestructor()
  end
  self:PopAndCallDestructor()
  if self.command == "RechargeFromGrid" and self:HasMember("Siege") and self.sieged_state and self.siege_destro_pushed then
    self:PopAndCallDestructor()
  end
end

local cable_query = {
  area = false,
  hexradius = dest_tolerance + 1,
  class = "ElectricityGridElement",
  filter = function(o)
    return o:GetGameFlags(const.gofUnderConstruction) == 0
  end
}

function BaseRover:GetCableNearby()
  cable_query.area = self
  local lst = GetObjects(cable_query)
  cable_query.area = false
  local c = FindNearestObject(lst, self)
  return c and HexAxialDistance(c, self) <= dest_tolerance / 2 and c or false
end

local items = {}
for i, prop in ipairs(Constructable.properties) do
	items[#items + 1] = table.copy(prop)
	if prop.id == 'dome_forbidden'
	   then
	   items[#items].template = false
	end
	if prop.id == 'dome_required'
	   then
	   items[#items].template = false
	end
	if prop.id == 'dome_required'
	   then
	   items[#items].template = false
	end
end
Constructable.properties = table.copy(items)

Service.properties[#Service.properties+1]={
      category = "Service",
      template = true,
      id = "interest5",
      name = T({
        732,
        "Service interest"
      }),
      default = "",
      editor = "combo",
      items = function()
        return ServiceInterestsList
      end
    }
Service.properties[#Service.properties+1]={
      category = "Service",
      template = true,
      id = "interest6",
      name = T({
        732,
        "Service interest"
      }),
      default = "",
      editor = "combo",
      items = function()
        return ServiceInterestsList
      end
    }
Service.properties[#Service.properties+1]={
  category = "Service",
  template = true,
  id = "interest7",
  name = T({
	732,
	"Service interest"
  }),
  default = "",
  editor = "combo",
  items = function()
	return ServiceInterestsList
  end
}
Service.properties[#Service.properties+1]={
  category = "Service",
  template = true,
  id = "interest8",
  name = T({
	732,
	"Service interest"
  }),
  default = "",
  editor = "combo",
  items = function()
	return ServiceInterestsList
  end
}
Service.properties[#Service.properties+1]={
  category = "Service",
  template = true,
  id = "interest9",
  name = T({
	732,
	"Service interest"
  }),
  default = "",
  editor = "combo",
  items = function()
	return ServiceInterestsList
  end
}
Service.properties[#Service.properties+1]={
  category = "Service",
  template = true,
  id = "interest10",
  name = T({
	732,
	"Service interest"
  }),
  default = "",
  editor = "combo",
  items = function()
	return ServiceInterestsList
  end
}
Service.properties[#Service.properties+1]={
  category = "Service",
  template = true,
  id = "interest11",
  name = T({
	732,
	"Service interest"
  }),
  default = "",
  editor = "combo",
  items = function()
	return ServiceInterestsList
  end
}
Service.properties[#Service.properties+1]={
  category = "Service",
  template = true,
  id = "interest12",
  name = T({
	732,
	"Service interest"
  }),
  default = "",
  editor = "combo",
  items = function()
	return ServiceInterestsList
  end
}
function Service:GetServiceList()
  local interests = {}
  interests[#interests + 1] = GetInterestDisplayName(self.interest1)
  interests[#interests + 1] = GetInterestDisplayName(self.interest2)
  interests[#interests + 1] = GetInterestDisplayName(self.interest3)
  interests[#interests + 1] = GetInterestDisplayName(self.interest4)
  interests[#interests + 1] = GetInterestDisplayName(self.interest5)
  interests[#interests + 1] = GetInterestDisplayName(self.interest6)
  interests[#interests + 1] = GetInterestDisplayName(self.interest7)
  interests[#interests + 1] = GetInterestDisplayName(self.interest8)
  interests[#interests + 1] = GetInterestDisplayName(self.interest9)
  interests[#interests + 1] = GetInterestDisplayName(self.interest10)
  interests[#interests + 1] = GetInterestDisplayName(self.interest11)
  interests[#interests + 1] = GetInterestDisplayName(self.interest12)
  return table.concat(interests, ", ")
end
function Service:SetCustomLabels(obj, add)
  Building.SetCustomLabels(self, obj, add)
  local label = add and obj.AddToLabel or obj.RemoveFromLabel
  label(obj, "Service", self)
  local interest1 = self.interest1
  local interest2 = self.interest2
  local interest3 = self.interest3
  local interest4 = self.interest4
  local interest5 = self.interest5
  local interest6 = self.interest6
  local interest7 = self.interest7
  local interest8 = self.interest8
  local interest9 = self.interest9
  local interest10 = self.interest10
  local interest11 = self.interest11
  local interest12 = self.interest12
  if interest1 ~= "" then
    label(obj, interest1, self)
  end
  if interest2 ~= "" and interest2 ~= interest1 then
    label(obj, interest2, self)
  end
  if interest3 ~= "" and interest3 ~= interest1 and interest3 ~= interest2 then
    label(obj, interest3, self)
  end
  if interest4 ~= "" and interest4 ~= interest1 and interest4 ~= interest2 and interest4 ~= interest3 then
    label(obj, interest4, self)
  end
  if interest5 ~= "" and interest5 ~= interest1 and interest5 ~= interest2 and interest5 ~= interest3  and interest5 ~= interest4 then
    label(obj, interest5, self)
  end
  if interest6 ~= "" and interest6 ~= interest1 and interest6 ~= interest2 and interest6 ~= interest3  and interest6 ~= interest4   and interest6 ~= interest5 then
    label(obj, interest6, self)
  end
if interest7 ~= "" and interest7 ~= interest1 and interest7 ~= interest2 and interest7 ~= interest3  and interest7 ~= interest4 and interest7 ~= interest5 and interest7 ~= interest6 then
    label(obj, interest7, self)
  end
if interest8 ~= "" and interest8 ~= interest1 and interest8 ~= interest2 and interest8 ~= interest3  and interest8 ~= interest4 and interest8 ~= interest5 and interest8 ~= interest6 and interest8 ~= interest7 then
    label(obj, interest8, self)
  end
if interest9 ~= "" and interest9 ~= interest1 and interest9 ~= interest2 and interest9 ~= interest3  and interest9 ~= interest4 and interest9 ~= interest5 and interest9 ~= interest6 and interest9 ~= interest7 and interest9 ~= interest8 then
    label(obj, interest9, self)
  end
 if interest10 ~= "" and interest10 ~= interest1 and interest10 ~= interest2 and interest10 ~= interest3  and interest10 ~= interest4 and interest10 ~= interest5 and interest10 ~= interest6 and interest10 ~= interest7 and interest10 ~= interest8 and interest10 ~= interest9 then
    label(obj, interest10, self)
  end
  if interest11 ~= "" and interest11 ~= interest1 and interest11 ~= interest2 and interest11 ~= interest3  and interest11 ~= interest4 and interest11 ~= interest5 and interest11 ~= interest6 and interest11 ~= interest7 and interest11 ~= interest8 and interest11 ~= interest9 and interest11 ~= interest10  then
    label(obj, interest11, self)
  end
  if interest12 ~= "" and interest12 ~= interest1 and interest12 ~= interest2 and interest12 ~= interest3  and interest12 ~= interest4 and interest12 ~= interest5 and interest12 ~= interest6 and interest12 ~= interest7 and interest12 ~= interest8 and interest12 ~= interest9 and interest12 ~= interest10 and interest12 ~= interest11  then
    label(obj, interest12, self)
  end
end
function Service:IsOneOfInterests(interest)
  return self.interest1 == interest or self.interest2 == interest or self.interest3 == interest or self.interest4 == interest or self.interest5 == interest or self.interest6 == interest or self.interest7 == interest or self.interest8 == interest or self.interest9 == interest or self.interest10 == interest or self.interest11 == interest or self.interest12 == interest
end



function MyFixBuilds()
	TunnelConstructionController.max_range=1000
	local templates = DataInstances.BuildingTemplate
	  for i = 1, #templates do
	    local name = templates[i].name
	    if name == "Diner" then
			DataInstances.BuildingTemplate[i].hide_from_build_menu = true
	    elseif name == "Arcology" then
			DataInstances.BuildingTemplate[i].hide_from_build_menu = true
		elseif name == "SmartHome" then
			DataInstances.BuildingTemplate[i].hide_from_build_menu = true
		elseif name == "SmartHome" then
			DataInstances.BuildingTemplate[i].hide_from_build_menu = true
		end
		-- 奇观不限制数量
		DataInstances.BuildingTemplate[i].wonder  =  false
		
	  end
end

function OnMsg.NewMap()
        MyFixBuilds()
end

function OnMsg.LoadGame()
        MyFixBuilds()
end
