local assets=
{
	Asset("ANIM", "anim/horn_rhino.zip"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    inst.AnimState:SetBank("horn_rhino")
    inst.AnimState:SetBuild("horn_rhino")
    inst.AnimState:PlayAnimation("idle")
    MakeInventoryPhysics(inst)
    
    inst:AddComponent("inspectable")
local function getson (inst)
    TheFrontEnd:Fade(false,1)
  GetPlayer():DoTaskInTime(1.5, function()
    TheFrontEnd:Fade(true,1)
    local pt = GetPlayer():GetPosition()
    local son = SpawnPrefab("resurrectionstatue")
    son.Transform:SetPosition(pt.x, pt.y, pt.z)
    son.AnimState:SetBank("wilson")
    if GetPlayer().prefab == "wilson" then son.AnimState:SetBuild("wilson") end
    if GetPlayer().prefab == "wendy" then son.AnimState:SetBuild("wendy") end
    if GetPlayer().prefab == "wes" then son.AnimState:SetBuild("wes") end
    if GetPlayer().prefab == "wickerbottom" then son.AnimState:SetBuild("wickerbottom") end
    if GetPlayer().prefab == "willow" then son.AnimState:SetBuild("willow") end
    if GetPlayer().prefab == "wolfgang" then son.AnimState:SetBuild("wolfgang_skinny") end
    if GetPlayer().prefab == "wx78" then son.AnimState:SetBuild("wx78") end
    if GetPlayer().prefab == "woodie" then son.AnimState:SetBuild("woodie") end
    if GetPlayer().prefab == "waxwell" then son.AnimState:SetBuild("waxwell") end
    local hats = {"hat_beefalo","hat_feather","hat_flower","hat_top","hat_walrus","hat_winter"}
    local hat = hats[math.random(#hats)]
    son.AnimState:OverrideSymbol("swap_hat", hat, "swap_hat")
    local armors = {"armor_sanity","armor_slurper","armor_sweatervest","armor_trunkvest_summer","armor_trunkvest_winter"}
    local armor = armors[math.random(#armors)]
    son.AnimState:OverrideSymbol("swap_body", armor, "swap_body")
    son.AnimState:Show("HAT")
    son.AnimState:Show("HAT_HAIR")
    son.AnimState:Hide("HAIR_NOHAT")
    son.AnimState:Hide("HAIR")
    son.AnimState:Hide("ARM_carry")
    son.AnimState:Show("ARM_normal")
    son.AnimState:PlayAnimation("idle")
    son.AnimState:Hide("snow")
    son.Transform:SetFourFaced()
    son.Transform:SetScale(0.8,0.8,0.8)
    son:AddComponent("combat")
    son.components.combat.hiteffectsymbol = "torso"
    son.components.combat:SetRetargetFunction(3, function(son)
        if not son.components.health:IsDead() then
            return FindEntity(son, 20, function(guy)
                if guy.components.health and not guy.components.health:IsDead() then
                   return guy.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == guy
                end
            end)
        end
    end )
    son.components.combat:SetKeepTargetFunction(function(son, target) return target and target:IsValid() end )
    son.components.combat:SetAttackPeriod(1)
    son.components.combat:SetRange(2, 3)
    son.components.combat:SetDefaultDamage(10)
    son:AddComponent("health")
    son.components.health:SetMaxHealth(1000)
    son.components.health.nofadeout = true
    son:AddComponent("inventory")
    son.components.inventory.dropondeath = false
    son:AddComponent("locomotor")
    son.components.locomotor.pathcaps = { ignorecreep = true }
    son.components.locomotor.runspeed = 12
    local brain = require"brains/shadowwaxwellbrain"
    son:SetBrain(brain)
    son:SetStateGraph("SGshadowwaxwell")
    son:RemoveComponent("lootdropper")
    son:RemoveComponent("workable")
    MakeCharacterPhysics(son, 75, .5)
    son:RemoveTag("structure")
    son:AddComponent("follower")
    son.components.follower.leader = GetPlayer()
    son:AddComponent("trader")
    son.components.trader:SetAcceptTest(function(son, item) 
        if GetPlayer().components.inventory:Has("goldnugget", 5) then
           if item.prefab == "goldnugget" and son.components.health and not son.components.health:IsDead() then
              return son.components.health:GetPercent() < .99
           end
        end
        return false
    end )
    son.components.trader.onaccept = function(son, giver, item)
        GetPlayer().components.inventory:ConsumeByName("goldnugget", 4)
        son.components.health:DoDelta(1000)
    end
    son:AddComponent("machine")
    son.components.machine.turnonfn = function() son.components.locomotor:Stop() son.brain:Stop() end
    son.components.machine.turnofffn = function() son.brain:Start() end
    son:ListenForEvent("death", function()
        GetPlayer().components.sanity:DoDelta(-100)
        SpawnPrefab("trinket_1").Transform:SetPosition(son.Transform:GetWorldPosition())
    end )
    son:AddTag("companion")
    son:AddTag("sons")
    inst:Remove()
  end )
end
local function OnDeploy (inst, pt)
  if GetPlayer().components.inventory:Has("goldnugget", 100) then
    GetPlayer().components.inventory:ConsumeByName("goldnugget", 100)
    local egg1 = SpawnPrefab("minotaurhorn")
    egg1.AnimState:SetBuild("tallbird_egg")
    egg1.AnimState:SetBank("egg")
    egg1.AnimState:PlayAnimation("egg")
    egg1.Transform:SetPosition(pt.x+2+3, pt.y, pt.z+2-3)
    egg1.AnimState:SetMultColour(0/255,255/255,0/255,1)
    egg1.Transform:SetScale(1.5,1.5,1.5)
    egg1:AddComponent("health")
    egg1.components.health:SetMaxHealth(1)
    egg1:AddComponent("combat")
    egg1:RemoveComponent("edible")
    egg1.components.inventoryitem.canbepickedup = false
    local egg2 = SpawnPrefab("minotaurhorn")
    egg2.AnimState:SetBuild("tallbird_egg")
    egg2.AnimState:SetBank("egg")
    egg2.AnimState:PlayAnimation("egg")
    egg2.Transform:SetPosition(pt.x+2-3, pt.y, pt.z+2+3)
    egg2.AnimState:SetMultColour(0/255,255/255,0/255,1)
    egg2.Transform:SetScale(1.5,1.5,1.5)
    egg2:AddComponent("health")
    egg2.components.health:SetMaxHealth(1)
    egg2:AddComponent("combat")
    egg2:RemoveComponent("edible")
    egg2.components.inventoryitem.canbepickedup = false
    egg1:ListenForEvent("death", function() egg1.AnimState:PlayAnimation("crack") egg2:Remove()
        if math.random()<.5 then
           local pt = GetPlayer():GetPosition()
           GetSeasonManager():DoLightningStrike(pt)
           inst:DoTaskInTime(1, function() getson(inst) end )
        else
           SpawnPrefab("collapse_small").Transform:SetPosition(egg1.Transform:GetWorldPosition())
           GetPlayer().SoundEmitter:PlaySound("dontstarve/creatures/eyeballturret/shotexplo")
        end
    end )
    egg2:ListenForEvent("death", function() egg2.AnimState:PlayAnimation("crack") egg1:Remove()
        if math.random()<.5 then
           local pt = GetPlayer():GetPosition()
           GetSeasonManager():DoLightningStrike(pt)
           inst:DoTaskInTime(2, function() getson(inst) end )
        else
           SpawnPrefab("collapse_small").Transform:SetPosition(egg2.Transform:GetWorldPosition())
           GetPlayer().SoundEmitter:PlaySound("dontstarve/creatures/eyeballturret/shotexplo")
        end
    end )
  end
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
    
    inst:AddComponent("inventoryitem")
    
    inst:AddComponent("edible")
    inst.components.edible.foodtype = "MEAT"
    inst.components.edible.healthvalue = TUNING.HEALING_HUGE
    inst.components.edible.hungervalue = TUNING.CALORIES_HUGE
    inst.components.edible.sanityvalue = -TUNING.SANITY_MED

    return inst
end

return Prefab( "common/inventory/minotaurhorn", fn, assets) 
