require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/wilsonstatue.zip"),
}


local function onhammered(inst, worker)
	if inst.components.lootdropper and not inst.components.resurrector.used then
		inst.components.lootdropper:DropLoot()
	end
	SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst.components.resurrector.penalty = 0
	inst:Remove()

	-- Remove from save index
	SaveGameIndex:DeregisterResurrector(inst)

	
	if not inst.components.resurrector.used then
		local player = GetPlayer()
		if player then
			player.components.health:RecalculatePenalty()
		end
	end
	
end

local function makeused(inst)
	inst.AnimState:PlayAnimation("debris")
	inst.components.resurrector.penalty = 0	
end

local function onhit(inst, worker)
	if not inst.components.resurrector.used then
		inst.AnimState:PlayAnimation("hit")
		inst.AnimState:PushAnimation("idle")
	end
end

local function doresurrect(inst, dude)
	inst:AddTag("busy")	
	inst.persists = false
    inst:RemoveComponent("lootdropper")
    inst:RemoveComponent("workable")
    inst:RemoveComponent("inspectable")
	inst.MiniMapEntity:SetEnabled(false)
    if inst.Physics then
		RemovePhysicsColliders(inst)
    end

	GetClock():MakeNextDay()
    dude.Transform:SetPosition(inst.Transform:GetWorldPosition())
    dude:Hide()
    dude:ClearBufferedAction()

    if dude.HUD then
        dude.HUD:Hide()
    end
    if dude.components.playercontroller then
        dude.components.playercontroller:Enable(false)
    end

    TheCamera:SetDistance(12)
	dude.components.hunger:Pause()
	
    scheduler:ExecuteInTime(3, function()
        dude:Show()

        inst:Hide()
        inst.AnimState:PlayAnimation("debris")
		inst.components.resurrector.penalty = 0                
		
        dude.sg:GoToState("rebirth")
        
        --SaveGameIndex:SaveCurrent()
        dude:DoTaskInTime(3, function() 
            if dude.HUD then
                dude.HUD:Show()
            end
            if dude.components.hunger then
                dude.components.hunger:SetPercent(2/3)
            end
			
            if dude.components.health then
				dude.components.health:RecalculatePenalty()
                dude.components.health:Respawn(TUNING.RESURRECT_HEALTH)
                dude.components.health:SetInvincible(true)
            end
            
            if dude.components.sanity then
			    dude.components.sanity:SetPercent(.5)
            end
            if dude.components.playercontroller then
                dude.components.playercontroller:Enable(true)
            end
            
            dude.components.hunger:Resume()
            
            TheCamera:SetDefault()
            inst:RemoveTag("busy")
        end)
        inst:DoTaskInTime(4, function() 
            dude.components.health:SetInvincible(false)
			inst:Show()
        end)
		inst:DoTaskInTime(7, function()
		    local tick_time = TheSim:GetTickTime()
		    local time_to_erode = 4
		    inst:StartThread( function()
			    local ticks = 0
			    while ticks * tick_time < time_to_erode do
				    local erode_amount = ticks * tick_time / time_to_erode
				    inst.AnimState:SetErosionParams( erode_amount, 0.1, 1.0 )
				    ticks = ticks + 1
				    Yield()
			    end
			    inst:Remove()
		    end)
		end)
        
    end)

end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("idle", false)
end

local function fn(Sim)
	local inst = CreateEntity()
	
    inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddMiniMapEntity()
	inst.entity:AddSoundEmitter()
    
    MakeObstaclePhysics(inst, .3)

	inst.MiniMapEntity:SetIcon( "resurrect.png" )
    inst:AddTag("structure")
    
    inst.AnimState:SetBank("wilsonstatue")
    inst.AnimState:SetBuild("wilsonstatue")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddComponent("inspectable")
local items = { AXE = "swap_axe", PICK = "swap_pickaxe", SWORD = "swap_spear" }
local function EquipItem(inst, item)
    if item then
       inst.AnimState:OverrideSymbol("swap_object", item, item)
       inst.AnimState:Show("ARM_carry") 
       inst.AnimState:Hide("ARM_normal")
    end
end
    inst.items = items
    inst.equipfn = EquipItem
    EquipItem(inst)
local function onsave(inst, data)
    if inst:HasTag("sons") then
        data.sons = true
    end
end
local function onload(inst, data)
  if data and data.sons then
    inst.AnimState:SetBank("wilson")
    if GetPlayer().prefab == "wilson" then inst.AnimState:SetBuild("wilson") end
    if GetPlayer().prefab == "wendy" then inst.AnimState:SetBuild("wendy") end
    if GetPlayer().prefab == "wes" then inst.AnimState:SetBuild("wes") end
    if GetPlayer().prefab == "wickerbottom" then inst.AnimState:SetBuild("wickerbottom") end
    if GetPlayer().prefab == "willow" then inst.AnimState:SetBuild("willow") end
    if GetPlayer().prefab == "wolfgang" then inst.AnimState:SetBuild("wolfgang_skinny") end
    if GetPlayer().prefab == "wx78" then inst.AnimState:SetBuild("wx78") end
    if GetPlayer().prefab == "woodie" then inst.AnimState:SetBuild("woodie") end
    if GetPlayer().prefab == "waxwell" then inst.AnimState:SetBuild("waxwell") end
    local hats = {"hat_beefalo","hat_feather","hat_flower","hat_top","hat_walrus","hat_winter"}
    local hat = hats[math.random(#hats)]
    inst.AnimState:OverrideSymbol("swap_hat", hat, "swap_hat")
    local armors = {"armor_sanity","armor_slurper","armor_sweatervest","armor_trunkvest_summer","armor_trunkvest_winter"}
    local armor = armors[math.random(#armors)]
    inst.AnimState:OverrideSymbol("swap_body", armor, "swap_body")
    inst.AnimState:Show("HAT")
    inst.AnimState:Show("HAT_HAIR")
    inst.AnimState:Hide("HAIR_NOHAT")
    inst.AnimState:Hide("HAIR")
    inst.AnimState:Hide("ARM_carry")
    inst.AnimState:Show("ARM_normal")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("snow")
    inst.Transform:SetFourFaced()
    inst.Transform:SetScale(0.8,0.8,0.8)
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "torso"
    inst.components.combat:SetRetargetFunction(3, function(inst)
        if not inst.components.health:IsDead() then
            return FindEntity(inst, 20, function(guy)
                if guy.components.health and not guy.components.health:IsDead() then
                   return guy.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == guy
                end
            end)
        end
    end )
    inst.components.combat:SetKeepTargetFunction(function(inst, target) return target and target:IsValid() end )
    inst.components.combat:SetAttackPeriod(1)
    inst.components.combat:SetRange(2, 3)
    inst.components.combat:SetDefaultDamage(10)
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(1000)
    inst.components.health.nofadeout = true
    inst:AddComponent("inventory")
    inst.components.inventory.dropondeath = false
    inst:AddComponent("locomotor")
    inst.components.locomotor.pathcaps = { ignorecreep = true }
    inst.components.locomotor.runspeed = 12
    local brain = require"brains/shadowwaxwellbrain"
    inst:SetBrain(brain)
    inst:SetStateGraph("SGshadowwaxwell")
    inst:RemoveComponent("lootdropper")
    inst:RemoveComponent("workable")
    MakeCharacterPhysics(inst, 75, .5)
    inst:RemoveTag("structure")
    inst:AddComponent("follower")
    inst.components.follower.leader = GetPlayer()
    inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(function(inst, item) 
        if GetPlayer().components.inventory:Has("goldnugget", 5) then
           if item.prefab == "goldnugget" and inst.components.health and not inst.components.health:IsDead() then
              return inst.components.health:GetPercent() < .99
           end
        end
        return false
    end )
    inst.components.trader.onaccept = function(inst, giver, item)
        GetPlayer().components.inventory:ConsumeByName("goldnugget", 4)
        inst.components.health:DoDelta(1000)
    end
    inst:AddComponent("machine")
    inst.components.machine.turnonfn = function() inst.components.locomotor:Stop() inst.brain:Stop() end
    inst.components.machine.turnofffn = function() inst.brain:Start() end
    inst:ListenForEvent("death", function()
        GetPlayer().components.sanity:DoDelta(-100)
        SpawnPrefab("trinket_1").Transform:SetPosition(inst.Transform:GetWorldPosition())
    end )
    inst:AddTag("companion")
    inst:AddTag("sons")
  end
end
    inst.OnSave = onsave
    inst.OnLoad = onload
    inst:AddComponent("resurrector")
    inst.components.resurrector.active = true
	inst.components.resurrector.doresurrect = doresurrect
	inst.components.resurrector.makeusedfn = makeused
	inst.components.resurrector.penalty = 1
	
    inst:AddComponent("lootdropper")
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(4)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit)
	MakeSnowCovered(inst, .01)    
	inst:ListenForEvent( "onbuilt", onbuilt)
	
    return inst
end




return Prefab( "common/objects/resurrectionstatue", fn, assets),
		MakePlacer( "common/resurrectionstatue_placer", "wilsonstatue", "wilsonstatue", "idle" ) 
