
local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "zgsabber_sword2_swap", "zgsabber_sword2_swap")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
	--inst.Transform:SetScale(1.25,1.25,1.25)
	
    inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("zgsabber_sword2")
    inst.AnimState:SetBuild("zgsabber_sword2")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/zgsabber_sword2.xml"
	inst.components.inventoryitem.imagename = "zgsabber_sword2"

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(60)
	
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(300)
    inst.components.finiteuses:SetUses(300)
    inst.components.finiteuses:SetOnFinished(inst.Remove)
	
    inst:AddComponent("inspectable")
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    return inst
end

return Prefab("zgsabber_sword2", fn)