local allergengroups = {
	{"carrot"},
	{"batwing"},
	{"acorn_cooked","trailmix"},
	{"butterflywings","butter","butterflymuffin","waffles","freshfruitcrepes"},
	{"cactus_meat","cactus_flower","flowersalad"},
	{"banana"},
	{"corn","powcake"},
	{"deerclops_eyeball"},
	{"dragonfruit","dragonpie"},
	{"drumstick","turkeydinner"},
	{"durian"},
	{"eel","unagi"},
	{"goatmilk","butter","icecream","waffles","freshfruitcrepes"},
	{"bird_egg","tallbirdegg","tallbirdegg_cracked","perogies","baconeggs","rottenegg"},
	{"eggplant","stuffedeggplant"},
	{"fish","fishtacos","fishsticks"},
	{"foliage"},
	{"froglegs","frogglebunwich"},
	{"glommerfuel"},
	{"wormlight"}, --comes from worm
	{"wormlight_lesser"}, --comes from plant. so, separate groups
	{"minotaurhorn"},
	{"trunk_summer","trunk_winter","trunk_cooked"},
	{"plantmeat"},
	{"lichen","unagi"},
	{"lightbulb"},
	{"mandrake","mandrakesoup"},
	{"red_cap","blue_cap","green_cap"},
	{"petals","petals_evil"},
	{"pomegranate"},
	{"pumpkin","pumpkincookie"},
	{"spoiled_food","rottenegg"},
	{"royal_jelly","jellybeans"},
	{"watermelon","watermelonicle"},
	{"hotchili"},
	{"wetgoop"}
}

allergenquantity = GetModConfigData("allergenquantity")
severity = GetModConfigData("severity")
local function generateallergens()
	print("generating allergens:")
	print(allergenquantity)
	allergens = {}
	for i = 1, allergenquantity do
		for k, v in ipairs(allergengroups[math.random(#allergengroups)]) do
			table.insert(allergens, v)
		end
	end
	return allergens
end

AddPlayerPostInit(function(inst)
	inst:AddComponent("allergic")
	if #inst.components.allergic.allergens == 0 then
		inst.components.allergic.allergens = generateallergens()
	end
	inst.components.allergic.severity = severity
end)



