local function foodcheck(inst, food)
	local severity = inst.components.allergic.severity
	for k,v in ipairs(inst.components.allergic.allergens) do
		if food.prefab == v or food.prefab == v.."_cooked" or food.prefab == v.."_seeds" then
			if severity == 1 then
				inst.components.health:DoDelta(-TUNING.HEALING_MED, false, food.prefab) -- -20 hp
			end
			if severity == 2 then
				inst.components.health:DoDelta(-TUNING.HEALING_SUPERHUGE, false, food.prefab) -- -100 hp
				inst.components.hunger:DoDelta(-TUNING.CALORIES_HUGE)
			end
			if severity == 3 then
				inst.components.health:DoDelta(-TUNING.HEALING_SUPERHUGE*256, false, food.prefab) --death
			end
			if inst.components.talker and not inst.components.health:IsDead() then
				inst.components.talker:Say(GetString(inst, "ANNOUNCE_EAT", "PAINFUL"))
			end
		end
	end
end

local Allergic = Class(function(self, inst)
	print("class")
    self.inst = inst
    self.allergens = {}
	self.severity = 0
	inst.components.eater:SetOnEatFn(foodcheck)
end)


function Allergic:OnSave()
    return self.allergens
end

function Allergic:OnLoad(data)
	print("load")
	if data then
		self.allergens = data
	end
end

return Allergic