local assets=
{
	Asset("ANIM", "anim/hat_gummy.zip"),
  Asset("ATLAS", "images/inventoryimages/hat_gummy.xml")
}

local function onequip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "hat_gummy", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
end

local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
end

	
local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst:AddTag("hat")
    
    anim:SetBank("winterhat")
    anim:SetBuild("hat_gummy")
    anim:PlayAnimation("anim")    
        
    inst:AddComponent("inspectable")
    
    inst:AddTag("irreplaceable")
	
    inst:AddComponent("insulator")
	inst.components.insulator.insulation = TUNING.INSULATION_SMALL	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_gummy.xml"

    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMOR_FOOTBALLHAT, TUNING.ARMOR_FOOTBALLHAT_ABSORPTION * 0.3)
    inst.components.armor:InitCondition(TUNING.ARMOR_BEEHAT, TUNING.ARMOR_BEEHAT_ABSORPTION * 0.3)
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end

return Prefab( "common/inventory/hat_gummy", fn, assets ) 