
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/pinkiepie.zip" ),
	Asset( "ANIM", "anim/pinkamena.zip" ),

}
local prefabs = {}


local start_inv = 
{
        "carrot",
        "carrot",
        "carrot",
        "carrot",
        "carrot",
        "cookedmeat",
        "cookedmeat",
        "cookedmeat",
        "cookedmeat",
        "cookedmeat",
        "spear",
        "hat_gummy",

}

local pinkiepieAuraMaxRange = 7

local auraRange = 3

local function switchAuraDisplay(inst)
    if GetClock():IsNight() then
		inst.Light:Enable(false)
	else
		inst.Light:Enable(true)
    end
end


local function updatestats(inst)

    if GetClock():IsDay() then
		if inst.strength == "pinky" then	
			inst.components.health.maxhealth = (200)
			inst.components.health:StartRegen(1, 30)
			inst.components.combat.damagemultiplier = 0.7
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.7 )
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2)
			inst.components.combat.attackrange = 4
			inst.components.combat.hitrange = 4
			TUNING.SANITY_DAY_GAIN = 180/60
			inst.components.eater.foodprefs = { "VEGGIE", "SEEDS", "GENERIC" } 
			inst.AnimState:SetBuild("pinkiepie")
		elseif inst.strength == "pinky_mana" then
			inst.components.health.maxhealth = (150)
			inst.components.health:StartRegen(-1, 2)
			inst.components.combat.damagemultiplier = 6
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 40 )
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 0.3)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 0.3)
			inst.components.combat.attackrange = 8
			inst.components.combat.hitrange = 8
			TUNING.SANITY_DAY_GAIN = -999999/60
			inst.components.eater:SetCarnivore()
			inst.Light:Enable(true) 
			inst.AnimState:SetBuild("pinkamena")

		end
		
 	elseif GetClock():IsDusk() then
		if inst.strength == "pinky" then
			inst.components.health.maxhealth = (200)
			inst.components.health:StartRegen(-1, 30)
			inst.components.combat.damagemultiplier = 0.6
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.7 )
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2)
			inst.components.combat.attackrange = 4
			inst.components.combat.hitrange = 4
			TUNING.SANITY_NIGHT_LIGHT = 180/60
			TUNING.SANITY_NIGHT_MID = 180/60
			inst.components.eater.foodprefs = { "VEGGIE", "SEEDS", "GENERIC" }
			inst.AnimState:SetBuild("pinkiepie")
		elseif inst.strength == "pinky_mana" then
			inst.components.health.maxhealth = (150)
			inst.components.health:StartRegen(-1, 2)
			inst.components.combat.damagemultiplier = 6
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 40 )
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 0.3)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 0.3)
			inst.components.combat.attackrange = 8
			inst.components.combat.hitrange = 8
			TUNING.SANITY_NIGHT_LIGHT = -999999/60
			TUNING.SANITY_NIGHT_MID = -999999/60
			inst.components.eater:SetCarnivore()
			inst.Light:Enable(true)
			inst.AnimState:SetBuild("pinkamena")	

		end

    elseif GetClock():IsNight() then	
		if inst.strength == "pinky" then
			inst.components.health.maxhealth = (200)
			inst.components.health:StartRegen(-1, 30)
			inst.components.combat.damagemultiplier = 0.5
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.7 )
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2)
			inst.components.combat.attackrange = 4
			inst.components.combat.hitrange = 4
			TUNING.SANITY_NIGHT_LIGHT = 180/60
			TUNING.SANITY_NIGHT_DARK = -180/60
			inst.components.eater.foodprefs = { "VEGGIE", "SEEDS", "GENERIC" }
			inst.AnimState:SetBuild("pinkiepie")
			inst.Light:Enable(false)
		elseif inst.strength == "pinky_mana" then
			inst.components.health.maxhealth = (150)
			inst.components.health:StartRegen(-1, 2)
			inst.components.combat.damagemultiplier = 6
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 40 )
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 0.3)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 0.3)
			inst.components.combat.attackrange = 8
			inst.components.combat.hitrange = 8
			TUNING.SANITY_NIGHT_LIGHT = -999999/60
			TUNING.SANITY_NIGHT_DARK = -999999/60
			inst.components.eater:SetCarnivore()
			inst.Light:Enable(true)
			inst.AnimState:SetBuild("pinkamena")	
		end
		
	end

end



local function pinkychange(inst, data)

	if inst.strength == "pinky" then
		if inst.components.sanity.current <= 40 then
			inst.strength = "pinky_mana"
			inst.components.talker:Say("POOR .. POOR ME ...")	
		end

	elseif inst.strength == "pinky_mana" then
		if inst.components.hunger.current <= 1 then
			inst.strength = "pinky"
			inst.components.talker:Say("I want Suger Cake !!!")
		end
	else
		if inst.components.sanity.current > 50 then
			inst.strength = "pinky"
			inst.components.talker:Say("SMILE !!")

	elseif inst.components.sanity.current <= 45 then
			inst.strength = "pinky_mana"
			inst.components.talker:Say("Oh No....")	

		end
	end
	
	
	updatestats(inst)
end


--aura target
local function validateTarget(target)
	if (target:HasTag("shadowcreature") or target:HasTag("chess") or target:HasTag("ghost") or target:HasTag("wall") or target:HasTag("structure") or target.prefab == "chester") then
		return false
	-- If a rabbit is affected, turn him bearded at mid-life --
	elseif (target:HasTag("rabbit") and target.components.health.currenthealth <= TUNING.RABBIT_HEALTH / 2) then
		if target.checktask then target.checktask:Cancel() end
		BecomeBeardling(target)
	elseif (target:HasTag("manrabbit") and target.components.health.currenthealth <= TUNING.BUNNYMAN_HEALTH / 2) then
		if target.checktask then target.checktask:Cancel() end
		SetBeardlord(target)
	end
	
	return true
end


--aura
local function updateAura(inst, dt)
	if inst.strength == "pinky_mana" then
        auraRange = 7
	inst.Light:SetRadius(auraRange)
	local hits = inst.components.combat:DoAreaAttack(inst, auraRange, inst, validateTarget)
end
	
end


--Stormcaller
local function stormcaller(inst)
	if inst.components.sanity.current <= 30 and not GetSeasonManager():IsRaining() then
		GetSeasonManager():StartPrecip()
		if inst.components.sanity.current <=20 then
			TUNING.FROG_RAIN_MOISTURE = 3
			TUNING.FROG_RAIN_PRECIPITATION = 0.01
		end
	end
	if inst.components.sanity.current >= 75 and GetSeasonManager():IsRaining() and inst.rainstartedatsanity <= 50 then
		GetSeasonManager():StopPrecip()
	end
	if not GetSeasonManager():IsRaining() then
		TUNING.FROG_RAIN_PRECIPITATION = 999
		TUNING.FROG_RAIN_MOISTURE = 999999
	end
end



local fn = function(inst)
	inst.soundsname = "wendy"
	inst.MiniMapEntity:SetIcon( "wendy.png" )
	inst.components.hunger:SetMax(300)
	inst.components.sanity:SetMax(100)
	inst.components.eater.strongstomach = true
	TUNING.EVERGREEN_CHOPS_NORMAL=15
	TUNING.EVERGREEN_CHOPS_TALL=20
	TUNING.ROCKS_MINE=9
	TUNING.SANITY_TINY = -25

	--Stormcaller check
	inst.rainstartedatsanity = 10
	
	inst:ListenForEvent("rainstart", function()
		inst.rainstartedatsanity = inst.components.sanity.current
	end, GetWorld())
	inst:DoPeriodicTask(1/10, function() stormcaller(inst) end)


	-- Stats varies day/night
	inst:ListenForEvent( "dusktime", function() updatestats(inst) end , GetWorld())
        inst:ListenForEvent( "daytime", function() updatestats(inst) end , GetWorld())
        inst:ListenForEvent( "nighttime", function() updatestats(inst) end , GetWorld())
         updatestats(inst)
	
	--Update hunger status
	inst:ListenForEvent("hungerdelta", pinkychange)

		-- Damaging aura --
			inst:AddComponent("weapon")
			inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE * 0.3)
			inst.entity:AddLight()
			inst.Light:SetRadius(pinkiepieAuraMaxRange)
	     	        inst.Light:SetFalloff(0.99)
   		        inst.Light:SetIntensity(0.99)
			inst.Light:SetColour(5/255,255/255,5/255)
			inst.Light:Enable(true)
			inst:ListenForEvent("daytime", function() switchAuraDisplay(inst) end , GetWorld())
			inst:ListenForEvent("nighttime", function() switchAuraDisplay(inst) end , GetWorld())
			inst.updateTask = inst:DoPeriodicTask(1, updateAura, nil, 1)	

    return inst
	
end


STRINGS.CHARACTER_TITLES.pinkiepie = "Pinkiepie ( Equestria Girls )"
STRINGS.CHARACTER_NAMES.pinkiepie = "Pinkiepie"
STRINGS.CHARACTER_DESCRIPTIONS.pinkiepie = "Science tab Bonus ,Regen Health ..but hate Dark & Low Sanity & don't eat meat & other"
STRINGS.CHARACTER_QUOTES.pinkiepie = "Friendship is Magic !"


return MakePlayerCharacter("pinkiepie", prefabs, assets, fn , start_inv)