local assets=
{ 
    Asset("ANIM", "anim/witchhat.zip"),
    Asset("ANIM", "anim/witchhat_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/witchhat.xml"),
    Asset("IMAGE", "images/inventoryimages/witchhat.tex"),
}

local prefabs = 
{
}

    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_hat", "witchhat", "swap_hat")
		
		if inst.components.fueled then
			inst.components.fueled:StartConsuming()
		end
		
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
		
		if owner:HasTag("player") then
			owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAT")
		end
    end
 
    local function OnUnequip(inst, owner)
	
		if inst.components.fueled then
			inst.components.fueled:StopConsuming()
		end
	
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
		
		if owner:HasTag("player") then
	        owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAT")
		end
    end
 
 local function fn(Sim) 
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	
    MakeInventoryPhysics(inst)
 
    inst:AddTag("hat")
	
	    if not TheWorld.ismastersim then
        return inst
    end
	
	inst.entity:SetPristine()
	
    inst.AnimState:SetBank("witchhat")
    inst.AnimState:SetBuild("witchhat")
    inst.AnimState:PlayAnimation("idle")
	
	MakeHauntableLaunch(inst)
 
    inst:AddComponent("inspectable")
     
	inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_LARGE) 
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "witchhat"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/witchhat.xml"
	 
    inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_TINY * 2.45
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst:AddComponent("fueled")
    inst.components.fueled.fueltype = FUELTYPE.USAGE
    inst.components.fueled:InitializeFuelLevel(TUNING.TOPHAT_PERISHTIME * 3)
    inst.components.fueled:SetDepletedFn(inst.Remove)
	
	inst:AddComponent("insulator")
    inst.components.insulator:SetWinter()
    inst.components.insulator:SetInsulation(TUNING.INSULATION_TINY)
	
	inst:AddComponent("heater")
    inst.components.heater:SetThermics(false, true)
    inst.components.heater.equippedheat = TUNING.MINIFAN_COOLER
	
 
    return inst
end

return  Prefab("common/inventory/witchhat", fn, assets, prefabs)