PrefabFiles = {
	"elphelt",
	"elphelt_none",
	"elpheltbazooka",
	"elpheltrifle",
	"elpheltshotgun",
	"elpheltpistol",
	"elpheltbomb",
	"elpheltbouquet",
	"elpheltmissile",
	"elpheltcrosshair",
	-- "elphelt_spin_fx",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/elphelt.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/elphelt.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/elphelt.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/elphelt.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/elphelt_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/elphelt_silho.xml" ),

    Asset( "IMAGE", "bigportraits/elphelt.tex" ),
    Asset( "ATLAS", "bigportraits/elphelt.xml" ),
	
	Asset( "IMAGE", "images/map_icons/elphelt.tex" ),
	Asset( "ATLAS", "images/map_icons/elphelt.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_elphelt.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_elphelt.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_elphelt.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_elphelt.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_elphelt.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_elphelt.xml" ),
	
	Asset( "IMAGE", "images/names_elphelt.tex" ),
    Asset( "ATLAS", "images/names_elphelt.xml" ),
	
    Asset( "IMAGE", "bigportraits/elphelt_none.tex" ),
    Asset( "ATLAS", "bigportraits/elphelt_none.xml" ),
	
	Asset( "ATLAS", "images/hud/elphelttab.xml" ),
	Asset( "IMAGE", "images/hud/elphelttab.tex" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local resolvefilepath = GLOBAL.resolvefilepath

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local TECH = GLOBAL.TECH


local function RecheckForThreat(inst)
    local busy = inst.sg:HasStateTag("sleeping") or inst.sg:HasStateTag("busy") or inst.sg:HasStateTag("flying")
    if not busy then
        local threat = GLOBAL.FindEntity(inst, 5, nil, nil, {'notarget', 'birdwhisperer'}, {'player', 'monster', 'scarytoprey'})
        return threat ~= nil or GLOBAL.TheWorld.state.isnight
    end
end
 
AddStategraphPostInit("bird", function(sg)
	local old = sg.events.flyaway.fn
	sg.events.flyaway.fn = function(inst)
		if RecheckForThreat(inst) then
			old(inst)
		end
	end
end)

local innocents = {
    rabbit = true,
    crow = true,
    robin = true,
    robin_winter = true,
}
 
AddPrefabPostInit("elphelt", function(inst)
    if inst.components.combat == nil then
        return
    end
    inst.components.combat.onhitotherfn = function(attacker, target, damage)
        if innocents[target.prefab] and attacker.components.sanity then
            if target.components.health and target.components.health:IsDead() then
                attacker.components.sanity:DoDelta(-8)
            end
        end
    end
end)

local untouchables = {
    crow = true,
    robin = true,
    robin_winter = true,
	babybeefalo = true, 
	penguin = true, 
	smallbird = true,
	catcoon = true,
	chester = true
}

AddComponentPostInit("playeractionpicker", function(self)
    local old = self.SortActionList
    function self:SortActionList(actions, target, useitem)
        if #actions == 0 then
            return actions
        end
        local c = 0
        for k, v in pairs(actions) do
            if v == GLOBAL.ACTIONS.ATTACK and
            self.inst.prefab == "elphelt" and
            untouchables[target.prefab] then
                c = 1
                break
            end
        end
        if c == 1 then
            return {}
        else
            return old(self, actions, target, useitem)
        end
    end
end)

--Elphelt Tab

local elphelttab = AddRecipeTab( "Elphelt's Tab", 999, "images/hud/elphelttab.xml", "elphelttab.tex", "elphelt_builder")

AddRecipe("elpheltrifle", 
{GLOBAL.Ingredient("cutstone", 3), GLOBAL.Ingredient("goldnugget", 5), GLOBAL.Ingredient("nitre", 10), GLOBAL.Ingredient("gears", 2)}, 
elphelttab, TECH.NONE, nil, nil, nil, nil, "elphelt_builder", 
"images/inventoryimages/elpheltrifle.xml", "elpheltrifle.tex" )

AddRecipe("elpheltbazooka", 
{GLOBAL.Ingredient("cutstone", 10), GLOBAL.Ingredient("goldnugget", 10), GLOBAL.Ingredient("nitre", 15), GLOBAL.Ingredient("gears", 2)}, 
elphelttab, TECH.NONE, nil, nil, nil, nil, "elphelt_builder", 
"images/inventoryimages/elpheltbazooka.xml", "elpheltbazooka.tex" )

AddRecipe("elpheltshotgun", 
{GLOBAL.Ingredient("cutstone",  3), GLOBAL.Ingredient("goldnugget", 3), GLOBAL.Ingredient("nitre", 5), GLOBAL.Ingredient("gears", 1)}, 
elphelttab, TECH.NONE, nil, nil, nil, nil, "elphelt_builder", 
"images/inventoryimages/elpheltshotgun.xml", "elpheltshotgun.tex" )

AddRecipe("elpheltbomb", 
{GLOBAL.Ingredient("berries", 5), GLOBAL.Ingredient("gunpowder", 1)}, 
elphelttab, TECH.NONE, nil, nil, nil, 3, "elphelt_builder", 
"images/inventoryimages/elpheltbomb.xml", "elpheltbomb.tex" )

AddRecipe("elpheltbouquet", 
{GLOBAL.Ingredient("petals", 25), GLOBAL.Ingredient("papyrus", 2), GLOBAL.Ingredient("berries", 10)}, 
elphelttab, TECH.NONE, nil, nil, nil, nil, "elphelt_builder", 
"images/inventoryimages/elpheltbouquet.xml", "elpheltbouquet.tex" )

-- Custom Recipe Desc
STRINGS.RECIPE_DESC.ELPHELTSHOTGUN = "用爱把他们吹炸!" 
STRINGS.RECIPE_DESC.ELPHELTRIFLE = "射穿了心!"
STRINGS.RECIPE_DESC.ELPHELTBAZOOKA = "来得到一些!" 
STRINGS.RECIPE_DESC.ELPHELTBOUQUET = "我要把它!"
STRINGS.RECIPE_DESC.ELPHELTBOMB = "它的甜蜜和致命!"

-- The character select screen lines
STRINGS.CHARACTER_TITLES.elphelt = "善良的人"
STRINGS.CHARACTER_NAMES.elphelt = "艾尔菲尔特"
STRINGS.CHARACTER_DESCRIPTIONS.elphelt = "*武器库的“乐观”！有时感到很孤独."
STRINGS.CHARACTER_QUOTES.elphelt = "\"艾尔菲尔特情人…消除所有冗余，极端的偏见！\""

-- Custom speech strings
STRINGS.CHARACTERS.ELPHELT = require "speech_elphelt"

-- The character's name as appears in-game 
STRINGS.NAMES.ELPHELT = "艾尔菲尔特"

--Elphelt Personal Quotes
GLOBAL.STRINGS.CHARACTERS.ELPHELT.DESCRIBE.ELPHELTBOMB = "希望你喜欢甜草莓！（爆炸性/危险性！！）"
GLOBAL.STRINGS.CHARACTERS.ELPHELT.DESCRIBE.ELPHELTRIFLE = "射穿了心！ （4健康/ 6饥饿）"
GLOBAL.STRINGS.CHARACTERS.ELPHELT.DESCRIBE.ELPHELTBAZOOKA = "我会用我所有的感情来吹你！（41健康/ 10饥饿）"
GLOBAL.STRINGS.CHARACTERS.ELPHELT.DESCRIBE.ELPHELTPISTOL = "让我们不顾一切！拜托（- 1健康每使用）"
GLOBAL.STRINGS.CHARACTERS.ELPHELT.DESCRIBE.ELPHELTSHOTGUN = "让我们起床和个人，亲爱的！（-健康/ 2饥饿）"
GLOBAL.STRINGS.CHARACTERS.ELPHELT.DESCRIBE.ELPHELTBOUQUET = "我亲手做的花束会保证你的爱人！（更多的开槽背包）"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ELPHELT = 
{
	GENERIC = "这是艾尔菲尔特！",
	ATTACKER = "这艾尔菲尔特看起来鬼鬼祟祟的…",
	MURDERER = "凶手!",
	REVIVER = "艾尔菲尔特, 鬼朋友.",
	GHOST = "艾尔菲尔特可以用一个心脏.",
}

AddMinimapAtlas("images/map_icons/elphelt.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("elphelt", "FEMALE")

