
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
	"elpheltpistol",
}

-- local function Sparkle(inst)
    -- SpawnPrefab("elphelt_spin_fx").entity:AddFollower():FollowSymbol(inst.GUID, "swap_body", 0, 0, 0)
    -- inst:DoTaskInTime(math.random(8, 10), Sparkle)
-- end

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "elphelt_speed_mod", 1)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "elphelt_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

local untouchables = {
    crow = true,
    robin = true,
    robin_winter = true,
	babybeefalo = true, 
	penguin = true, 
	smallbird = true,
	catcoon = true,
	chester = true
}  

-- local function sanityfn(inst)
    -- (Comment)Debuff, dusk/night debuff value
    -- local delta = -0.08
    -- (Comment)Full bonus each player contributes
    -- (Comment)0.08 for 1 player being enough to be close, 0.04 for 2 players required, 0.026 for 3, 0.02 for 4
    -- local sz = 0.04
    -- for i, v in ipairs(AllPlayers) do
        -- if not (v == inst or v:HasTag("playerghost")) then
            -- (Comment)Other player needs to be within 10 units of distance for full sz bonus to apply, 10 * 10 = 100
            -- local distsq = inst:GetDistanceSqToInst(v) - 100
            -- delta = delta + sz / math.max(1, distsq)
        -- end
    -- end
    -- return math.min(0, delta)
-- end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "elphelt.tex" )
	inst:AddTag("elphelt_builder")
	
	inst:AddComponent("sanityaura")
	inst.components.sanityaura.aura = TUNING.SANITYAURA_MED
	
	inst:DoTaskInTime(0, function()
		local old = inst.replica.combat.IsValidTarget
		inst.replica.combat.IsValidTarget = function(self, target)
			if target and untouchables[target.prefab] then
				return false
			end
			return old(self, target)
		end
	end)
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(125)
	inst.components.hunger:SetMax(200)
	inst.components.sanity:SetMax(125)
	-- inst.components.sanity.custom_rate_fn = sanityfn
	inst.components.sanity.night_drain_mult = 1.3
	inst.components.sanity.neg_aura_mult = 1.1
	
	--Health Penalty
	inst.components.health.SetPenalty = function(self, penalty)
    self.penalty = math.clamp(penalty, 0, 0.25)
	end
	
	inst:AddTag("birdwhisperer")
	inst:RemoveTag("scarytoprey")
	
	-- inst:DoTaskInTime(math.random(8, 10), Sparkle)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
end

return MakePlayerCharacter("elphelt", prefabs, assets, common_postinit, master_postinit, start_inv)
