
local assets=
{
    Asset("ANIM", "anim/elpheltbazooka.zip"),
    Asset("ANIM", "anim/swap_elpheltbazooka.zip"),
 
    Asset("ATLAS", "images/inventoryimages/elpheltbazooka.xml"),
    Asset("IMAGE", "images/inventoryimages/elpheltbazooka.tex"),
}

local function onattack_elpheltbazooka(inst, attacker, target)
    if attacker and attacker.components.health and attacker.components.hunger then
        attacker.components.health:DoDelta(-25)
		attacker.components.hunger:DoDelta(-10)
    end

    local atkfx = SpawnPrefab("firesplash_fx")
	local atkfxx = SpawnPrefab("collapse_big")
    if atkfx and atkfxx then
	    local follower = atkfx.entity:AddFollower()
		local follower = atkfxx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
		follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
			for i, v in ipairs(AllPlayers) do
			v:ShakeCamera(CAMERASHAKE.FULL, .7, .02, .3, inst, 40)
		end
    end
	
    if target and target.brain and target.elpheltbazookastun ~= true then
        target.elpheltbazookastun = true
        target.brain:Stop()
        if target.components.locomotor then
            target.components.locomotor:Stop()
        end
        target:DoTaskInTime(10, function()
            target.brain:Start()
            target.elpheltbazookastun = nil
        end)
    end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("elpheltbazooka")
    inst.AnimState:SetBuild("elpheltbazooka")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
 
    local function OnEquip(inst, owner)
		owner.components.combat:SetAreaDamage(20, 1)
        owner.AnimState:OverrideSymbol("swap_object", "swap_elpheltbazooka", "swap_elpheltbazooka")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end
 
    local function OnUnequip(inst, owner)
	
		owner.components.combat:SetAreaDamage(nil, nil)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end
 
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "elpheltbazooka"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/elpheltbazooka.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
    inst.components.equippable.walkspeedmult = TUNING.PIGGYBACK_SPEED_MULT * 0.2
			
	inst:AddComponent("inspectable")
			
	inst:AddTag("shadow")
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack_elpheltbazooka)
    inst.components.weapon:SetDamage(350)
    inst.components.weapon:SetRange(20, 22)
	inst.components.weapon:SetProjectile("elpheltmissile")

    return inst
	
end

STRINGS.NAMES.ELPHELTBAZOOKA = "粉红色礼炮!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ELPHELTBAZOOKA = "我可以放在这粉红色的大炮一样武器!"
	
return  Prefab("common/inventory/elpheltbazooka", fn, assets)