local assets =
{
	Asset("ANIM", "anim/elpheltbouquet.zip"),
	Asset("ANIM", "anim/swap_elpheltbouquet.zip"),
    Asset("ATLAS", "images/inventoryimages/elpheltbouquet.xml"),
    Asset("IMAGE", "images/inventoryimages/elpheltbouquet.tex"),
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_body", "swap_elpheltbouquet", "backpack")
    owner.AnimState:OverrideSymbol("swap_body", "swap_elpheltbouquet", "swap_body")
    inst.components.container:Open(owner)
    
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")
    owner.AnimState:ClearOverrideSymbol("backpack")
    inst.components.container:Close(owner)
end

local function fn()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("elpheltbouquet")
    inst.AnimState:SetBuild("elpheltbouquet")
    inst.AnimState:PlayAnimation("idle")

    inst.MiniMapEntity:SetIcon("elpheltbouquet.png")
    
    inst.foleysound = "dontstarve/movement/foley/backpack"

    inst.entity:SetPristine()

if not TheWorld.ismastersim then
    inst.OnEntityReplicated = function(inst) inst.replica.container:WidgetSetup("piggyback") end
    return inst
end

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "elpheltbouquet"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/elpheltbouquet.xml"
	inst.components.inventoryitem.cangoincontainer = false

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_MED * 0.5

    
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("container")
    inst.components.container:WidgetSetup("piggyback")

    MakeHauntableLaunchAndDropFirstItem(inst)

    return inst
end

STRINGS.NAMES.ELPHELTBOUQUET = "幸福的花束!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ELPHELTBOUQUET = "漂亮的玫瑰红色的光泽与他们."

return Prefab("common/inventory/elpheltbouquet", fn, assets)