
local assets=
{
    Asset("ANIM", "anim/elpheltpistol.zip"),
    Asset("ANIM", "anim/swap_elpheltpistol.zip"),
 
    Asset("ATLAS", "images/inventoryimages/elpheltpistol.xml"),
    Asset("IMAGE", "images/inventoryimages/elpheltpistol.tex"),
}

local function onattack_elpheltpistol(inst, attacker, target)

    if attacker and attacker.components.health then
        attacker.components.health:DoDelta(-1)
    end
	
    local atkfx = SpawnPrefab("explode_small")
    if atkfx then
	    local follower = atkfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
    end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("elpheltpistol")
    inst.AnimState:SetBuild("elpheltpistol")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
 
    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_elpheltpistol", "swap_elpheltpistol")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end
 
    local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end
 
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "elpheltpistol"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/elpheltpistol.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
			
	inst:AddComponent("inspectable")
			
	inst:AddTag("shadow")
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack_elpheltpistol)
    inst.components.weapon:SetDamage(40)
    inst.components.weapon:SetRange(8, 10)
	inst.components.weapon:SetProjectile("fire_projectile")

    return inst
	
end

STRINGS.NAMES.ELPHELTPISTOL = "初恋的手枪!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ELPHELTPISTOL = "一种危险的武器,红色的粉红色与可爱的配件.真的吗?"
	
return  Prefab("common/inventory/elpheltpistol", fn, assets)