
local assets=
{
    Asset("ANIM", "anim/elpheltrifle.zip"),
    Asset("ANIM", "anim/swap_elpheltrifle.zip"),
 
    Asset("ATLAS", "images/inventoryimages/elpheltrifle.xml"),
    Asset("IMAGE", "images/inventoryimages/elpheltrifle.tex"),
}

local function onattack_elpheltrifle(inst, attacker, target)
    if attacker and attacker.components.health and attacker.components.hunger then
        attacker.components.health:DoDelta(-4)
		attacker.components.hunger:DoDelta(-6)
    end
	
    local atkfx = SpawnPrefab("explode_small")
    if atkfx then
	    local follower = atkfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
    end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("elpheltrifle")
    inst.AnimState:SetBuild("elpheltrifle")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
 
    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_elpheltrifle", "swap_elpheltrifle")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end
 
    local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end
 
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "elpheltrifle"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/elpheltrifle.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
    inst.components.equippable.walkspeedmult = TUNING.PIGGYBACK_SPEED_MULT * 0.7
			
	inst:AddComponent("inspectable")
			
	inst:AddTag("shadow")
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack_elpheltrifle)
    inst.components.weapon:SetDamage(100)
    inst.components.weapon:SetRange(20, 22)
	inst.components.weapon:SetProjectile("elpheltcrosshair")

    return inst
	
end

STRINGS.NAMES.ELPHELTRIFLE = "击杀步枪!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ELPHELTRIFLE = "长的,高的,致命的.带粉红色的."
	
return  Prefab("common/inventory/elpheltrifle", fn, assets)