
local assets=
{
    Asset("ANIM", "anim/elpheltshotgun.zip"),
    Asset("ANIM", "anim/swap_elpheltshotgun.zip"),
 
    Asset("ATLAS", "images/inventoryimages/elpheltshotgun.xml"),
    Asset("IMAGE", "images/inventoryimages/elpheltshotgun.tex"),
}

local function onattack_elpheltshotgun(inst, attacker, target)
    local atkfx = SpawnPrefab("explode_small")
    if atkfx then
	    local follower = atkfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
	end

    if attacker and attacker.components.health and attacker.components.hunger then
        attacker.components.health:DoDelta(-2)
		attacker.components.hunger:DoDelta(-2)
    end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("elpheltshotgun")
    inst.AnimState:SetBuild("elpheltshotgun")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
 
    local function OnEquip(inst, owner)
		owner.components.combat:SetAreaDamage(5, 1)
        owner.AnimState:OverrideSymbol("swap_object", "swap_elpheltshotgun", "swap_elpheltshotgun")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end
 
    local function OnUnequip(inst, owner)
		owner.components.combat:SetAreaDamage(nil, nil)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end
 
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "elpheltshotgun"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/elpheltshotgun.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
			
	inst:AddComponent("inspectable")
			
	inst:AddTag("shadow")
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack_elpheltshotgun)
    inst.components.weapon:SetDamage(50)
    inst.components.weapon:SetRange(6, 6)
	inst.components.weapon:SetProjectile("fire_projectile")

    return inst
	
end

STRINGS.NAMES.ELPHELTSHOTGUN = "爱之爆破枪!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ELPHELTSHOTGUN = "什么奇怪的技术,特别是粉红色的."
	
return  Prefab("common/inventory/elpheltshotgun", fn, assets)