
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

       Asset("ANIM", "anim/girl_rolling.zip"),
	   Asset("ANIM", "anim/amber.zip"),
	   Asset("ANIM", "anim/amber_hair1.zip"),
	   Asset("ANIM", "anim/amber_hair2.zip"),
	   Asset("ANIM", "anim/amber_hair3.zip"),
}
local prefabs = {
}


local start_inv = {

}

local function OnTimerDone(inst, data)
    local is_moving = inst.sg and inst.sg:HasStateTag("running")
    if data.name == "walk" and is_moving and not inst:HasTag("aquatic") and TUNING.AMBER_ROLLING == 0 then
	    inst:AddTag("rolling")
       	inst.AnimState:SetBank("girl_rolling")
		inst.AnimState:SetBuild("girl_rolling")
		inst.AnimState:PlayAnimation("run_loop", true)
		inst:RemoveEventCallback("timerdone", OnTimerDone)
	    inst:ListenForEvent("timerdone", OnTimerDone)
	    inst.components.timer:StartTimer("hard_roll", 7)
    end
    if data.name == "hard_roll" and is_moving and not inst:HasTag("aquatic") and inst:HasTag("rolling") then
	    inst:AddTag("hard_roll")
		inst:RemoveEventCallback("timerdone", OnTimerDone)
    end
end

local function check_any_time(inst)
    local is_moving = inst.sg and inst.sg:HasStateTag("running")
	if is_moving and not inst:HasTag("start_walk") and not inst:HasTag("aquatic") then
	    inst:AddTag("start_walk")
	    inst:ListenForEvent("timerdone", OnTimerDone)
	    inst.components.timer:StartTimer("walk", 3)
	end
	
	if inst:HasTag("rolling") and not inst:HasTag("hard_roll") then
        inst.components.hunger:DoDelta(-0.02, true, true)
	    inst.components.locomotor.walkspeed = 8
	    inst.components.locomotor.runspeed = 8
	end
	
	if inst:HasTag("rolling") and inst:HasTag("hard_roll") then
        inst.components.hunger:DoDelta(-0.04, true, true)
	    inst.components.locomotor.walkspeed = 10
	    inst.components.locomotor.runspeed = 10
	end

	if not is_moving and not inst:HasTag("aquatic") then
		inst:RemoveTag("start_walk")
		inst:RemoveTag("rolling")
		inst:RemoveTag("hard_roll")
		inst:RemoveEventCallback("timerdone", OnTimerDone)
	    inst.AnimState:SetBank("wilson")
		inst.AnimState:SetBuild("amber")
	    inst.components.locomotor.walkspeed = 5
	    inst.components.locomotor.runspeed = 5
	end
	--Prints for debugs.
	--print("Speed - "..inst.components.locomotor.walkspeed)
	--print("Hunger - "..inst.components.hunger.current)
    if inst.components.inventory and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS):HasTag("magic_trash") then
	    local item = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
		inst.components.inventory:Unequip(EQUIPSLOTS.HANDS, true) 
        inst.components.inventory:DropItem(item)
		inst.components.talker:Say("Trash!")
	end
    if inst.components.inventory and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.BODY) and inst.components.inventory:GetEquippedItem(EQUIPSLOTS.BODY):HasTag("magic_trash") then
	    local item = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.BODY)
		inst.components.inventory:Unequip(EQUIPSLOTS.BODY, true) 
        inst.components.inventory:DropItem(item)
		inst.components.talker:Say("Trash!")
	end
end


local fn = function(inst)

	inst.components.locomotor.walkspeed = 5
	inst.components.locomotor.runspeed = 5

	inst.soundsname = "willow"

	inst.MiniMapEntity:SetIcon( "amber.tex" )
	inst:AddTag("bearded")
	inst:AddTag("monster")
	
	
	inst.components.health:SetMaxHealth(TUNING.AMBER_HP)
	inst.components.hunger:SetMax(TUNING.AMBER_HUN)
	inst.components.sanity:SetMax(TUNING.AMBER_SANITY)

    inst.components.combat.damagemultiplier = 1.25
	
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst.components.sanity.night_drain_mult = TUNING.WENDY_SANITY_MULT
	
	inst:AddComponent("timer")
	
	inst:DoPeriodicTask(0, check_any_time)
	
    inst:AddComponent("beard")
    inst.components.beard.onreset = function()
        inst.AnimState:OverrideSymbol("headbase", "amber", "headbase")
	    inst.AnimState:OverrideSymbol("headbase_hat", "amber", "headbase_hat")
    end
    inst.components.beard.prize = "beardhair"
	
	local beard_days = {4, 8, 16}
	local beard_bits = {1, 3,  9}
	
    inst.components.beard:AddCallback(beard_days[1], function()
        inst.AnimState:OverrideSymbol("headbase", "amber_hair1", "headbase")
	    inst.AnimState:OverrideSymbol("headbase_hat", "amber_hair1", "headbase_hat")
        inst.components.beard.bits = beard_bits[1]
    end)
    
    inst.components.beard:AddCallback(beard_days[2], function()
        inst.AnimState:OverrideSymbol("headbase", "amber_hair2", "headbase")
	    inst.AnimState:OverrideSymbol("headbase_hat", "amber_hair2", "headbase_hat")
        inst.components.beard.bits = beard_bits[2]
    end)
    
    inst.components.beard:AddCallback(beard_days[3], function()
        inst.AnimState:OverrideSymbol("headbase", "amber_hair3", "headbase")
	    inst.AnimState:OverrideSymbol("headbase_hat", "amber_hair3", "headbase_hat")
        inst.components.beard.bits = beard_bits[3]
    end)
	
    inst.components.eater.stale_hunger = TUNING.WICKERBOTTOM_STALE_FOOD_HUNGER
    inst.components.eater.stale_health = TUNING.WICKERBOTTOM_STALE_FOOD_HEALTH
    inst.components.eater.spoiled_hunger = TUNING.WICKERBOTTOM_SPOILED_FOOD_HUNGER
    inst.components.eater.spoiled_health = TUNING.WICKERBOTTOM_SPOILED_FOOD_HEALTH
end

return MakePlayerCharacter("amber", prefabs, assets, fn, start_inv)
