-- This information tells other players more about the mod
name = "Playable Pets"
author = "Leonardo Coxington"
version = "2.4.r"
description = "Play as Pets/Monsters! \nPress the z,x,c keys when playing as mobs, they might do something special! \n \nVersion:"..version
-- This is the URL name of the mod's thread on the forum; the part after the ? and before the first & in the url
forumthread = "/topic/73911-playable-pets/"


-- This lets other players know if your mod is out of date, update it to match the current version in the game
api_version = 10

dst_compatible = true
dont_starve_compatible = false
reign_of_giants_compatible = false
all_clients_require_mod = true

icon_atlas = "modicon.xml"
icon = "modicon.tex"

priority = -308

server_filter_tags = {
"mob", "mobs", "playable", "monsters", "PP", "playable pets", "original"
}

---------------------------------
--            DATA             --
---------------------------------

-- For initializing configuration settings to disable each mob
local availableMobs = {"Hound", "Ice Hound", "Hell Hound", "Nightmare Hound", "Spider", "Spider Warrior", "Depth Dweller", "Spider Queen", "Dweller Queen", "Tree Guard", "Varg", "Mosling", "Moose/Goose", "Lavae", "Dragonfly", "Bearger", "Deerclops", "Ghost", "Pig", "Merm", "McTusk", "Tentacle", "Krampus", "Catcoon", "Beefalo", "Smallbird", "Tallbird", "Volt Goat", "Knight", "Bishop", "Rook"}

local defaultSkinName = "Something Different" -- Used if a name is not specified in the skins table

-- For Modded Inventory. Please note that this modified table format requires code at the bottom of this file to make it usable for modded inventory.f
menu_assets =
{
	skins = {
		{"smallbirdp_1",        "The green just makes the parents hate them more."},
		{"tallbirdplayer_1",    "Green just makes everything worse!"},
		{"vargplayer_1",        "Sure hope those aren't blood stains!"},
		{"dragonplayer_1",      "When you thought Dragonfly couldn't be hotter."},
		{"bearplayer_1",        "Brown Beargers are quite rare, probably because they make such fashionable coats."},
		{"deerplayer_1",        "Deerclops, but cooler... somehow."},
		{"houndplayer_1",       "A more domesticated look for our wild friend."},
		{"houndredplayer_1",    "For when red wasn't hot enough for you."},
		{"houndiceplayer_1",    "It's so cold that all of the other hounds hated it, and it became a lone wolf."},
		{"treeplayer_1",        "They'll never see you now!"},
		{"blackspiderplayer_1", "You just don't understand its pain."},
		{"warriorp_1",          "ITS NOT A PHASE MOM!"},
		{"queenspiderplayer_1", "Its babies will crawl in your skin, and the wounds, they will not heal."},
		{"whitespiderplayer_1", "It thinks it's cool now."},
		{"moosegooseplayer_1",  "It's so majestic by the lakeside, you have no idea!"},
		{"babygooseplayer_1",   "Less delicious looking, but still adorable."},
		{"catplayer_1",         "Despite being domesticated, it still steals stuff."},
		{"goatp_1",             "It embraced its true colors."},
		{"ghostplayer_1",       "Now with more ectoplasm!"},
		{"pigmanplayer_1",      "They tried blending in with the trees."},
		{"mermplayer_1",        "When merms are raised in cleaner waters."},
		{"walrusplayer_1",      "A new look never killed anyone... no-one important, at least."},
		{"clockwork1player_1",  "A fancy look for a deadly killer."},
		{"clockwork2player_1",  "Laughing at it will be the last thing they do."},
		{"clockwork3player_1",  "They will never see you coming in a forest."},
		{"krampusp_1",          "He's been at the theft job for a while, now."},
		
		-- Community Set --
		{"catplayer_6", "It's fluffy, but its bad-luck fluffy. \n \nContributed by Xiao", name = "Community"},
		{"bearplayer_6", "Its too fluffy to bear. \n \nContributed by Xiao", name = "Community"},
		{"krampusp_6", "Stealin dat booty. \n \nContributed by Leonardo Coxington", name = "Community"},
	},
}

local SETTING = {
	OFF = "Off",
	DISABLE = "Disable",
	ENABLE = "Enable",
	LOCKED = "Locked",
	
	-- Mob Presets
	ALL_MOBS = "AllMobs",
	NO_GIANTS = "NoGiants",
	NO_BOSSES = "NoBosses",
	BOSSES_ONLY = "BossesOnly",
	GIANTS_ONLY = "GiantsOnly",
	CRAFTY_MOBS = "CraftyMobsOnly",
	
	-- Mob Houses
	HOUSE_CRAFT_ONLY = "Enable2",
	HOUSE_ON_SPAWN = "Enable1",
	HOUSE_BOTH = "Enable3",
	
	-- PvP Damage
	PVP_50_PERCENT_DMG = 0.5,
	PVP_100_PERCENT_DMG = 1.0,
	PVP_150_PERCENT_DMG = 1.5,
	PVP_200_PERCENT_DMG = 2.0,
	
	-- Misc
	HUMANOID_SANITY_ONLY = "Disable1",
	MONSTER_CHARCHANGE_ONLY = "Enable1",
}

---------------------------------
--       CONFIG OPTIONS        --
---------------------------------

configuration_options = {
	{
		name = "MobGhosts",
		label = "Mob Ghosts",
		options = 
		{
			{description = "Yes", data = SETTING.ENABLE,  hover = "Mobs will become ghosts on death."},
			{description = "No",  data = SETTING.DISABLE, hover = "Mobs will return to character select on death."},
			--{description = "Locked", data = SETTING.LOCKED, hover = "Coming Soon?"},
		},
		default = SETTING.DISABLE
	},
	
	{
		name = "Mobchange",
		label = "Character Change (P)",
		options = 
		{
			{description = "Enable",  data = SETTING.ENABLE},
			--{description = "For Monsters Only", data = SETTING.MONSTER_CHARCHANGE_ONLY},
			{description = "Disable", data = SETTING.DISABLE},
		},
		default = SETTING.ENABLE
	},
	
	{
		name = "Hunger",
		label = "Should Mobs get hungry?",
		options = 
		{
			{description = "Yes", data = SETTING.ENABLE},
			{description = "No",  data = SETTING.DISABLE},
		},
		default = SETTING.ENABLE
	},
	
	{
		name = "MobSanity",
		label = "Mob Sanity Drain (WIP)",
		options = 
		{
			{description = "Yes",       data = SETTING.ENABLE,               hover = "Mobs will lose sanity and get tired."},
			{description = "Humanoids", data = SETTING.HUMANOID_SANITY_ONLY, hover = "Only mobs similar to pigmen will lose sanity."},
			{description = "No",        data = SETTING.DISABLE,              hover = "No mob will lose sanity."},
		},
		default = SETTING.ENABLE
	},
	
	{
		name = "MobSpecialVision",
		label = "Mob Special Vision",
		options = 
		{
			{description = "Disable", data = SETTING.DISABLE, hover = "Mobs with special vision will use regular vision to avoid eye strain."},
			{description = "Enable",  data = SETTING.ENABLE,  hover = "Mobs will keep their special vision."},
		},
		default = SETTING.ENABLE
	},
	
	{
		name = "MobFire",
		label = "Fire Abilities",
		options = 
		{
			{description = "Enable",  data = SETTING.ENABLE,  hover = "Fire related abilities will be disabled."},
			{description = "Disable", data = SETTING.DISABLE, hover = "Fire related abilities will be enabled."},
		},
		default = SETTING.DISABLE
	},
	
	{
		name = "MobCraft",
		label = "Mob Crafting",
		options = 
		{
			{description = "Yes", data = SETTING.ENABLE,  hover = "All mobs can craft, build, etc."},
			{description = "No",  data = SETTING.DISABLE, hover = "Most mob's actions are restricted."},
		},
		default = SETTING.DISABLE
	},
	
	{
		name = "MobHouseMethod",
		label = "House Attainability",
		options = 
		{
			{description = "On Spawn", data = SETTING.HOUSE_ON_SPAWN,   hover = "Mobs will spawn with their homes."},
			{description = "Crafting", data = SETTING.HOUSE_CRAFT_ONLY, hover = "Homes will need to be crafted."},
			{description = "Both",     data = SETTING.HOUSE_BOTH,       hover = "Homes can be crafted and obtained on Spawn."},
			{description = "No Homes", data = SETTING.DISABLE,          hover = "Homes cannot be obtained through normal means."},
		},
		default = SETTING.HOUSE_ON_SPAWN
	},
	
	{
		name = "MobPvP",
		label = "PvP Damage Scale", -- Testing to see if variables can be used in place of strings.
		options = 
		{
			{description = "50%",  data = SETTING.PVP_50_PERCENT_DMG,  hover = "Mobs will do half damage to players (recommended for co-op)."},
			{description = "100%", data = SETTING.PVP_100_PERCENT_DMG, hover = "Mobs will do default dmg to players."},
			{description = "150%", data = SETTING.PVP_150_PERCENT_DMG, hover = "Mobs will do 50% more damage to players (recommended for PvP probably)."},
			{description = "200%", data = SETTING.PVP_200_PERCENT_DMG, hover = "Mobs will do double damage to players (NOT RECOMMENDED FOR PUB PLAY)."},
		},
		default = SETTING.PVP_50_PERCENT_DMG
	},
	
	{
		name = "MobPvPMode",
		label = "PvP Mode", 
		options = 
		{
			{description = "Enable",  data = SETTING.ENABLE,  hover = "Mod contents will be altered to provide a PvP experience"},
			{description = "Disable", data = SETTING.DISABLE, hover = "Mod contents are altered to provide a Co-op experience"},
			--{description = "Locked", data = SETTING.LOCKED, hover = "Coming Soon?"},
		},
		default = SETTING.DISABLE
	},
	
	{
		name = "GvGMode",
		label = "GvG Mode", 
		options = 
		{
			--{description = "Enable",  data = SETTING.ENABLE,  hover = "Giants will gain new abilities meant to combat other Giants"},
			{description = "Locked", data = SETTING.DISABLE, hover = "Coming Soon"},--"Giants will act closer to their ingame counterparts"},
			--{description = "Locked", data = SETTING.LOCKED, hover = "Coming Soon?"},
		},
		default = SETTING.DISABLE
	},
}

---------------------------------
-- TABLE POPULATION CODE BELOW --
---------------------------------

-- Automatically populate enable/disable configuration settings for mobs
local settingEnable = {
	{description = "Enabled", data = SETTING.ENABLE},
	{description = "Disabled", data = SETTING.DISABLE},
}

for i = 1, #availableMobs do	
	local configOption = {}
	configOption.name = availableMobs[i]
	configOption.label = availableMobs[i]
	configOption.options = settingEnable
	configOption.default = SETTING.ENABLE
	
	configuration_options[#configuration_options + 1] = configOption
end

-- Automatically populate the Modded Inventory skins table
for i = 1, #menu_assets.skins do
		local data = menu_assets.skins[i]
		local skinName = data.name
		
		-- Use a specified name if available. Otherwise, choose the default
		if skinName == nil then
			skinName = defaultSkinName
		end
		
		local skin = {
			name = skinName,
			desc = data[2],
			atlas = "images/skinicons/"..data[1]..".xml",
			image = data[1]..".tex",
		}
		
		menu_assets.skins[i] = skin
end