local MakePlayerCharacter = require "prefabs/player_common"

--ToDo: Make Mossling grow up by eating.

local assets = {
	--Asset( "ANIM", "anim/ghost_waxwell_build.zip" ),
	Asset("ANIM", "anim/mossling_shiny_build_01.zip"),
	Asset("ANIM", "anim/mossling_angry_shiny_build_01.zip"),
	
}
local prefabs = 
{
    "mossling_spin_fx",
}
local start_inv = {
	"goose_feather",
	"goose_feather",
	
}

local MIN_HEAT = 60
local MAX_HEAT = 60

local function RestoreNightImmunity(inst)

	inst:DoTaskInTime(3, function(inst) 
	inst.Light:Enable(true)
	inst.Light:SetRadius(0)
	inst.Light:SetFalloff(.1)
	inst.Light:SetIntensity(.1)
	inst.Light:SetColour(245/255,40/255,0/255)
	end, inst)
end

------------------------------------------------------
----PvP Teleport----

local function getwildposition(inst)
    local ground = TheWorld
    local centers = {}
    for i, node in ipairs(ground.topology.nodes) do
        if ground.Map:IsPassableAtPoint(node.x, 0, node.y) then
            table.insert(centers, {x = node.x, z = node.y})
        end
    end
    if #centers > 0 then
        local pos = centers[math.random(#centers)]
        return Point(pos.x, 0, pos.z)
    else
        return inst:GetPosition()
    end
end

local function PvPTeleport(inst)
if inst.mobteleported == nil or inst.mobteleported == false then
	local ground = TheWorld
	local pt = getwildposition(inst)--Point(inst.Transform:GetWorldPosition())
      if pt.y <= .1 then
         pt.y = 0
         inst.Physics:Stop()
         inst.Physics:Teleport(pt.x,pt.y,pt.z)
		 inst.mobteleported = true
      end
	end
end

------------------------------------------------------
local function OnLoad(inst, data)
	if data ~= nil then
		inst.mobteleported = data.mobteleported or false
		inst.isshiny = data.isshiny or 0
	end
end

local function OnSave(inst, data)
	data.mobteleported = inst.mobteleported or false
	data.isshiny = inst.isshiny or 0
end

local function setSkin(inst)
	if not inst:HasTag("playerghost") then
		local mobskin = inst.components.skinner.skin_name
		local getshiny = (mobskin ~= inst.prefab and mobskin ~= "") and string.gsub(mobskin, inst.prefab.."_", "" ) --will return false if no skin is equipped.
		if SKIN_RARITY_COLORS.ModMade ~= nil then
			if getshiny ~= false then
				inst.isshiny = getshiny --used for other purposes
				inst.AnimState:SetBuild("mossling_shiny_build_0"..inst.isshiny)
			end		
		end
	end	
end
-------------------------------------------------------

local function setChar(inst)
	if not inst:HasTag("playerghost") then 
    inst.AnimState:SetBank("mossling")
    inst.AnimState:SetBuild("mossling_build")
    inst:SetStateGraph("SGbabygooseplayer")
	end
	if MOBPVPMODE == "Enable" then
		PvPTeleport(inst)
	end
	if MONSTERHUNGER == "Disable" then
		inst.components.hunger:Pause()
	end
	inst.components.sanity.ignore = true
end

local function CalcSanityAura(inst, observer)
	if inst.components.combat.target then
		return TUNING.SANITYAURA_LARGE
	else
		return TUNING.SANITYAURA_LARGE
	end
end

--local MOOSE_SCALE = 1.55

SetSharedLootTable( 'babygooseplayer',
{
    {'drumstick',        1.00},
    {'drumstick',        1.00},
    {'goose_feather',    1.00},
    {'goose_feather',    1.00},
    {'goose_feather',    1.00},
    {'goose_feather',    0.33},
    {'goose_feather',    0.33},
})

local function DontTriggerCreep(inst)
    inst.components.locomotor.walkspeed = (TUNING.MOOSE_WALK_SPEED)
	inst.components.locomotor.runspeed = (TUNING.MOOSE_WALK_SPEED)
	inst.components.locomotor.fasteronroad = false
end

local function RemovePenalty(inst)
	inst.components.health:DeltaPenalty(-1.00) --Removes health penalty when reviving
	inst.components.health:DoDelta(20000, false) --Returns heals to max health upon reviving
end

local common_postinit = function(inst) 
	inst.soundsname = "wilson"

	inst.MiniMapEntity:SetIcon( "babygooseplayer.tex" )
	
	inst:DoTaskInTime(0, function()
   if ThePlayer then
      inst:EnableMovementPrediction(false)
   end
end)   
end

local master_postinit = function(inst)
    inst.components.health:SetMaxHealth(250)
	inst.components.hunger:SetMax(150)
	inst.components.hunger:SetRate(0.15)
	--inst:AddComponent("healthSRegenerate")
    --inst.components.temperature.inherentinsulation = -TUNING.INSULATION_SMALL
	inst.components.combat:SetHurtSound("dontstarve_DLC001/creatures/mossling/hurt")
	inst.components.combat:SetDefaultDamage(30*2)
    inst.components.combat.playerdamagepercent = MOBPVP
    inst.components.combat:SetRange(TUNING.MOSSLING_ATTACK_RANGE)
    inst.components.combat.hiteffectsymbol = "mossling_body"
	inst.OnSetSkin = function(skin_name)
    inst.AnimState:SetBuild("mossling_build")
	inst:SetStateGraph("SGbabygooseplayer")
	end
	inst.components.talker:IgnoreAll()
	if MONSTERHUNGER == "Disable" then
		inst.components.hunger:Pause()
	end
	inst.components.sanity.ignore = true
	
	inst.isangry = false
	inst.taunt = true
	inst.specialatk2 = true
	
	
	-------
	inst.components.temperature.maxtemp = 60 --No min temp, Baby needs to keep near mother for warmth.
	
	--inst:AddComponent("heater")
	--inst.components.heater.heat = MAX_HEAT
	inst:AddComponent("sizetweener")

	-------
	local s = 1
    inst.Transform:SetScale(s,s,s)
    inst.Transform:SetFourFaced()

    inst.DynamicShadow:SetSize(1.5, 1.25)

    MakeCharacterPhysics(inst, 50, .5)

	-------
	inst.components.locomotor.walkspeed = TUNING.MOOSE_WALK_SPEED
	inst.components.locomotor.runspeed = TUNING.MOOSE_WALK_SPEED
	inst.components.locomotor.fasteronroad = false
	inst.components.health.destroytime = 3
	-------
	MakeMediumBurnableCharacter(inst, "swap_fire")
    inst.components.burnable.lightningimmune = true
	
	inst.AnimState:SetBank("mossling")
    inst.AnimState:SetBuild("mossling_build")
    inst:SetStateGraph("SGbabygooseplayer")
	
    inst:AddTag("mossling")    
    inst:AddTag("animal")
	inst:AddTag("mobsleep")
	inst:AddTag("mobplayer")
    
	inst.ghostbuild = "ghost_monster_build"
	inst.mobteleported = false
	inst.isshiny = 0
	-------
    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetChanceLootTable('babygooseplayer')
	-------
	inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = CalcSanityAura
	-------
	inst.components.eater:SetDiet({ FOODGROUP.MOOSE }, { FOODGROUP.MOOSE })
	--inst.components.eater.eatwholestack = true
	-------
	inst.OnSave = OnSave
    inst.OnLoad = OnLoad
	-------
	local light = inst.entity:AddLight()
  	inst.Light:Enable(true)
	inst.Light:SetRadius(0)
	inst.Light:SetFalloff(.1)
	inst.Light:SetIntensity(.1)
	inst.Light:SetColour(245/255,40/255,0/255)
	
	inst.components.talker.colour = Vector3(127/255, 0/255, 0/255)
	inst:DoTaskInTime(0, setChar)
	if SKIN_RARITY_COLORS.ModMade ~= nil then
	inst:DoTaskInTime(3, setSkin)
	end
    inst:ListenForEvent("respawnfromghost", function()
		inst:DoTaskInTime(3, function()  inst.components.health:SetInvincible(false)
            if inst.components.playercontroller ~= nil then
				inst.components.playercontroller:EnableMapControls(true)
				inst.components.playercontroller:Enable(true)
			end
			inst.components.inventory:Show()
			inst:ShowActions(true)
            inst:ShowHUD(true)
            inst:SetCameraDistance()
			inst.sg:RemoveStateTag("busy")
            SerializeUserSession(inst) 
		end)
		inst:DoTaskInTime(5, DontTriggerCreep)
        inst:DoTaskInTime(5, setChar)
		inst:DoTaskInTime(5.1, setSkin)
		inst:DoTaskInTime(6, RemovePenalty)
		inst:DoTaskInTime(6, RestoreNightImmunity)
    end)
	


	
    return inst
	
end

if SKIN_RARITY_COLORS.ModMade ~= nil then
AddModCharacterSkin("babygooseplayer", 1, {normal_skin = "mossling_shiny_build_01", ghost_skin = "ghost_monster_build"}, {"deerclops_shiny_build_01", "ghost_monster_build"}, {"DEERPLAYER", "FORMAL"})
end

return MakePlayerCharacter("babygooseplayer", prefabs, assets, common_postinit, master_postinit, start_inv)
