local MakePlayerCharacter = require "prefabs/player_common"

local assets = 
{
	Asset("ANIM", "anim/hound_basic.zip"),
    Asset("ANIM", "anim/hound.zip"),
    Asset("ANIM", "anim/hound_red.zip"),
    Asset("ANIM", "anim/hound_ice.zip"),
    Asset("SOUND", "sound/hound.fsb"),
	Asset("ANIM", "anim/hound_red_shiny_build_01.zip"),
	--Asset("ANIM", "anim/ghost_waxwell_build.zip"),
}
local prefabs = {
	"houndstooth",
    "monstermeat",
    "redgem",
    "bluegem",
}
	
local start_inv = {
	"houndstooth",
	"houndstooth",
	--"monstermeat",
}

local start_inv2 = 
{
	"houndstooth",
	"houndstooth",
	"houndhome",
}

if MOBHOUSE == "Enable1" or MOBHOUSE == "Enable3" then
	start_inv = start_inv2
end

SetSharedLootTable( 'houndredplayer',
{
	{'monstermeat',			 1.00},
	{'houndstooth',			 0.50},
	{'houndstooth',			 0.50},
	{'redgem',			 	 0.25},
	{'houndfire',   1.0},
    {'houndfire',   1.0},
	
})

SetSharedLootTable( 'houndredplayer_safe',
{
	{'monstermeat',			 1.00},
	{'houndstooth',			 0.50},
	{'houndstooth',			 0.50},
	{'redgem',			 	 0.25},	
})


local NIGHTVISION_COLOURCUBES =
{
    day = "images/colour_cubes/insane_day_cc.tex",
    dusk = "images/colour_cubes/insane_dusk_cc.tex",
    night = "images/colour_cubes/mole_vision_on_cc.tex",
    full_moon = "images/colour_cubes/purple_moon_cc.tex",
}

local FIXEDVISION_COLOURCUBES =
{
    day = "images/colour_cubes/purple_moon_cc.tex",
    dusk = "images/colour_cubes/purple_moon_cc.tex",
    night = "images/colour_cubes/purple_moon_cc.tex",
    full_moon = "images/colour_cubes/purple_moon_cc.tex",
}


local function SetNightVision(inst, enable)
    if TheWorld.state.isnight or TheWorld:HasTag("cave") then
        inst.components.playervision:ForceNightVision(true)
		if MOBVISION == "Enable" then
        inst.components.playervision:SetCustomCCTable(NIGHTVISION_COLOURCUBES)
		else
		inst.components.playervision:SetCustomCCTable(FIXEDVISION_COLOURCUBES)
		end
    else
        inst.components.playervision:ForceNightVision(false)
        inst.components.playervision:SetCustomCCTable(nil)
    end
end	

local function CanShareTarget(dude)
    return dude:HasTag("hound")
        and not dude:IsInLimbo()
        and not (dude.components.health:IsDead() or dude:HasTag("player"))
end

local function OnAttacked(inst, data)
        inst.components.combat:SetTarget(data.attacker)
        inst.components.combat:ShareTarget(data.attacker, 30, CanShareTarget, 5)
 end

local function RestoreNightvision(inst)

	inst:DoTaskInTime(3, function(inst) 
	inst.Light:Enable(true)
	inst.Light:SetRadius(0)
	inst.Light:SetFalloff(0.1)
	inst.Light:SetIntensity(0.1)
	inst.Light:SetColour(245/255,40/255,0/255)
	end, inst)
end

------------------------------------------------------
----PvP Teleport----

local function getwildposition(inst)
    local ground = TheWorld
    local centers = {}
    for i, node in ipairs(ground.topology.nodes) do
        if ground.Map:IsPassableAtPoint(node.x, 0, node.y) then
            table.insert(centers, {x = node.x, z = node.y})
        end
    end
    if #centers > 0 then
        local pos = centers[math.random(#centers)]
        return Point(pos.x, 0, pos.z)
    else
        return inst:GetPosition()
    end
end

local function PvPTeleport(inst)
if inst.mobteleported == nil or inst.mobteleported == false then
	local ground = TheWorld
	local pt = getwildposition(inst)--Point(inst.Transform:GetWorldPosition())
      if pt.y <= .1 then
         pt.y = 0
         inst.Physics:Stop()
         inst.Physics:Teleport(pt.x,pt.y,pt.z)
		 inst.mobteleported = true
      end
	end
end

------------------------------------------------------
local function OnLoad(inst, data)
	if data ~= nil then
		inst.mobteleported = data.mobteleported or false
		inst.isshiny = data.isshiny or 0
	end
end

local function OnSave(inst, data)
	data.mobteleported = inst.mobteleported or false
	data.isshiny = inst.isshiny or 0
end

local function setSkin(inst)
	if not inst:HasTag("playerghost") then
		local mobskin = inst.components.skinner.skin_name
		local getshiny = (mobskin ~= inst.prefab and mobskin ~= "") and string.gsub(mobskin, inst.prefab.."_", "" ) --will return false if no skin is equipped.
		if SKIN_RARITY_COLORS.ModMade ~= nil then
			if getshiny ~= false then
				inst.isshiny = getshiny --used for other purposes
				inst.AnimState:SetBuild("hound_red_shiny_build_0"..inst.isshiny)
			end		
		end
	end	
end

local function setChar(inst)
	if not inst:HasTag("playerghost") then
    inst.AnimState:SetBank("hound")
    inst.AnimState:SetBuild("hound_red")
    inst:SetStateGraph("SGhoundplayer")
	end
	if MONSTERHUNGER == "Disable" then
		inst.components.hunger:Pause()
	end
	if MOBPVPMODE == "Enable" then
		PvPTeleport(inst)
	end
	inst.components.sanity.ignore = true
end


local function DontTriggerCreep(inst)
    inst.components.locomotor.runspeed = (TUNING.HOUND_SPEED)
	inst.components.locomotor.fasteronroad = false
end

local function SetSandstormImmunity(inst)
	if TheWorld.state.issummer and not TheWorld:HasTag("cave") then
        inst.components.playervision:ForceGoggleVision(true)
    else
        inst.components.playervision:ForceGoggleVision(false)
    end
end

local common_postinit = function(inst) 
	inst.soundsname = "wilson"

	inst.MiniMapEntity:SetIcon( "houndredplayer.tex" )

	inst:DoTaskInTime(0, function()
   if ThePlayer then
      inst:EnableMovementPrediction(false)
   end
   
end)

	inst:WatchWorldState( "isday", function() SetNightVision(inst) end)
  	inst:WatchWorldState( "isdusk", function() SetNightVision(inst) end)
  	inst:WatchWorldState( "isnight", function() SetNightVision(inst)  end)
	inst:WatchWorldState( "iscaveday", function() SetNightVision(inst) end)
  	inst:WatchWorldState( "iscavedusk", function() SetNightVision(inst) end)
  	inst:WatchWorldState( "iscavenight", function() SetNightVision(inst)  end)
	
	inst:WatchWorldState( "issummer", function() SetSandstormImmunity(inst) end) --makes immune to Sandstorm visual issues.
	
	SetSandstormImmunity(inst)
	
	SetNightVision(inst)
end

local function RemovePenalty(inst)
	inst.components.health:DeltaPenalty(-1.00) --Removes health penalty when reviving
	inst.components.health:DoDelta(20000, false) --Returns heals to max health upon reviving
end


local master_postinit = function(inst)
    inst.components.health:SetMaxHealth(150)
	--inst:AddComponent("healthRegenerate")
	inst.components.hunger:SetRate(0.2)
	inst.components.combat.playerdamagepercent = MOBPVP
	inst.components.combat.pvp_damagemod = 1 --disables second pvp override.
    --inst.components.combat:SetAttackPeriod(TUNING.FIREHOUND_ATTACK_PERIOD)
	inst.components.combat:SetRange(TUNING.WORM_ATTACK_DIST)
    inst.components.locomotor.runspeed = (TUNING.HOUND_SPEED)
	inst.components.locomotor.fasteronroad = false
	inst.components.combat:SetDefaultDamage(50)
	inst.components.combat:SetHurtSound("dontstarve/creatures/hound/hit")
	--inst.components.health.fire_damage_scale = TUNING.WILLOW_FIRE_DAMAGE
	--inst.components.temperature.hurtrate = 1
    inst.components.temperature.inherentinsulation = -TUNING.INSULATION_SMALL
	inst.AnimState:SetBank("hound")
	inst.AnimState:SetBuild("hound_red")	
	inst.OnSetSkin = function(skin_name)
    inst.AnimState:SetBuild("hound_red")
	inst:SetStateGraph("SGhoundplayer")
	
	
	
	inst.components.health.fire_damage_scale = 0
	
	
	
	inst:ListenForEvent("ms_respawnedfromghost", DontTriggerCreep)
    DontTriggerCreep(inst)
	
	inst.components.eater:SetDiet({ FOODTYPE.MEAT }, { FOODTYPE.MEAT })
    inst.components.eater:SetCanEatHorrible()

    inst.components.eater.strongstomach = true -- can eat monster meat!
	
	end
	inst:SetStateGraph("SGhoundplayer")
	inst.components.locomotor:SetShouldRun(true)
	inst.components.talker:IgnoreAll()
	if MONSTERHUNGER == "Disable" then
		inst.components.hunger:Pause()
	end
	inst.components.sanity.ignore = true
	
	
	inst:AddTag("hound")
	inst:AddTag("monster")
	--inst:AddTag("houndfriend")
	inst:AddTag("mobsleep")
	inst:AddTag("mobplayer")
	inst:AddTag("character")

	inst.taunt = true
	inst.scared_task = nil
	inst.taunt2 = true
	inst.ghostbuild = "ghost_monster_build"
	inst.mobteleported = false
	
	inst.OnSave = OnSave
	inst.OnLoad = OnLoad	
	
	MakeCharacterPhysics(inst, 10, .5)
    inst.DynamicShadow:SetSize(2.5, 1.5)
    inst.Transform:SetFourFaced()

    
	inst.components.temperature.maxtemp = 60
	
    inst:AddComponent("lootdropper")
	if MOBFIRE == "Disable" then
	inst.components.lootdropper:SetChanceLootTable('houndredplayer')
	else
	inst.components.lootdropper:SetChanceLootTable('houndredplayer_safe')
	end

    inst.components.eater:SetDiet({ FOODTYPE.MEAT }, { FOODTYPE.MEAT })
    inst.components.eater:SetCanEatHorrible()
	
	inst.components.eater:SetAbsorptionModifiers(1,1.5,1.5)
	
	 inst.components.eater.strongstomach = true -- can eat monster meat!
	
	MakeMediumFreezableCharacter(inst, "hound_body")
	MakeMediumBurnableCharacter(inst, "hound_body")
	inst.components.health.fire_damage_scale = 0
	inst:ListenForEvent("attacked", OnAttacked)
    
	
	------------------
    
    ------------------

	
  	local light = inst.entity:AddLight()
  	inst.Light:Enable(true)
  	inst.Light:SetRadius(0)
  	inst.Light:SetFalloff(0.9)
  	inst.Light:SetIntensity(0.6)
  	inst.Light:SetColour(180/255,195/255,150/255)

  	--Stats varies day/night
	
	inst.components.talker.colour = Vector3(127/255, 0/255, 0/255)
	inst:ListenForEvent("respawnfromghost", RestoreNightvision)

    inst:DoTaskInTime(0, setChar)
	inst:DoTaskInTime(3, setSkin)
    inst:ListenForEvent("respawnfromghost", function()
		inst:DoTaskInTime(3, function()  inst.components.health:SetInvincible(false)
            if inst.components.playercontroller ~= nil then
				inst.components.playercontroller:EnableMapControls(true)
				inst.components.playercontroller:Enable(true)
			end
			inst.components.inventory:Show()
			inst:ShowActions(true)
            inst:ShowHUD(true)
            inst:SetCameraDistance()
			inst.sg:RemoveStateTag("busy")
            SerializeUserSession(inst) 
		end)
        inst:DoTaskInTime(5, setChar)
		inst:DoTaskInTime(5.1, setSkin)
		inst:DoTaskInTime(6, DontTriggerCreep)
		inst:DoTaskInTime(6, RemovePenalty)
		inst:DoTaskInTime(10, RestoreNightvision)
    end)
	
    return inst
	
end

if SKIN_RARITY_COLORS.ModMade ~= nil then
AddModCharacterSkin("houndredplayer", 1, {normal_skin = "deerclops_shiny_build_01", ghost_skin = "ghost_monster_build"}, {"deerclops_shiny_build_01", "ghost_monster_build"}, {"DEERPLAYER", "FORMAL"})
end

return MakePlayerCharacter("houndredplayer", prefabs, assets, common_postinit, master_postinit, start_inv)
