local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
	Asset("ANIM", "anim/goosemoose_shiny_build_01.zip"),
	Asset("ANIM", "anim/goosemoose_shiny_build_03.zip"),
}
local prefabs = 
{

}
local start_inv = {
	--"hammer",
}

local MIN_HEAT = 60
local MAX_HEAT = 60

local function onupdate(inst, dt)
    inst.charge_time = inst.charge_time - dt
    if inst.charge_time <= 0 then
        inst.charge_time = 0
		if inst.charge_task ~= nil then
            inst.charge_task:Cancel()
            inst.charge_task = nil
        end
        inst.specialatk = true
		inst.sg:GoToState("special_atk1")
    else
    --    
    end
end

local function OnLongUpdate(inst, dt)
    inst.charge_time = math.max(0, inst.charge_time - dt)
end



local function StartTimer(inst, duration)
    inst.charge_time = duration
	inst.specialatk = false

    if inst.charge_task == nil then
        inst.charge_task = inst:DoPeriodicTask(1, onupdate, nil, 1)
        onupdate(inst, 0)
    end
end

local function onload(inst, data)
    if data ~= nil and data.charge_time ~= nil then
        StartTimer(inst, data.charge_time)
		
    end
	if data ~= nil then
		inst.mobteleported = data.mobteleported or false
		inst.isshiny = data.isshiny or 0
	end	
end

local function onsave(inst, data)
    data.charge_time = inst.charge_time > 0 and inst.charge_time or nil
	data.mobteleported = inst.mobteleported or false
	data.isshiny = inst.isshiny or 0
end

local function setSkin(inst)
	if not inst:HasTag("playerghost") then
		local mobskin = inst.components.skinner.skin_name
		local getshiny = (mobskin ~= inst.prefab and mobskin ~= "") and string.gsub(mobskin, inst.prefab.."_", "" ) --will return false if no skin is equipped.
		if SKIN_RARITY_COLORS.ModMade ~= nil then
			if getshiny ~= false then
				inst.isshiny = getshiny --used for other purposes
				inst.AnimState:SetBuild("goosemoose_shiny_build_0"..inst.isshiny)
			end		
		end
	end	
end

local function RestoreNightvision(inst)

	inst:DoTaskInTime(3, function(inst) 
	inst.Light:Enable(true)
	inst.Light:SetRadius(0)
	inst.Light:SetFalloff(.1)
	inst.Light:SetIntensity(.1)
	inst.Light:SetColour(245/255,40/255,0/255)
	end, inst)
end

local NIGHTVISION_COLOURCUBES =
{
    day = "images/colour_cubes/mole_vision_off_cc.tex",
    dusk = "images/colour_cubes/mole_vision_on_cc.tex",
    night = "images/colour_cubes/purple_moon_cc.tex",
    full_moon = "images/colour_cubes/purple_moon_cc.tex",
}

local function SetNightVision(inst, enable)
    if TheWorld.state.isnight or TheWorld:HasTag("cave") then
        inst.components.playervision:ForceNightVision(true)
        inst.components.playervision:SetCustomCCTable(NIGHTVISION_COLOURCUBES)
    else
        inst.components.playervision:ForceNightVision(false)
        inst.components.playervision:SetCustomCCTable(nil)
    end
end

------------------------------------------------------
----PvP Teleport----

local function getwildposition(inst)
    local ground = TheWorld
    local centers = {}
    for i, node in ipairs(ground.topology.nodes) do
        if ground.Map:IsPassableAtPoint(node.x, 0, node.y) then
            table.insert(centers, {x = node.x, z = node.y})
        end
    end
    if #centers > 0 then
        local pos = centers[math.random(#centers)]
        return Point(pos.x, 0, pos.z)
    else
        return inst:GetPosition()
    end
end

local function PvPTeleport(inst)
if inst.mobteleported == nil or inst.mobteleported == false then
	local ground = TheWorld
	local pt = getwildposition(inst)--Point(inst.Transform:GetWorldPosition())
      if pt.y <= .1 then
         pt.y = 0
         inst.Physics:Stop()
         inst.Physics:Teleport(pt.x,pt.y,pt.z)
		 inst.mobteleported = true
      end
	end
end

------------------------------------------------------
local function setChar(inst)
	if not inst:HasTag("playerghost") then
    inst.AnimState:SetBank("goosemoose")
    inst.AnimState:SetBuild("goosemoose_build")
    inst:SetStateGraph("SGmoosegooseplayer")
	end
	inst.components.hunger:Pause()
	inst.components.sanity.ignore = true
	if MOBPVPMODE == "Enable" then
		PvPTeleport(inst)
	end
end

local MOOSE_SCALE = 1.55

SetSharedLootTable( 'moosegooseplayer',
{
    {'meat',             1.00},
    {'meat',             1.00},
    {'meat',             1.00},
    {'meat',             1.00},
    {'meat',             1.00},
    {'meat',             1.00},
    {'drumstick',        1.00},
    {'drumstick',        1.00},
    {'goose_feather',    1.00},
    {'goose_feather',    1.00},
    {'goose_feather',    1.00},
    {'goose_feather',    0.33},
    {'goose_feather',    0.33},
})

local function RemovePenalty(inst)
	inst.components.health:DeltaPenalty(-1.00) --Removes health penalty when reviving
	--inst.components.health:DoDelta(20000, false) --Returns heals to max health upon reviving
end

local common_postinit = function(inst) 
	inst.soundsname = "wilson"
	
	inst.MiniMapEntity:SetIcon( "moosegooseplayer.tex" )
	
	inst:DoTaskInTime(0, function()
   if ThePlayer then
      inst:EnableMovementPrediction(false)
   end
end)
	inst:WatchWorldState( "isday", function() SetNightVision(inst) end)
  	inst:WatchWorldState( "isdusk", function() SetNightVision(inst) end)
  	inst:WatchWorldState( "isnight", function() SetNightVision(inst)  end)
	inst:WatchWorldState( "iscaveday", function() SetNightVision(inst) end)
  	inst:WatchWorldState( "iscavedusk", function() SetNightVision(inst) end)
  	inst:WatchWorldState( "iscavenight", function() SetNightVision(inst)  end)
	
	SetNightVision(inst)
end

local function DontTriggerCreep(inst)
    inst.components.locomotor.walkspeed = (TUNING.MOOSE_WALK_SPEED)
	inst.components.locomotor.runspeed = (20)
end

local master_postinit = function(inst)
    inst.components.health:SetMaxHealth(TUNING.MOOSE_HEALTH)
	--inst:AddComponent("healthSRegenerate")
    inst.components.temperature.inherentinsulation = -TUNING.INSULATION_SMALL
	inst.AnimState:SetBuild("moosegoose_build")
	inst.OnSetSkin = function(skin_name)
    inst.AnimState:SetBuild("moosegoose_build")
	inst:SetStateGraph("SGmoosegooseplayer")
	end
	inst.AnimState:SetBank("moosegoose")
	inst:SetStateGraph("SGmoosegooseplayer")
	inst.components.talker:IgnoreAll()
	inst.components.hunger:Pause()
	inst.components.sanity.ignore = true
	inst.components.temperature:SetTemp(20)
	
  	local light = inst.entity:AddLight()
  	inst.Light:Enable(true)
	inst.Light:SetRadius(0)
	inst.Light:SetFalloff(.1)
	inst.Light:SetIntensity(.1)
	inst.Light:SetColour(245/255,40/255,0/255)
	
	SetNightVision(inst, true)
	
	inst.components.talker.colour = Vector3(127/255, 0/255, 0/255)
	inst:ListenForEvent("respawnfromghost", RestoreNightvision)
	
	inst:DoTaskInTime(0, setChar)
	inst:DoTaskInTime(3, setSkin)
    inst:ListenForEvent("respawnfromghost", function()
		inst:DoTaskInTime(3, function()  inst.components.health:SetInvincible(false)
            if inst.components.playercontroller ~= nil then
				inst.components.playercontroller:EnableMapControls(true)
				inst.components.playercontroller:Enable(true)
			end
			inst.components.inventory:Show()
			inst:ShowActions(true)
            inst:ShowHUD(true)
            inst:SetCameraDistance()
			inst.sg:RemoveStateTag("busy")
            SerializeUserSession(inst) 
		end)
		inst:DoTaskInTime(5, DontTriggerCreep)
		inst:DoTaskInTime(6, RemovePenalty)
        inst:DoTaskInTime(6, setChar)
		inst:DoTaskInTime(6.1, setSkin)
		inst:DoTaskInTime(6, RestoreNightvision)
    end)
	
	inst.components.eater:SetDiet({ FOODTYPE.MEAT }, { FOODTYPE.MEAT })
    inst.components.eater:SetCanEatHorrible()
	
	inst.components.temperature.maxtemp = 60
	inst.components.temperature.mintemp = 20
	
	inst:AddComponent("heater")
	inst.components.heater.heat = MAX_HEAT

	inst.DynamicShadow:SetSize(6, 2.75)
	local s = 1
	inst.Transform:SetScale(s,s,s)

	MakeGiantCharacterPhysics(inst, 5000, 1)


	inst.components.locomotor.walkspeed = TUNING.MOOSE_WALK_SPEED
	inst.components.locomotor.runspeed = 20
	inst.components.health.destroytime = 3
	inst.components.locomotor.fasteronroad = false
	
	inst.components.combat:SetDefaultDamage(150)
	inst.components.combat.playerdamagepercent = MOBPVP
	inst.components.combat:SetRange(TUNING.MOOSE_ATTACK_RANGE)
	--inst.components.combat:SetAreaDamage(6, 0.8)
	inst.Transform:SetScale(1.55,1.55,1.55)
	inst.components.combat.hiteffectsymbol = "goosemoose_body"
	inst.components.combat:SetAttackPeriod(TUNING.MOOSE_ATTACK_PERIOD)
	inst.components.combat:SetHurtSound("dontstarve_DLC001/creatures/moose/hurt")
	
    inst:AddTag("moose")
    inst:AddTag("epic")
	inst:AddComponent("entitytracker")
	--inst:AddComponent("timer")
	MakeLargeBurnableCharacter(inst, "swap_fire")
	
	inst.taunt = true
	inst.mobplayer = true
	inst.mobsleep = true
	inst.specialatk2 = true
	inst.specialatk = true
	inst.ghostbuild = "ghost_monster_build"
	inst.mobteleported = false
	inst.isshiny = 0
	
	inst.userfunctions =
	{
		StartTimer = StartTimer,	
	}
	
	inst.charge_task = nil
    inst.charge_time = 0
	
	inst.OnLongUpdate = OnLongUpdate
	inst.OnSave = onsave
	inst.OnLoad = onload
	
    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetChanceLootTable('moosegooseplayer')
	
    return inst
	
end

if SKIN_RARITY_COLORS.ModMade ~= nil then
AddModCharacterSkin("moosegooseplayer", 1, {normal_skin = "deerclops_shiny_build_01", ghost_skin = "ghost_monster_build"}, {"deerclops_shiny_build_01", "ghost_monster_build"}, {"DEERPLAYER", "FORMAL"})
end

return MakePlayerCharacter("moosegooseplayer", prefabs, assets, common_postinit, master_postinit, start_inv)
